/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.shareddefaults;

import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEngineHelper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedDefaults
extends HashMap<String, String> {
    private static final long serialVersionUID = 0L;
    Document document;
    private File parsedXML;
    private File backUpSharedXML;
    private HashMap<String, String> iSharedDefaultsMap = new HashMap();
    private HashMap<String, String> persistDataMap = new HashMap();
    private HashMap<String, String> tableDataMap = new HashMap();
    private static final String SharedDefaultsXML = "shareddefaults.xml";
    private static final String BackUpSharedDefaultsXML = "shareddefaults.backup.xml";
    private static final String SharedRoot = "SharedRoot";
    private static final String SharedProperty = "SharedProperty";
    public static final String SET = "SET";
    public static final String GET = "GET";
    public static final String ResourceFolder = "resources";
    private static SharedDefaults SHAREDDEFAULTS = null;

    static {
        SHAREDDEFAULTS = new SharedDefaults();
    }

    public static SharedDefaults getSharedDefaultsInstance() {
        return SHAREDDEFAULTS;
    }

    public SharedDefaults() {
        this.parsedXML = TemplateEngineHelper.getSharedDefaultLocation(SharedDefaultsXML);
        this.backUpSharedXML = TemplateEngineHelper.getSharedDefaultLocation(BackUpSharedDefaultsXML);
        if (this.backUpSharedXML.exists()) {
            this.swapXML();
        }
        this.initSharedDefaults();
    }

    private void initSharedDefaults() {
        String key = null;
        String value = null;
        try {
            long length = this.parsedXML.length();
            if (length == 0L) {
                this.parsedXML = this.createDefaultXMLFormat(this.parsedXML);
            }
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
        List<Element> sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int listSize = sharedElementList.size();
        int i = 0;
        while (i < listSize) {
            Element xmlElement = sharedElementList.get(i);
            key = xmlElement.getAttribute("Id");
            value = xmlElement.getAttribute("Value");
            this.iSharedDefaultsMap.put(key, value);
            ++i;
        }
    }

    public void updateShareDefaultsMap(Map<String, String> aSharedMap) {
        this.iSharedDefaultsMap.putAll(aSharedMap);
        this.persistSharedValueMap();
    }

    public void persistSharedValueMap() {
        this.generateSharedXML(this.backUpSharedXML);
        this.generateSharedXML(this.parsedXML);
        this.swapXML();
    }

    public Map<String, String> getSharedDefaultsMap() {
        return this.iSharedDefaultsMap;
    }

    public void addToBackEndStorage(String aName, String aValue) {
        if (this.iSharedDefaultsMap != null) {
            this.tableDataMap.putAll(this.iSharedDefaultsMap);
        }
        this.tableDataMap.put(aName, aValue);
        this.updateShareDefaultsMap(this.tableDataMap);
    }

    public void updateToBackEndStorage(String aUpdateName, String aUpdateValue) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
        this.persistDataMap.putAll(this.iSharedDefaultsMap);
        List<Element> sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int elementListSize = sharedElementList.size();
        int i = 0;
        while (i < elementListSize) {
            Element xmlElement = sharedElementList.get(i);
            String name = xmlElement.getAttribute("Id");
            if (aUpdateName.equals(name)) {
                this.persistDataMap.put(aUpdateName, aUpdateValue);
            }
            ++i;
        }
        this.updateShareDefaultsMap(this.persistDataMap);
    }

    public void deleteBackEndStorage(String[] aDeleteName) {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.parsedXML.toURL().openStream());
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
        List<Element> sharedElementList = TemplateEngine.getChildrenOfElement(this.document.getDocumentElement());
        int elementListSize = sharedElementList.size();
        int i = 0;
        while (i < elementListSize) {
            Element xmlElement = sharedElementList.get(i);
            String name = xmlElement.getAttribute("Id");
            int k = 0;
            while (k < aDeleteName.length) {
                if (aDeleteName[k].equals(name)) {
                    xmlElement.removeAttribute(name);
                    this.iSharedDefaultsMap.remove(name);
                }
                ++k;
            }
            ++i;
        }
        this.updateShareDefaultsMap(this.iSharedDefaultsMap);
    }

    private File createDefaultXMLFormat(File xmlFile) {
        Document d;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            TemplateEngine.log(e);
            return xmlFile;
        }
        Node rootElement = d.appendChild(d.createElement(SharedRoot));
        Element element = (Element)rootElement.appendChild(d.createElement(SharedProperty));
        element.setAttribute("Id", "");
        element.setAttribute("Value", "");
        DOMSource domSource = new DOMSource(d);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StreamResult fileResult = new StreamResult(xmlFile);
        try {
            transFactory.newTransformer().transform(domSource, fileResult);
        }
        catch (Throwable t) {
            TemplateEngine.log(t);
        }
        return xmlFile;
    }

    private void generateSharedXML(File xmlFile) {
        Document d;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            TemplateEngine.log(e);
            return;
        }
        Node rootElement = d.appendChild(d.createElement(SharedRoot));
        for (String key : this.iSharedDefaultsMap.keySet()) {
            Element element = (Element)rootElement.appendChild(d.createElement(SharedProperty));
            element.setAttribute("Id", key);
            element.setAttribute("Value", this.iSharedDefaultsMap.get(key));
        }
        DOMSource domSource = new DOMSource(d);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StreamResult fileResult = new StreamResult(xmlFile);
        try {
            transFactory.newTransformer().transform(domSource, fileResult);
        }
        catch (Throwable t) {
            TemplateEngine.log(t);
        }
    }

    private void swapXML() {
        if (this.parsedXML.exists()) {
            this.parsedXML.delete();
        }
        this.backUpSharedXML.renameTo(this.parsedXML);
    }
}

