/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.shareddefaults;

import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.shareddefaults.SharedDefaults;
import com.symbian.cdt.templateengine.shareddefaults.TemplateInputDialog;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class SymbianPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String EditButton = "   Edit...   ";
    private static final String DeleteButton = "   Remove     ";
    private static final String PageDescription = "Strings indicate the default input values shared among templates";
    public static final String Blank = "";
    public static final String Message = "Message from Dialog Validator";
    protected static final String DuplicateEntry = "Duplicate Entry!";
    private static final String DeleteValidator = "Are you sure want to delete ?";
    private static final String DeleteShellMessage = "Delete a shared default value";
    private static final String TableToolTip = "Templates Global Values Table";
    private static final String EditToolTip = "Updates changed key-value pair";
    private static final String DeleteToolTip = "Deletes key-value pair";
    private static TemplateInputDialog inputDialog;
    private static SharedDefaults iSharedDefaults;
    private int columnWidth = 100;
    private int columnWeight = 50;
    private String[] columnNames;
    private static List<Element> sharedElementList;
    private int attrListSize;
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(this.columnWeight, this.columnWidth), new ColumnWeightData(this.columnWeight, this.columnWidth)};
    private String pageID;
    private String SharedContextHelpID = "shared_defaults_help";
    private Button editButton;
    private Button deleteButton;
    private static boolean isDeleted;
    private boolean isRedundant;
    public static boolean isDup;
    private static String[] delItemNames;
    private static Table table;
    protected static final int OPTION_ADD = 0;
    protected static final int OPTION_EDIT = 1;
    private String aName;
    private String aValue;

    static {
        iSharedDefaults = SharedDefaults.getSharedDefaultsInstance();
        delItemNames = null;
    }

    public SymbianPreferencePage() {
        this.noDefaultAndApplyButton();
        this.initializeDefaults();
    }

    public SymbianPreferencePage(String aName, String aValue) {
        this.aName = aName;
        this.aValue = aValue;
    }

    private void initializeDefaults() {
        this.columnNames = new String[]{"Id", "Value"};
        this.pageID = "com.symbian.cdt.templateengine." + this.SharedContextHelpID;
        this.setTableAttributes();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label pageLabel = new Label(composite, 0);
        pageLabel.setText(PageDescription);
        Composite subComposite = new Composite(parent, 0);
        GridLayout subLayout = new GridLayout(2, false);
        GridData gridData = new GridData(1808);
        subComposite.setLayout((Layout)subLayout);
        subComposite.setLayoutData((Object)gridData);
        this.addFirstSection(subComposite);
        this.addSecondSection(subComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(super.getControl(), this.pageID);
        return subComposite;
    }

    private void addFirstSection(Composite parent) {
        this.createTable(parent);
        this.setTableAttributes();
        this.addXMLDataIntoTable();
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        this.addButtonControls(composite);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void createTable(Composite aComposite) {
        table = new Table(aComposite, 1116930);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setToolTipText(TableToolTip);
        if (this.attrListSize == 0) {
            this.attrListSize = 2;
        }
        int nCols = 0;
        while (nCols < this.attrListSize) {
            layout.addColumnData(this.columnLayouts[nCols]);
            TableColumn tColumn = new TableColumn(table, 16384, nCols);
            tColumn.setWidth(this.columnWidth);
            tColumn.setText(this.columnNames[nCols]);
            ++nCols;
        }
        this.addTableListener();
    }

    private void addTableListener() {
        SelectionAdapter sListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = table.isSelected(table.getSelectionIndex());
                int selectionCount = table.getSelectionCount();
                if (isSelected) {
                    SymbianPreferencePage.this.editButton.setEnabled(true);
                    SymbianPreferencePage.this.deleteButton.setEnabled(true);
                }
                if (selectionCount > 1) {
                    SymbianPreferencePage.this.editButton.setEnabled(false);
                }
            }
        };
        table.addSelectionListener((SelectionListener)sListener);
    }

    private void addXMLDataIntoTable() {
        int i = 0;
        int l = sharedElementList.size();
        while (i < l) {
            Element xmlElement = sharedElementList.get(i);
            String name = xmlElement.getAttribute("Id");
            String value = xmlElement.getAttribute("Value");
            if (name.equals(Blank) && value.equals(Blank)) {
                return;
            }
            String[] backEndData = new String[]{name, value};
            TableItem backEndItem = new TableItem(table, 0);
            int data = 0;
            while (data < backEndData.length) {
                if (backEndData[data] != null) {
                    backEndItem.setText(data, backEndData[data]);
                }
                ++data;
            }
            ++i;
        }
    }

    private void addButtonControls(Composite aComposite) {
        this.editButton = new Button(aComposite, 8);
        this.editButton.setText(EditButton);
        this.editButton.setEnabled(false);
        this.editButton.setToolTipText(EditToolTip);
        this.addButtonListener(this.editButton);
        this.deleteButton = new Button(aComposite, 8);
        this.deleteButton.setText(DeleteButton);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText(DeleteToolTip);
        this.addButtonListener(this.deleteButton);
    }

    public void addButtonListener(Button aButton) {
        inputDialog = new TemplateInputDialog(this.getShell());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String editItemString;
                if (e.getSource().equals(SymbianPreferencePage.this.editButton) && (editItemString = SymbianPreferencePage.getSelectedItemNameFromTable()) != null && editItemString != SymbianPreferencePage.Blank) {
                    inputDialog.open(inputDialog, 1);
                }
                if (e.getSource().equals(SymbianPreferencePage.this.deleteButton)) {
                    SymbianPreferencePage.this.deleteRow();
                    SymbianPreferencePage.this.editButton.setEnabled(false);
                    SymbianPreferencePage.this.deleteButton.setEnabled(false);
                }
            }
        };
        aButton.addSelectionListener((SelectionListener)listener);
    }

    public void addNewDataIntoTable() {
        String[] addData = new String[]{this.aName, this.aValue};
        if (!isDeleted) {
            TableItem[] duplicateItems = table.getItems();
            TableItem duplicateItem = null;
            int nItems = 0;
            while (nItems < duplicateItems.length) {
                int result;
                duplicateItem = duplicateItems[nItems];
                String duplicateString = duplicateItem.getText();
                if (duplicateString.equals(this.aName) && (result = inputDialog.popDuplicate()) == 32) {
                    isDup = this.isRedundant = true;
                    break;
                }
                ++nItems;
            }
            if (!this.isRedundant) {
                TableItem tableItem = new TableItem(table, 0);
                int data = 0;
                while (data < addData.length) {
                    tableItem.setText(data, addData[data]);
                    ++data;
                }
                this.isRedundant = false;
            }
        }
        iSharedDefaults.addToBackEndStorage(this.aName, this.aValue);
    }

    private int getAttributeSize() {
        try {
            int listSize = sharedElementList.size();
            int i = 0;
            while (i < listSize) {
                Element xmlElement = sharedElementList.get(i++);
                this.attrListSize = xmlElement.getAttributes().getLength();
            }
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
        return this.attrListSize;
    }

    private void setTableAttributes() {
        try {
            SharedDefaults sharedTemp = new SharedDefaults();
            sharedElementList = TemplateEngine.getChildrenOfElement(sharedTemp.document.getDocumentElement());
            this.attrListSize = this.getAttributeSize();
            iSharedDefaults.putAll(sharedTemp.getSharedDefaultsMap());
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void updateDataInTheTable() {
        try {
            int selectedItemIndex = table.getSelectionIndex();
            TableItem selectedItem = table.getItem(selectedItemIndex);
            String[] updateString = new String[]{this.aName, this.aValue};
            selectedItem.setText(updateString);
            iSharedDefaults.updateToBackEndStorage(this.aName, this.aValue);
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
    }

    public static String getSelectedItemNameFromTable() {
        String selectedItemName = null;
        int selectedItemIndex = 0;
        try {
            selectedItemIndex = table.getSelectionIndex();
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
        TableItem selectedItem = table.getItem(selectedItemIndex);
        selectedItemName = selectedItem.getText();
        return selectedItemName;
    }

    private void deleteRow() {
        int result = 0;
        String nonEmptyItemString = SymbianPreferencePage.getSelectedItemNameFromTable();
        if (nonEmptyItemString != null) {
            result = this.confirmdeleteContents(nonEmptyItemString);
        }
        if (result == 32) {
            int[] itemSelected = table.getSelectionIndices();
            table.remove(itemSelected);
        } else if (result == 256) {
            isDeleted = false;
        }
        if (delItemNames != null) {
            iSharedDefaults.deleteBackEndStorage(delItemNames);
        }
    }

    private int confirmdeleteContents(String aSelectedItems) {
        int result = 0;
        TableItem[] deleteItems = null;
        if (aSelectedItems != Blank) {
            deleteItems = table.getSelection();
            delItemNames = new String[deleteItems.length];
            int nDel = 0;
            while (nDel < deleteItems.length) {
                TableItem item = deleteItems[nDel];
                SymbianPreferencePage.delItemNames[nDel] = item.getText();
                ++nDel;
            }
            MessageBox mBox = new MessageBox(new Shell(), 292);
            mBox.setText(DeleteShellMessage);
            mBox.setMessage(DeleteValidator);
            result = mBox.open();
        }
        return result;
    }
}

