/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.shareddefaults;

import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.shareddefaults.SymbianPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TemplateInputDialog
extends Dialog {
    private static final String Name = "Name :";
    private static final String Value = "Value :";
    private static final String AddShellMessage = "Add a shared default value";
    private static final String EditShellMessage = "Edit a shared default value";
    private static final String Pattern = "[\\s0-9a-zA-Z.]*";
    private Label errMessageLabel;
    private String labelMessage = "Template data must not be empty";
    private static final int TEXT_LIMIT = 100;
    private SymbianPreferencePage aSymbianPage;
    private TemplateInputDialog sharedDialog;
    private Shell shell;
    private Display display;
    private Label valueLabel;
    private Label nameLabel;
    private Text valueText;
    private Text nameText;
    private Button oKButton;
    private int aOption;
    private Composite parent;

    protected TemplateInputDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.shell = shell;
        shell.setBounds(420, 280, 300, 160);
        this.display = shell.getDisplay();
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.createControls(composite);
        return composite;
    }

    public void open(TemplateInputDialog myDialog, int dataOption) {
        this.aOption = dataOption;
        this.sharedDialog = myDialog;
        this.sharedDialog.create();
        Button oK = this.getButton(0);
        oK.setEnabled(false);
        if (this.aOption == 0) {
            this.shell.setText(AddShellMessage);
        } else if (this.aOption == 1) {
            this.shell.setText(EditShellMessage);
        }
        this.sharedDialog.open();
    }

    private void createControls(Composite aComposite) {
        this.nameLabel = new Label(aComposite, 0);
        this.nameLabel.setText(Name);
        this.nameText = new Text(aComposite, 2052);
        this.nameText.setTextLimit(100);
        GridData textData = new GridData(768);
        textData.horizontalSpan = 1;
        this.nameText.setLayoutData((Object)textData);
        this.addTextListener(this.nameText);
        this.valueLabel = new Label(aComposite, 0);
        this.valueLabel.setText(Value);
        this.valueText = new Text(aComposite, 2052);
        this.valueText.setTextLimit(100);
        GridData valueData = new GridData(768);
        valueData.horizontalSpan = 1;
        valueData.verticalSpan = 5;
        this.valueText.setLayoutData((Object)valueData);
        this.addTextListener(this.valueText);
        Color color = this.display.getSystemColor(3);
        Composite labelComposite = new Composite(this.parent, 0);
        labelComposite.setLayout((Layout)new GridLayout());
        labelComposite.setLayoutData((Object)new GridData(768));
        this.errMessageLabel = new Label(labelComposite, 4);
        this.errMessageLabel.setForeground(color);
        this.errMessageLabel.setText(this.labelMessage);
        this.errMessageLabel.setVisible(false);
        if (this.aOption == 1) {
            this.nameLabel.setEnabled(false);
            this.nameText.setEnabled(false);
            String name = SymbianPreferencePage.getSelectedItemNameFromTable();
            if (name != null) {
                this.nameText.setText(name);
            }
        }
    }

    public void addTextListener(final Text aText) {
        ModifyListener mListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String nameField = aText.getText();
                TemplateInputDialog.this.textChanged(nameField);
            }
        };
        aText.addModifyListener(mListener);
    }

    protected void okPressed() {
        String value;
        String name;
        if (this.aOption == 0) {
            name = this.nameText.getText();
            value = this.valueText.getText();
            if (name != "" && value != "") {
                this.aSymbianPage = new SymbianPreferencePage(name, value);
                this.aSymbianPage.addNewDataIntoTable();
                if (SymbianPreferencePage.isDup) {
                    this.nameText.setText("");
                    this.nameText.setFocus();
                    SymbianPreferencePage.isDup = false;
                } else if (!SymbianPreferencePage.isDup) {
                    this.nameText.setFocus();
                    this.sharedDialog.close();
                }
            }
        }
        if (this.aOption == 1) {
            name = this.nameText.getText();
            value = this.valueText.getText();
            if (!value.equals("")) {
                this.aSymbianPage = new SymbianPreferencePage(name, value);
                this.aSymbianPage.updateDataInTheTable();
            }
            this.sharedDialog.close();
        }
    }

    public int popDuplicate() {
        MessageBox mBox = new MessageBox(new Shell(), 2);
        mBox.setText("Message from Dialog Validator");
        mBox.setMessage("Duplicate Entry!");
        int result = mBox.open();
        return result;
    }

    protected void cancelPressed() {
        this.sharedDialog.close();
    }

    private void textChanged(String textField) {
        this.errMessageLabel.setVisible(false);
        try {
            if (textField.matches("")) {
                this.oKButton = this.getButton(0);
                this.errMessageLabel.setText(this.labelMessage);
                this.errMessageLabel.setVisible(true);
                this.oKButton.setEnabled(false);
            }
            if (!textField.matches(Pattern)) {
                this.oKButton = this.getButton(0);
                this.oKButton.setEnabled(false);
            } else if (!this.nameText.getText().equals("") && !this.valueText.getText().equals("")) {
                this.oKButton = this.getButton(0);
                this.oKButton.setEnabled(true);
            }
        }
        catch (Exception exp) {
            TemplateEngine.log(exp);
        }
    }
}

