/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEnginePlugin;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.ui.pages.UIWizardPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;

public abstract class TemplateDrivenWizard
extends Wizard {
    protected List<IWizardPage> pagesBeforeTemplatePages = new ArrayList<IWizardPage>();
    protected List<IWizardPage> pagesAfterTemplatePages = new ArrayList<IWizardPage>();
    protected Template template;
    protected int pageIndex;
    protected Map<String, UIWizardPage> templatePages;
    protected Composite pageContainer;
    protected List<String> templatePagesOrderVector;

    public final void addPage(IWizardPage page) {
        page.setWizard((IWizard)this);
    }

    public final void addPages() {
        IWizardPage page;
        IWizardPage[] iWizardPageArray = this.getPagesBeforeTemplatePages();
        int n = 0;
        int n2 = iWizardPageArray.length;
        while (n < n2) {
            page = iWizardPageArray[n];
            this.addPageBeforeTemplatePages(page);
            ++n;
        }
        iWizardPageArray = this.getPagesAfterTemplatePages();
        n = 0;
        n2 = iWizardPageArray.length;
        while (n < n2) {
            page = iWizardPageArray[n];
            this.addPageAfterTemplatePages(page);
            ++n;
        }
    }

    private void addPageBeforeTemplatePages(IWizardPage page) {
        this.addPage(page);
        this.pagesBeforeTemplatePages.add(page);
    }

    private void addPageAfterTemplatePages(IWizardPage page) {
        this.addPage(page);
        this.pagesAfterTemplatePages.add(page);
    }

    protected abstract IWizardPage[] getPagesBeforeTemplatePages();

    protected abstract IWizardPage[] getPagesAfterTemplatePages();

    protected abstract Template getTemplate();

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.pageIndex > this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size()) {
            --this.pageIndex;
            return this.pagesAfterTemplatePages.get(this.pageIndex - this.pagesBeforeTemplatePages.size() - this.templatePagesOrderVector.size());
        }
        if (this.pageIndex > this.pagesBeforeTemplatePages.size()) {
            --this.pageIndex;
            return this.templatePages.get(this.templatePagesOrderVector.get(this.pageIndex - this.pagesBeforeTemplatePages.size()));
        }
        if (this.pageIndex > 0) {
            --this.pageIndex;
            return this.pagesBeforeTemplatePages.get(this.pageIndex);
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() - 1) {
            ++this.pageIndex;
            return this.pagesBeforeTemplatePages.get(this.pageIndex);
        }
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size() - 1) {
            if (this.pageIndex == this.pagesBeforeTemplatePages.size() - 1) {
                Template template = this.getTemplate();
                if (this.template != null && !this.template.equals(template)) {
                    this.template = template;
                    this.templatePages = template.getUIPages((IWizard)this);
                    this.templatePagesOrderVector = template.getPagesOrderVector();
                }
            }
            ++this.pageIndex;
            IWizardPage nextPage = this.templatePages.get(this.templatePagesOrderVector.get(this.pageIndex - this.pagesBeforeTemplatePages.size()));
            nextPage.setWizard((IWizard)this);
            if (nextPage.getControl() == null) {
                nextPage.createControl(this.pageContainer);
            }
            return nextPage;
        }
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size() + this.pagesAfterTemplatePages.size() - 1) {
            ++this.pageIndex;
            return this.pagesAfterTemplatePages.get(this.pageIndex - this.pagesBeforeTemplatePages.size() - this.templatePagesOrderVector.size());
        }
        return null;
    }

    public final boolean canFinish() {
        for (IWizardPage iWizardPage : this.pagesBeforeTemplatePages) {
            if (iWizardPage.isPageComplete()) continue;
            return false;
        }
        if (this.templatePages == null) {
            return false;
        }
        for (IWizardPage iWizardPage : this.templatePages.values()) {
            if (iWizardPage.isPageComplete()) continue;
            return false;
        }
        for (IWizardPage iWizardPage : this.pagesAfterTemplatePages) {
            if (iWizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        IStatus[] statuses = this.template.executeTemplateProcesses(false);
        if (statuses.length == 1 && statuses[0].getException() instanceof ProcessFailureException) {
            TemplateEngine.showError(statuses[0].getMessage(), statuses[0].getException());
            return false;
        }
        String msg = "Successful";
        TemplateEngine.showStatusDialog(msg, (IStatus)new MultiStatus(TemplateEnginePlugin.getUniqueId(), 0, statuses, msg, null));
        return true;
    }

    public final void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.pageContainer = pageContainer;
    }
}

