/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.ui.FormBrowser;
import com.symbian.cdt.templateengine.ui.TemplatesChoiceWizard;
import com.symbian.cdt.templateengine.ui.WizardNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TemplateListSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener {
    private String labelText;
    private FormBrowser descriptionBrowser;
    private TableViewer wizardSelectionViewer;
    private TemplatesChoiceWizard parentWizard;
    private Template[] templates;

    public TemplateListSelectionPage(TemplatesChoiceWizard parentWizard) {
        super("Template Selection");
        this.setTitle("Templates");
        this.setDescription("Select one of the following available templates.");
        this.labelText = "Select a template";
        this.descriptionBrowser = new FormBrowser();
        this.descriptionBrowser.setText("");
        this.parentWizard = parentWizard;
    }

    public void createDescriptionIn(Composite composite) {
        this.descriptionBrowser.createControl(composite);
        Control c = this.descriptionBrowser.getControl();
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        c.setLayoutData((Object)gd);
    }

    public String getLabel() {
        return this.labelText;
    }

    public void setDescriptionText(String text) {
        this.descriptionBrowser.setText(text);
    }

    public void setDescriptionEnabled(boolean enabled) {
        Control control = this.descriptionBrowser.getControl();
        if (control != null) {
            control.setEnabled(enabled);
        }
    }

    public void moveToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(this.getLabel());
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(container, 256);
        gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        this.wizardSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new NameProvider());
        this.wizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TemplateListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)TemplateListSelectionPage.this.wizardSelectionViewer, TemplateListSelectionPage.this.wizardSelectionViewer.getSelection()));
                TemplateListSelectionPage.this.moveToNextPage();
            }
        });
        this.createDescriptionIn((Composite)sashForm);
        this.wizardSelectionViewer.setInput((Object)this.templates);
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Template currentWizardSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            currentWizardSelection = (Template)iter.next();
        }
        if (currentWizardSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            return;
        }
        Template finalSelection = currentWizardSelection;
        this.setSelectedNode(new WizardNode(this, finalSelection));
        this.setDescriptionText(finalSelection.getDescription());
        this.getContainer().updateButtons();
    }

    public Template getTemplate() {
        IWizardNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            return ((WizardNode)selectedNode).getTemplate();
        }
        return null;
    }

    public IWizardPage getNextPage(boolean shouldCreate) {
        if (!shouldCreate) {
            return super.getNextPage();
        }
        IWizardNode selectedNode = this.getSelectedNode();
        selectedNode.dispose();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            super.setSelectedNode(null);
            return null;
        }
        if (shouldCreate) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    public boolean canFlipToNextPage() {
        IStructuredSelection ssel = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        return ssel != null && !ssel.isEmpty();
    }

    public void setVisible(boolean visible) {
        Object[] templates;
        if (visible && !Arrays.equals(templates = this.parentWizard.getTemplates(), this.templates)) {
            this.templates = templates;
            this.wizardSelectionViewer.setInput((Object)templates);
            this.wizardSelectionViewer.refresh();
        }
        super.setVisible(visible);
        if (visible) {
            this.wizardSelectionViewer.getTable().setFocus();
        }
    }

    Map<String, String> getDataInPreviousPages() {
        return this.parentWizard.getAllDataInNonTemplatePages();
    }

    private static class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object element) {
            return (Object[])element;
        }
    }

    private static class NameProvider
    extends LabelProvider
    implements ITableLabelProvider {
        NameProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Template) {
                return ((Template)obj).getLabel();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

