/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.ui.TemplateListSelectionPage;
import com.symbian.cdt.templateengine.ui.pages.UIWizardPage;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

class WizardNode
implements IWizardNode {
    private IWizard wizard;
    private Template template;
    private TemplateListSelectionPage parentPage;

    public WizardNode(TemplateListSelectionPage parentPage, Template template) {
        this.parentPage = parentPage;
        this.template = template;
    }

    public void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        this.wizard = new Wizard(){
            {
                this.setWindowTitle(WizardNode.this.template.getLabel());
            }

            public void addPages() {
                Map<String, UIWizardPage> pages = WizardNode.this.template.getUIPages((IWizard)this);
                for (String id : WizardNode.this.template.getPagesOrderVector()) {
                    this.addPage(pages.get(id));
                }
            }

            public boolean performFinish() {
                Map<String, String> valueStore = WizardNode.this.template.getValueStore();
                IWizardPage[] iWizardPageArray = this.getPages();
                int n = 0;
                int n2 = iWizardPageArray.length;
                while (n < n2) {
                    IWizardPage page = iWizardPageArray[n];
                    valueStore.putAll(((UIWizardPage)page).getPageData());
                    ++n;
                }
                WizardNode.this.template.getValueStore().putAll(WizardNode.this.parentPage.getDataInPreviousPages());
                return true;
            }

            public void createPageControls(Composite pageContainer) {
                super.createPageControls(pageContainer);
                IWizardPage[] iWizardPageArray = this.getPages();
                int n = 0;
                int n2 = iWizardPageArray.length;
                while (n < n2) {
                    IWizardPage page = iWizardPageArray[n];
                    ((UIWizardPage)page).getComposite().getUIElement().setValues(WizardNode.this.template.getValueStore());
                    ++n;
                }
            }
        };
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

