/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui.pages;

import com.symbian.cdt.templateengine.ui.event.PatternEvent;
import com.symbian.cdt.templateengine.ui.event.PatternEventListener;
import com.symbian.cdt.templateengine.ui.pages.UIPage;
import com.symbian.cdt.templateengine.ui.uitree.UIElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIWizardPage
extends UIPage
implements IWizardPage,
PatternEventListener {
    HashMap<Object, String> validInvalid;
    private String iName;
    private IWizard iWizard = null;
    private boolean isPageComplete = true;
    private IWizardPage iPreviousPage = null;

    public UIWizardPage(String aTitle, String aPageName, UIElement aUIElement, Map<String, String> aValueStore) {
        super(aTitle, aUIElement, aValueStore);
        this.iName = aPageName;
        this.validInvalid = new HashMap();
    }

    public boolean canFlipToNextPage() {
        boolean retVal = false;
        if (this.isPageComplete() && this.getNextPage() != null) {
            retVal = true;
        }
        return retVal;
    }

    protected IWizardContainer getContainer() {
        if (this.iWizard == null) {
            return null;
        }
        return this.iWizard.getContainer();
    }

    protected IDialogSettings getDialogSettings() {
        if (this.iWizard == null) {
            return null;
        }
        return this.iWizard.getDialogSettings();
    }

    public Image getImage() {
        Image result = super.getImage();
        if (result == null && this.iWizard != null) {
            return this.iWizard.getDefaultPageImage();
        }
        return result;
    }

    public String getName() {
        return this.iName;
    }

    public IWizardPage getNextPage() {
        if (this.iWizard == null) {
            return null;
        }
        return this.iWizard.getNextPage((IWizardPage)this);
    }

    public IWizardPage getPreviousPage() {
        if (this.iPreviousPage != null) {
            return this.iPreviousPage;
        }
        if (this.iWizard == null) {
            return null;
        }
        return this.iWizard.getPreviousPage((IWizardPage)this);
    }

    public Shell getShell() {
        IWizardContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getShell();
    }

    public IWizard getWizard() {
        return this.iWizard;
    }

    protected boolean isCurrentPage() {
        boolean retVal = false;
        if (this.getContainer() != null && this == this.getContainer().getCurrentPage()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    public void setPageComplete(boolean aComplete) {
        this.isPageComplete = aComplete;
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }

    public void setPreviousPage(IWizardPage aPage) {
        this.iPreviousPage = aPage;
    }

    public void setWizard(IWizard aNewWizard) {
        this.iWizard = aNewWizard;
    }

    public String toString() {
        return this.iName;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        super.getComposite().addPatternListener(this);
        this.setPageComplete(super.getComposite().isValid());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(super.getControl(), this.pageId);
    }

    @Override
    public void patternPerformed(PatternEvent aPet) {
        if (!aPet.getValid()) {
            this.validInvalid.put(aPet.getSource(), aPet.toString());
            this.setErrorMessage(this.getErrorString());
            this.setPageComplete(this.validInvalid.isEmpty());
        } else {
            this.validInvalid.remove(aPet.getSource());
            this.setPageComplete(this.validInvalid.isEmpty());
            if (this.validInvalid.isEmpty()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.getErrorString());
            }
        }
        this.getContainer().updateMessage();
    }

    private String getErrorString() {
        Iterator<Object> iterator = this.validInvalid.keySet().iterator();
        String message = "";
        while (iterator.hasNext()) {
            message = String.valueOf(message) + this.validInvalid.get(iterator.next());
        }
        return message;
    }
}

