/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui.uitree;

import com.symbian.cdt.templateengine.TemplateDescriptor;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.ui.uitree.GenericUIElementGroup;
import com.symbian.cdt.templateengine.ui.uitree.IUIElementTreeBuilderHelper;
import com.symbian.cdt.templateengine.ui.uitree.InputUIElement;
import com.symbian.cdt.templateengine.ui.uitree.SimpleUIElementGroup;
import com.symbian.cdt.templateengine.ui.uitree.UIAttributes;
import com.symbian.cdt.templateengine.ui.uitree.UIElement;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UIBooleanWidget;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UIBrowseWidget;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UISelectWidget;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UISpecialListWidget;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UIStringListWidget;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UITextWidget;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIElementTreeBuilderHelper
implements IUIElementTreeBuilderHelper {
    private TemplateDescriptor iTemplateDescriptor = null;
    private Element iElement;

    public UIElementTreeBuilderHelper(TemplateDescriptor aTemplateDescriptor) {
        this.iTemplateDescriptor = aTemplateDescriptor;
    }

    public List getPropertyGroupList() {
        return this.iTemplateDescriptor.getPropertyGroupList();
    }

    @Override
    public UIElement getUIElement(Element aElement) {
        this.iElement = aElement;
        UIElement retUIElement = null;
        UIAttributes<String, String> iUIAttributes = new UIAttributes<String, String>();
        NamedNodeMap list = aElement.getAttributes();
        int i = 0;
        int s = list.getLength();
        while (i < s) {
            Node attribute = list.item(i);
            iUIAttributes.put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        retUIElement = this.getUIWidget(iUIAttributes);
        return retUIElement;
    }

    private UIElement getUIWidget(UIAttributes<String, String> aUIAttributes) {
        String type = (String)aUIAttributes.get("type");
        UIElement widgetElement = null;
        String itemName = null;
        String itemValue = null;
        String itemSelected = null;
        String nameStr = null;
        String valueStr = null;
        String selected = null;
        if (new Boolean((String)aUIAttributes.get(InputUIElement.HIDDEN)).booleanValue()) {
            return null;
        }
        if (type.equalsIgnoreCase("") || type == null) {
            return null;
        }
        if (type.equalsIgnoreCase(InputUIElement.INPUTTYPE)) {
            widgetElement = new UITextWidget(aUIAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.MULTILINETYPE)) {
            widgetElement = new UITextWidget(aUIAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.SELECTTYPE)) {
            HashMap<String, String> itemMap = new HashMap<String, String>();
            List<Element> itemList = TemplateEngine.getChildrenOfElement(this.iElement);
            int i = 0;
            int l = itemList.size();
            while (i < l) {
                Element itemElement = itemList.get(i);
                NamedNodeMap itemAttrList = itemElement.getAttributes();
                int j = 0;
                int l1 = itemAttrList.getLength();
                while (j < l1) {
                    Node itemAttr = itemAttrList.item(j);
                    itemName = itemAttr.getNodeName();
                    itemValue = itemAttr.getNodeValue();
                    if (itemName.equals("label")) {
                        selected = itemValue;
                        nameStr = new String(itemValue);
                    } else if (itemName.equals(InputUIElement.NAME)) {
                        valueStr = new String(itemValue);
                    }
                    if (itemName.equals(InputUIElement.SELECTED) && itemValue.equals("true")) {
                        itemSelected = selected;
                    }
                    itemMap.put(nameStr, valueStr);
                    ++j;
                }
                ++i;
            }
            widgetElement = new UISelectWidget(aUIAttributes, itemMap, itemSelected);
        }
        if (type.equalsIgnoreCase(InputUIElement.BOOLEANTYPE)) {
            widgetElement = new UIBooleanWidget(aUIAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.BROWSETYPE)) {
            widgetElement = new UIBrowseWidget(aUIAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.STRINGLISTTYPE)) {
            widgetElement = new UIStringListWidget(aUIAttributes);
        }
        if (type.equalsIgnoreCase(InputUIElement.SPECIALLISTTYPE)) {
            widgetElement = new UISpecialListWidget(aUIAttributes);
        }
        if (type.equalsIgnoreCase(GenericUIElementGroup.PAGES_ONLY)) {
            widgetElement = new SimpleUIElementGroup(aUIAttributes);
        }
        type.equalsIgnoreCase(GenericUIElementGroup.PAGES_TAB);
        return widgetElement;
    }
}

