/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui.uitree;

import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.ui.exception.SimpleElementException;
import com.symbian.cdt.templateengine.ui.uitree.GenericUIElementGroup;
import com.symbian.cdt.templateengine.ui.uitree.IUIElementTreeBuilderManager;
import com.symbian.cdt.templateengine.ui.uitree.UIElement;
import com.symbian.cdt.templateengine.ui.uitree.UIElementTreeBuilderHelper;
import java.util.List;
import org.w3c.dom.Element;

public class UIElementTreeBuilderManager
implements IUIElementTreeBuilderManager {
    private UIElementTreeBuilderHelper iUIElementTreeBuilderHelper;
    private UIElement iUITreeRoot = null;

    public UIElementTreeBuilderManager(UIElementTreeBuilderHelper aUIElementTreeBuilderHelper) {
        this.iUIElementTreeBuilderHelper = aUIElementTreeBuilderHelper;
    }

    public void createUIElementTree(UIElement aUIParent, Element aElement) {
        if (aUIParent == null) {
            aUIParent = this.iUITreeRoot = this.iUIElementTreeBuilderHelper.getUIElement(aElement);
        }
        if (aUIParent != null && aUIParent instanceof GenericUIElementGroup) {
            List<Element> childList = TemplateEngine.getChildrenOfElement(aElement);
            int listIndex = 0;
            int l = childList.size();
            while (listIndex < l) {
                UIElement iUIEle = this.iUIElementTreeBuilderHelper.getUIElement(childList.get(listIndex));
                if (iUIEle != null) {
                    iUIEle.setParent(aUIParent);
                    try {
                        aUIParent.addToChildList(iUIEle);
                    }
                    catch (SimpleElementException exp) {
                        TemplateEngine.log(exp);
                    }
                    this.createUIElementTree(iUIEle, childList.get(listIndex));
                }
                ++listIndex;
            }
        }
    }

    public UIElement getUIElementTreeRoot() {
        return this.iUITreeRoot;
    }

    public void setUIElementTreeRootNull() {
        this.iUITreeRoot = null;
    }
}

