/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui.uitree.uiwidgets;

import com.symbian.cdt.templateengine.ui.uitree.InputUIElement;
import com.symbian.cdt.templateengine.ui.uitree.UIAttributes;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UIComposite;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControl;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIStringListWidget
extends InputUIElement {
    UIAttributes<String, String> iUIAttribute;
    FileListControl iFileListControl;
    Label iLabel;
    UIComposite iUIComposite;

    public UIStringListWidget(UIAttributes<String, String> aUIAttribute) {
        super(aUIAttribute);
        this.iUIAttribute = aUIAttribute;
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String[] items = this.iFileListControl.getItems();
        String itemString = new String();
        int i = 0;
        while (i < items.length) {
            itemString = String.valueOf(itemString) + items[i] + "|";
            ++i;
        }
        retMap.put((String)this.iUIAttribute.get("id"), itemString);
        return retMap;
    }

    @Override
    public void setValues(Map<String, String> aValueMap) {
        String items = aValueMap.get(this.iUIAttribute.get("id"));
        if (items != null) {
            items = items.trim();
            StringTokenizer st = new StringTokenizer(items, "|");
            String[] itemList = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                itemList[i] = st.nextToken();
                ++i;
            }
            this.iFileListControl.setList(itemList);
            this.iFileListControl.setSelection(0);
        }
    }

    @Override
    public void createWidgets(UIComposite aUIComposite) {
        GridData gridData = null;
        this.iUIComposite = aUIComposite;
        this.iLabel = new Label((Composite)aUIComposite, 16384);
        this.iLabel.setText((String)this.iUIAttribute.get(InputUIElement.WIDGETLABEL));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.verticalIndent = 5;
        this.iLabel.setLayoutData((Object)gd);
        if (this.iUIAttribute.get("description") != null) {
            this.iLabel.setToolTipText((String)this.iUIAttribute.get("description"));
        }
        Composite flcComposite = new Composite((Composite)this.iUIComposite, 0);
        gridData = new GridData(768);
        flcComposite.setLayout((Layout)new GridLayout());
        flcComposite.setLayoutData((Object)gridData);
        this.iFileListControl = new FileListControl(flcComposite, (String)this.iUIAttribute.get(InputUIElement.WIDGETLABEL), 0);
    }

    @Override
    public boolean isValid() {
        boolean retVal = true;
        String mandatory = (String)this.iUIAttribute.get(InputUIElement.MANDATORY);
        if (this.iFileListControl.getItems() == null && mandatory.equalsIgnoreCase("true")) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void disposeWidget() {
        this.iLabel.dispose();
        this.iFileListControl = null;
    }
}

