/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.templateengine.ui.uitree.uiwidgets;

import com.symbian.cdt.templateengine.TemplateEngineHelper;
import com.symbian.cdt.templateengine.ui.event.PatternEvent;
import com.symbian.cdt.templateengine.ui.uitree.InputUIElement;
import com.symbian.cdt.templateengine.ui.uitree.PatternMatchingTable;
import com.symbian.cdt.templateengine.ui.uitree.UIAttributes;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UIComposite;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UITextWidget
extends InputUIElement
implements ModifyListener {
    private UIAttributes<String, String> iUIAttribute;
    protected Text iText;
    protected Label iLabel;
    private String patternValue;
    protected UIComposite iUIComposite;

    public UITextWidget(UIAttributes<String, String> aUIAttribute) {
        super(aUIAttribute);
        this.iUIAttribute = aUIAttribute;
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put((String)this.iUIAttribute.get("id"), this.iText.getText());
        return retMap;
    }

    @Override
    public void setValues(Map<String, String> aValueMap) {
        String val = aValueMap.get(this.iUIAttribute.get("id"));
        String key = null;
        String subString = null;
        if (val != null) {
            if (val.contains("$(")) {
                key = TemplateEngineHelper.getFirstMarkerID(val);
                subString = val.substring(key.length() + 3, val.length());
                val = aValueMap.get(key) != null ? String.valueOf(aValueMap.get(key)) + subString : subString;
            }
            val = val.trim();
            this.iText.setText(val);
        }
    }

    @Override
    public void createWidgets(UIComposite aUIComposite) {
        GridData gd = new GridData();
        this.iUIComposite = aUIComposite;
        this.iLabel = new Label((Composite)this.iUIComposite, 16384);
        this.iLabel.setText((String)this.iUIAttribute.get(InputUIElement.WIDGETLABEL));
        if (((String)this.iUIAttribute.get("type")).equalsIgnoreCase(InputUIElement.MULTILINETYPE)) {
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.verticalIndent = 5;
            this.iLabel.setLayoutData((Object)gd);
        }
        if (this.iUIAttribute.get("description") != null) {
            this.iLabel.setToolTipText((String)this.iUIAttribute.get("description"));
        }
        this.iText = this.getTextWidget((String)this.iUIAttribute.get("type"));
        this.iText.addModifyListener((ModifyListener)this);
    }

    @Override
    public void disposeWidget() {
        this.iLabel.dispose();
        this.iText.dispose();
    }

    public void evaluatePattern(String aLabelText, String aUserInputText, String aPattern) {
        String message = String.valueOf(aLabelText) + InputUIElement.CONTENTS;
        Pattern pattern = Pattern.compile(aPattern);
        Matcher matcher = pattern.matcher(aUserInputText);
        if (!matcher.matches()) {
            String[] failed = pattern.split(aUserInputText);
            int i = 1;
            while (i < failed.length) {
                message = String.valueOf(message) + failed[i] + " ";
                ++i;
            }
            message = String.valueOf(message) + InputUIElement.ISINVALID;
            message = String.valueOf(message) + " Expected pattern is \"" + aPattern + "\"";
            if (this.iUIComposite != null) {
                this.iUIComposite.firePatternEvent(new PatternEvent(this, message, false));
            }
        } else {
            String checkproject = (String)this.iAttribute.get(InputUIElement.CHECKPROJECT);
            if (checkproject != null && checkproject.equalsIgnoreCase("true") && TemplateEngineHelper.checkDirectoryInWorkspace(aUserInputText)) {
                message = String.valueOf(aUserInputText) + " Project already exists in workspace.";
                this.iUIComposite.firePatternEvent(new PatternEvent(this, message, false));
            } else if (this.iUIComposite != null) {
                this.iUIComposite.firePatternEvent(new PatternEvent(this, message, true));
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        String patternName = (String)this.iUIAttribute.get(InputUIElement.INPUTPATTERN);
        this.patternValue = patternName == null ? null : (patternName.equals(PatternMatchingTable.UID) || patternName.equals(PatternMatchingTable.FREETEXT) || patternName.equals(PatternMatchingTable.TEXT) || patternName.equals(PatternMatchingTable.FILENAME) ? this.getPatternValue(patternName) : patternName);
        String inputText = this.iText.getText();
        if (this.patternValue == null || inputText == null) {
            return;
        }
        String mandatory = (String)this.iAttribute.get(InputUIElement.MANDATORY);
        if ((mandatory == null || !mandatory.equalsIgnoreCase("true")) && inputText.equals("")) {
            return;
        }
        this.evaluatePattern(this.iLabel.getText(), inputText, this.patternValue);
    }

    private String getPatternValue(String aPatternName) {
        if (aPatternName.equals(PatternMatchingTable.UID)) {
            this.patternValue = "0x[0-9a-fA-F]{8}";
        }
        if (aPatternName.equals(PatternMatchingTable.TEXT)) {
            this.patternValue = "[A-Za-z0-9\\!\\?\\.: ]*";
        }
        if (aPatternName.equals(PatternMatchingTable.FREETEXT)) {
            this.patternValue = "[A-Za-z0-9() \\.\\s]*";
        }
        if (aPatternName.equals(PatternMatchingTable.FILENAME)) {
            this.patternValue = "([A-Za-z][:])?[[\\|\\\\|/]?[_!@#\\$%\\^()\\-+{}\\[\\]=;',A-Za-z0-9\\. ]*]*";
        }
        return this.patternValue;
    }

    @Override
    public boolean isValid() {
        boolean retVal = true;
        String mandatory = (String)this.iUIAttribute.get(InputUIElement.MANDATORY);
        if (mandatory != null && mandatory.equalsIgnoreCase("true") && (this.iText.getText() == null || this.iText.getText().equals("") || this.iText.getText().trim().length() < 1)) {
            retVal = false;
        }
        return retVal;
    }

    private Text getTextWidget(String aType) {
        Text retTextWidget = null;
        Composite textConatiner = new Composite((Composite)this.iUIComposite, 0x100000);
        textConatiner.setLayout((Layout)new GridLayout());
        if (aType.equalsIgnoreCase(InputUIElement.INPUTTYPE)) {
            GridData gridData = new GridData(768);
            gridData.widthHint = 70;
            textConatiner.setLayoutData((Object)gridData);
            retTextWidget = new Text(textConatiner, 2052);
            retTextWidget.setLayoutData((Object)new GridData(768));
        }
        if (aType.equalsIgnoreCase(InputUIElement.MULTILINETYPE)) {
            GridData multiTextData = new GridData(768);
            multiTextData.widthHint = 70;
            String line = (String)this.iUIAttribute.get(InputUIElement.SIZE);
            int cnt = 1;
            if (line != null && (cnt = Integer.parseInt(line)) <= 0) {
                cnt = 1;
            }
            multiTextData.heightHint = 30 + 12 * cnt;
            textConatiner.setLayoutData((Object)multiTextData);
            retTextWidget = new Text(textConatiner, 2626);
            GridData textData = new GridData(4, 4, true, true);
            retTextWidget.setLayoutData((Object)textData);
        }
        return retTextWidget;
    }
}

