/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.core;

import com.symbian.cdt.core.CorePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SymbianProjectNature
implements IProjectNature {
    public static final String SYMBIAN_NATURE_ID = String.valueOf(CorePlugin.getUniqueId()) + ".symbiannature";
    private IProject project;

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addNature(IProject project, IProgressMonitor mon) throws CoreException {
        SymbianProjectNature.addNature(project, SYMBIAN_NATURE_ID, mon);
    }

    public static void removeNature(IProject project, IProgressMonitor mon) throws CoreException {
        SymbianProjectNature.removeNature(project, SYMBIAN_NATURE_ID, mon);
    }

    private static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        String[] prevNatures;
        IProjectDescription description = project.getDescription();
        String[] stringArray = prevNatures = description.getNatureIds();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String prevNature = stringArray[n];
            if (natureId.equals(prevNature)) {
                return;
            }
            ++n;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    private static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList newNatures = new ArrayList(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }
}

