/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.symbian.cdt.sdk.ImproperDevicesFormatException;
import com.symbian.cdt.sdk.api.ISDKListFetcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevicesSDKListFetcher
implements ISDKListFetcher {
    @Override
    public Map<String, ISDKListFetcher.SDKInfo> getSDKList(String path) throws ImproperDevicesFormatException {
        HashMap<String, ISDKListFetcher.SDKInfo> newSDKMap = new HashMap<String, ISDKListFetcher.SDKInfo>();
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource in = new InputSource(new BufferedReader(new FileReader(path)));
            Document doc = docBuilder.parse(in);
            NodeIterator ni = XPathAPI.selectNodeIterator(doc, "/devices/device");
            Node n = ni.nextNode();
            while (n != null) {
                String id = n.getAttributes().getNamedItem("id").getNodeValue();
                Node nameNode = n.getAttributes().getNamedItem("name");
                String name = nameNode == null ? id : nameNode.getNodeValue();
                Node epocRootNode = XPathAPI.selectSingleNode(n, "epocroot/text()");
                String epocRoot = epocRootNode.getNodeValue();
                newSDKMap.put(id, new ISDKListFetcher.SDKInfo(name, new File(epocRoot)));
                n = ni.nextNode();
            }
        }
        catch (Throwable t) {
            throw new ImproperDevicesFormatException(t);
        }
        return newSDKMap;
    }
}

