/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.symbian.cdt.sdk.InstallationFailureException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.operations.OperationsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicFeatureInstaller {
    private URL featureURL;
    private IProgressMonitor progressMonitor;

    public DynamicFeatureInstaller(String featureDirectory, IProgressMonitor progressMonitor) throws MalformedURLException, FileNotFoundException {
        this(new File(featureDirectory), progressMonitor);
    }

    public DynamicFeatureInstaller(File featureDirectory, IProgressMonitor progressMonitor) throws MalformedURLException, FileNotFoundException {
        this(featureDirectory.toURL(), progressMonitor);
        if (!featureDirectory.isDirectory()) {
            throw new FileNotFoundException(featureDirectory + " is not a directory.");
        }
        if (!new File(featureDirectory, "features").isDirectory()) {
            throw new FileNotFoundException(featureDirectory + " does not contain \"features\" directory.");
        }
        if (!new File(featureDirectory, "plugins").isDirectory()) {
            throw new FileNotFoundException(featureDirectory + " does not contain \"plugins\" directory.");
        }
    }

    public DynamicFeatureInstaller(URL featureDirectoryURL, IProgressMonitor progressMonitor) {
        this.featureURL = featureDirectoryURL;
        this.progressMonitor = progressMonitor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install() throws InstallationFailureException {
        try {
            try {
                OperationsManager.setInProgress((boolean)true);
                ISite remoteSite = SiteManager.getSite((URL)this.featureURL, (IProgressMonitor)this.progressMonitor);
                IConfiguredSite[] configuredSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
                ArrayList<IFeatureReference> installedFeatureRefs = new ArrayList<IFeatureReference>();
                IConfiguredSite localSite = null;
                IConfiguredSite[] iConfiguredSiteArray = configuredSites;
                int n = 0;
                int n2 = iConfiguredSiteArray.length;
                while (n < n2) {
                    IConfiguredSite site = iConfiguredSiteArray[n];
                    installedFeatureRefs.addAll((Collection)Arrays.asList(site.getConfiguredFeatures()));
                    if (localSite == null && site.isUpdatable()) {
                        localSite = site;
                    }
                    ++n;
                }
                boolean modified = false;
                ISiteFeatureReference[] iSiteFeatureReferenceArray = remoteSite.getFeatureReferences();
                n2 = 0;
                int n3 = iSiteFeatureReferenceArray.length;
                while (n2 < n3) {
                    ISiteFeatureReference featureReference = iSiteFeatureReferenceArray[n2];
                    if (!this.isLatestInstalled((IFeatureReference)featureReference, installedFeatureRefs)) {
                        IFeature feature = featureReference.getFeature(this.progressMonitor);
                        localSite.install(feature, null, this.progressMonitor);
                        localSite.configure(feature);
                        modified = true;
                    }
                    ++n2;
                }
                if (!modified) return false;
                boolean restart = SiteManager.getLocalSite().save();
                OperationsManager.applyChangesNow();
                boolean bl = restart;
                return bl;
            }
            finally {
                OperationsManager.setInProgress((boolean)false);
            }
        }
        catch (Throwable t) {
            throw new InstallationFailureException(t);
        }
    }

    private boolean isLatestInstalled(IFeatureReference newFeature, List<IFeatureReference> installedFeatureList) throws CoreException {
        for (IFeatureReference installedFeature : installedFeatureList) {
            VersionedIdentifier oldId = installedFeature.getVersionedIdentifier();
            VersionedIdentifier newId = newFeature.getVersionedIdentifier();
            if (!oldId.getIdentifier().equals(newId.getIdentifier()) || !oldId.getVersion().isGreaterOrEqualTo(newId.getVersion())) continue;
            return true;
        }
        return false;
    }
}

