/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.symbian.cdt.build.BuildPlugin;
import com.symbian.cdt.sdk.DynamicFeatureInstaller;
import com.symbian.cdt.sdk.InstallationFailureException;
import com.symbian.cdt.sdk.SDKException;
import com.symbian.cdt.sdk.SDKSupportPlugin;
import com.symbian.cdt.sdk.api.ISDK;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDK
implements ISDK {
    private static final String INCLUDE = "include";
    private static final String RELEASE = "release";
    private static final String TOOLS = "tools";
    private static final Object EPOC = "epoc";
    private static final String INCLUDE_SUBDIR = "epoc32/include";
    private static final String RELEASE_SUBDIR = "epoc32/release";
    private static final String TOOLS_SUBDIR = "epoc32/tools";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String SDK_SPECIFIC_PLUGIN_FQ_EXTENSION_POINT = String.valueOf(SDKSupportPlugin.getUniqueId()) + "sdkSpecificPlugins";
    private static final String PLUGIN_ELEMENT_NAME = "plugin";
    private static final String SDK_ID_ELEMENT_NAME = "sdkId";
    private String id;
    private String releaseNumber;
    private String name;
    private File epocRoot;
    private File includeRoot;
    private File releaseRoot;
    private File toolsRoot;
    private int lastUsedConfigurationId;
    private Map<String, IConfiguration> buildConfigurations;
    private Set<String> sdkSpecificPlugins;
    private String label;
    private String variantFileLocation;
    private boolean manuallyAdded;

    protected SDK(String id, String name, File epocRoot) {
        boolean deriveAllInformation = false;
        try {
            this.processManifestFromEpocRoot(epocRoot);
        }
        catch (Throwable t) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, "Unable to install plug-ins dynamically.", t));
            deriveAllInformation = true;
            this.initDefaults(id, name, epocRoot, true);
        }
        if (!deriveAllInformation) {
            this.initDefaults(id, name, epocRoot, false);
        }
        this.resolveSDKSpecificPlugins();
        this.resolveBuildConfigurations();
        this.manuallyAdded = false;
    }

    protected SDK(File manifest) throws SDKException {
        try {
            this.processManifest(manifest);
        }
        catch (Throwable t) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, "Unable to install plug-ins dynamically.", t));
            throw new SDKException((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, t.getMessage() == null ? " " : t.getMessage(), t));
        }
        this.resolveSDKSpecificPlugins();
        this.resolveBuildConfigurations();
        this.manuallyAdded = true;
    }

    private void processManifestFromEpocRoot(File epocRoot) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this.epocRoot = epocRoot;
        this.processManifest(new File(epocRoot, "epoc32/kit/manifest.xml"));
    }

    private void processManifest(File manifestFile) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(manifestFile);
        Node node = XPathAPI.selectSingleNode(doc, "sdk/eclipsePlugins/@path");
        String eclipsePluginsPath = node.getNodeValue();
        try {
            new DynamicFeatureInstaller(new File(this.epocRoot, eclipsePluginsPath), null).install();
        }
        catch (MalformedURLException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, "Unable to install plug-ins dynamically.", (Throwable)e));
        }
        catch (FileNotFoundException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, "Unable to install plug-ins dynamically.", (Throwable)e));
        }
        catch (InstallationFailureException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, "Unable to install plug-ins dynamically.", (Throwable)e));
        }
        NodeIterator nodeIter = XPathAPI.selectNodeIterator(doc, "sdk/root");
        while ((node = nodeIter.nextNode()) != null) {
            String path;
            String rootType;
            NamedNodeMap attribs = node.getAttributes();
            String string = rootType = (node = attribs.getNamedItem("name")) == null ? null : node.getNodeValue();
            if (rootType == null) continue;
            node = attribs.getNamedItem("path");
            String string2 = path = node == null ? null : node.getNodeValue();
            if (path == null) continue;
            if (rootType.equals(INCLUDE)) {
                this.includeRoot = new File(path);
                continue;
            }
            if (rootType.equals(RELEASE)) {
                this.releaseRoot = new File(path);
                continue;
            }
            if (rootType.equals(TOOLS)) {
                this.toolsRoot = new File(path);
                continue;
            }
            if (!rootType.equals(EPOC)) continue;
            File epocRoot = new File(path);
            if (this.epocRoot == null) continue;
            this.epocRoot = epocRoot;
        }
        node = XPathAPI.selectSingleNode(doc, "sdk/@id");
        this.id = node == null ? null : node.getNodeValue();
        node = XPathAPI.selectSingleNode(doc, "sdk/@label");
        this.label = node == null ? null : node.getNodeValue();
    }

    private void initDefaults(String id, String name, File epocRoot, boolean deriveAllInformation) {
        if (deriveAllInformation) {
            this.extractReleaseNumberAndId(id);
            this.name = name;
            this.epocRoot = epocRoot;
            this.includeRoot = new File(epocRoot, INCLUDE_SUBDIR);
            this.releaseRoot = new File(epocRoot, RELEASE_SUBDIR);
            this.toolsRoot = new File(epocRoot, TOOLS_SUBDIR);
            this.label = this.id;
            File variantFile = new File(this.includeRoot, "variant/" + this.id + ".hrh");
            this.variantFileLocation = variantFile.exists() ? variantFile.getPath() : null;
        } else {
            if (this.id == null || this.releaseNumber == null) {
                this.extractReleaseNumberAndId(id);
            }
            this.name = this.name == null ? name : this.name;
            this.epocRoot = this.epocRoot == null ? epocRoot : this.epocRoot;
            this.includeRoot = this.includeRoot == null ? new File(this.epocRoot, INCLUDE_SUBDIR) : this.includeRoot;
            this.releaseRoot = this.releaseRoot == null ? new File(this.epocRoot, RELEASE_SUBDIR) : this.releaseRoot;
            this.toolsRoot = this.toolsRoot == null ? new File(this.epocRoot, TOOLS_SUBDIR) : this.toolsRoot;
            this.label = this.label == null ? this.id : this.label;
            File variantFile = new File(this.includeRoot, "variant/" + this.id + ".hrh");
            this.variantFileLocation = this.variantFileLocation == null ? (variantFile.exists() ? variantFile.getPath() : null) : this.variantFileLocation;
        }
    }

    private void extractReleaseNumberAndId(String id) {
        if (id.contains("S60") || id.contains("Series60") || id.contains("s60")) {
            this.id = id;
            this.releaseNumber = "";
            return;
        }
        int underScore = id.indexOf("_");
        if (underScore == -1) {
            try {
                Integer.parseInt(id);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unknown SDK: " + id);
            }
            this.releaseNumber = id;
            this.id = "Symbian_OS_v7.0s";
        } else {
            String firstPart = id.substring(0, underScore);
            String secondPart = id.substring(underScore + 1);
            try {
                Integer.parseInt(secondPart);
                if (!firstPart.equals("OS7")) {
                    throw new IllegalArgumentException("Unknown SDK: " + id);
                }
                this.releaseNumber = secondPart;
                this.id = "Symbian_OS_v7.0a";
            }
            catch (NumberFormatException numberFormatException) {
                this.releaseNumber = firstPart;
                this.id = secondPart;
            }
        }
    }

    protected void resolveSDKSpecificPlugins() {
        IExtension[] extensions;
        this.sdkSpecificPlugins = new HashSet<String>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(SDK_SPECIFIC_PLUGIN_FQ_EXTENSION_POINT);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            IExtension[] iExtensionArray = extensions;
            int n = 0;
            int n2 = iExtensionArray.length;
            while (n < n2) {
                IExtension extension = iExtensionArray[n];
                String pluginId = extension.getNamespace();
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = 0;
                int n4 = iConfigurationElementArray.length;
                while (n3 < n4) {
                    IConfigurationElement elem = iConfigurationElementArray[n3];
                    if (elem.getName().equals(PLUGIN_ELEMENT_NAME) && elem.getAttribute(SDK_ID_ELEMENT_NAME).equals(this.id)) {
                        this.sdkSpecificPlugins.add(pluginId);
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }

    @Override
    public synchronized void resolveBuildConfigurations() {
        int n;
        IExtension[] extensions;
        IExtensionPoint extensionPoint;
        if (this.buildConfigurations == null) {
            this.buildConfigurations = new HashMap<String, IConfiguration>();
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ManagedBuildManager.EXTENSION_POINT_ID)) != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement element;
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                String revision = null;
                IConfigurationElement[] iConfigurationElementArray = elements;
                n = 0;
                int n2 = iConfigurationElementArray.length;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                        revision = element.getAttribute(VERSION_ELEMENT_NAME);
                        break;
                    }
                    ++n;
                }
                iConfigurationElementArray = elements;
                n = 0;
                n2 = iConfigurationElementArray.length;
                while (n < n2) {
                    String configId;
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals("configuration") && (configId = element.getAttribute("id")).startsWith(this.id)) {
                        int firstUnderScore = this.id.length();
                        String projectTypeId = configId.substring(firstUnderScore + 1, configId.indexOf("_", firstUnderScore + 1));
                        ProjectType projType = (ProjectType)ManagedBuildManager.getProjectType((String)projectTypeId);
                        try {
                            Configuration config = (Configuration)projType.getConfiguration(configId);
                            if (config == null) {
                                config = new Configuration(projType, (IManagedConfigElement)new DefaultManagedConfigElement(element, extension), revision);
                                config.resolveReferences();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++n;
                }
                ++i;
            }
        }
        IProjectType[] iProjectTypeArray = BuildPlugin.getDefault().getSymbianProjectTypes();
        int n3 = 0;
        int n4 = iProjectTypeArray.length;
        while (n3 < n4) {
            IProjectType projType = iProjectTypeArray[n3];
            IConfiguration[] iConfigurationArray = projType.getConfigurations();
            int n5 = 0;
            n = iConfigurationArray.length;
            while (n5 < n) {
                IConfiguration config = iConfigurationArray[n5];
                if (config.getId().startsWith(this.id)) {
                    this.buildConfigurations.put(config.getId(), config);
                }
                ++n5;
            }
            ++n3;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getReleaseNumber() {
        return this.releaseNumber;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getEpocRoot() {
        return this.epocRoot;
    }

    @Override
    public File getIncludeRoot() {
        return this.includeRoot;
    }

    @Override
    public File getReleaseRoot() {
        return this.releaseRoot;
    }

    @Override
    public IConfiguration getLastUsedConfiguration() {
        return this.buildConfigurations.get(this.lastUsedConfigurationId);
    }

    @Override
    public boolean isSpecificPlugin(String pluginId) {
        return this.sdkSpecificPlugins.contains(pluginId);
    }

    @Override
    public Map<String, IConfiguration> getBuildConfigurations() {
        return this.buildConfigurations;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public File getToolsRoot() {
        return this.toolsRoot;
    }

    @Override
    public String getUniqueId() {
        return String.valueOf(this.releaseNumber) + "_" + this.id;
    }

    @Override
    public String getVariantFileLocation() {
        return this.variantFileLocation;
    }

    public static ISDK getSDK(String id, String name, File epocRoot) {
        return new SDK(id, name, epocRoot);
    }

    public static ISDK getSDK(File manifest) throws SDKException {
        return new SDK(manifest);
    }

    @Override
    public boolean isManuallyAdded() {
        return this.manuallyAdded;
    }
}

