/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.symbian.cdt.sdk.SDKSupportPlugin;
import com.symbian.cdt.sdk.api.ISDK;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.core.runtime.Platform;

public class SDKEnvironmentSupplier
implements IConfigurationEnvironmentVariableSupplier {
    static final String PATH = "PATH";
    static final String EPOCROOT = "EPOCROOT";
    static final String EMPTY_STRING = "";
    static final String PLUS_CHAR = "+";
    static final String GLOBAL_SYSTEM_INCLUDE_PATHS = "GLOBAL_SYSTEM_INCLUDE_PATHS";
    static final String GLOBAL_USER_INCLUDE_PATHS = "GLOBAL_USER_INCLUDE_PATHS";
    static final String SYSTEM_INCLUDE_PATH = "systemIncludePaths";
    static final String USER_INCLUDE_PATH = "userIncludePaths";
    static final String MWCSYM2INCLUDES = "MWCSYM2INCLUDES";
    private String winscwIncludePaths = "";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName == null) {
            return null;
        }
        try {
            ISDK currentSDK = SDKSupportPlugin.getDefault().getSDKForBuildConfiguration(configuration);
            if (EPOCROOT.equalsIgnoreCase(variableName)) {
                String epocRoot = this.getEpocRoot(currentSDK);
                if (epocRoot != null) {
                    return new BuildEnvVar(EPOCROOT, epocRoot, 1, null);
                }
            } else {
                if (PATH.equalsIgnoreCase(variableName)) {
                    String epocRoot = this.getEpocRoot(currentSDK);
                    String filePath = Platform.getInstallLocation().getURL().getFile();
                    String extrapath = String.valueOf(new File(filePath).getAbsolutePath()) + File.separator + "symbian" + File.pathSeparator;
                    extrapath = String.valueOf(extrapath) + epocRoot + "epoc32" + File.separator + "tools" + File.pathSeparator;
                    extrapath = String.valueOf(extrapath) + epocRoot + "epoc32" + File.separator + "gcc" + File.separator + "bin" + File.pathSeparator;
                    return new BuildEnvVar(PATH, extrapath.replace('/', '\\'), 3, null);
                }
                if (GLOBAL_SYSTEM_INCLUDE_PATHS.equalsIgnoreCase(variableName)) {
                    return new BuildEnvVar(GLOBAL_SYSTEM_INCLUDE_PATHS, this.getGlobalIncludePaths(configuration, SYSTEM_INCLUDE_PATH), 1, null);
                }
                if (GLOBAL_USER_INCLUDE_PATHS.equalsIgnoreCase(variableName)) {
                    return new BuildEnvVar(GLOBAL_USER_INCLUDE_PATHS, this.getGlobalIncludePaths(configuration, USER_INCLUDE_PATH), 1, null);
                }
                if (MWCSYM2INCLUDES.equalsIgnoreCase(variableName)) {
                    return new BuildEnvVar(MWCSYM2INCLUDES, this.fixWINSCWIncludePaths(configuration), 1, null);
                }
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        Properties values = EnvironmentReader.getEnvVars();
        if (values == null) {
            return null;
        }
        ArrayList<Object> variables = new ArrayList<Object>(values.size());
        Enumeration<?> en = values.propertyNames();
        boolean epocRootSet = false;
        int i = 0;
        while (i < values.size()) {
            String name = (String)en.nextElement();
            String value = values.getProperty(name);
            if (EPOCROOT.equalsIgnoreCase(name)) {
                variables.add(this.getVariable(name, configuration, provider));
                epocRootSet = true;
            } else if (PATH.equalsIgnoreCase(name)) {
                variables.add(this.getVariable(name, configuration, provider));
            } else if (MWCSYM2INCLUDES.equalsIgnoreCase(name)) {
                this.winscwIncludePaths = value != null ? value : this.winscwIncludePaths;
                variables.add(this.getVariable(name, configuration, provider));
            } else {
                variables.add(new BuildEnvVar(name, value, 1, null));
            }
            ++i;
        }
        if (!epocRootSet) {
            variables.add(this.getVariable(EPOCROOT, configuration, provider));
        }
        variables.add(this.getVariable(GLOBAL_SYSTEM_INCLUDE_PATHS, configuration, provider));
        variables.add(this.getVariable(GLOBAL_USER_INCLUDE_PATHS, configuration, provider));
        return variables.toArray(new IBuildEnvironmentVariable[variables.size()]);
    }

    private String getEpocRoot(ISDK currentSDK) {
        String epocRoot = null;
        if (currentSDK != null && !(epocRoot = currentSDK.getEpocRoot().getAbsolutePath()).endsWith(File.separator)) {
            epocRoot = String.valueOf(epocRoot) + File.separator;
        }
        return epocRoot;
    }

    private String getGlobalIncludePaths(IConfiguration config, String IncludeType) throws BuildException {
        IOption[] iOptionArray = config.getToolChain().getOptions();
        int n = 0;
        int n2 = iOptionArray.length;
        while (n < n2) {
            IOption option = iOptionArray[n];
            if (option.isValid() && option.getValueType() == 4 && option.getId().toLowerCase().contains(IncludeType.toLowerCase())) {
                String includePath = new String(EMPTY_STRING);
                String[] stringArray = option.getIncludePaths();
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    String path = stringArray[n3];
                    includePath = String.valueOf(includePath) + path + File.pathSeparator;
                    ++n3;
                }
                return includePath;
            }
            ++n;
        }
        return null;
    }

    private String fixWINSCWIncludePaths(IConfiguration configuration) {
        String fixedPath = new String(EMPTY_STRING);
        String[] stringArray = this.winscwIncludePaths.split(File.pathSeparator);
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String incPath = stringArray[n];
            if (incPath.startsWith(PLUS_CHAR)) {
                incPath = incPath.substring(1);
            }
            fixedPath = String.valueOf(fixedPath) + incPath + File.pathSeparator;
            ++n;
        }
        return fixedPath;
    }
}

