/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.symbian.cdt.sdk.SDKSupportPlugin;
import com.symbian.cdt.sdk.api.ISDK;
import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;

public class SDKMacrosSupplier
implements IConfigurationBuildMacroSupplier {
    static final String SDK = "SDK";
    static final String GLOBAL_SYSTEM_INCLUDE_PATHS = "GLOBAL_SYSTEM_INCLUDE_PATHS";
    static final String GLOBAL_USER_INCLUDE_PATHS = "GLOBAL_USER_INCLUDE_PATHS";
    static final String SYSTEM_INCLUDE_PATH = "systemIncludePaths";
    static final String USER_INCLUDE_PATH = "userIncludePaths";
    static final String WHITESPACE = " ";
    static final String VARIANT_FILE = "VARIANT_FILE";
    static final String EPOC32_RELEASE_ROOT = "EPOC32_RELEASE_ROOT";

    public IBuildMacro getMacro(String macroName, IConfiguration configuration, IBuildMacroProvider provider) {
        ISDK currentSDK = SDKSupportPlugin.getDefault().getSDKForBuildConfiguration(configuration);
        if (macroName == null || currentSDK == null) {
            return null;
        }
        if (macroName.equals(SDK)) {
            return new BuildMacro(macroName, 1, currentSDK.getId());
        }
        if (macroName.equals(GLOBAL_SYSTEM_INCLUDE_PATHS)) {
            return new BuildMacro(macroName, 1, this.getGlobalIncludePaths(configuration, SYSTEM_INCLUDE_PATH));
        }
        if (macroName.equals(GLOBAL_USER_INCLUDE_PATHS)) {
            return new BuildMacro(macroName, 1, this.getGlobalIncludePaths(configuration, USER_INCLUDE_PATH));
        }
        if (macroName.equals(VARIANT_FILE)) {
            return new BuildMacro(macroName, 1, currentSDK.getVariantFileLocation());
        }
        if (macroName.equals(EPOC32_RELEASE_ROOT)) {
            return new BuildMacro(macroName, 1, currentSDK.getReleaseRoot().toString());
        }
        return null;
    }

    public IBuildMacro[] getMacros(IConfiguration configuration, IBuildMacroProvider provider) {
        HashSet<IBuildMacro> macros = new HashSet<IBuildMacro>();
        macros.add(this.getMacro(SDK, configuration, provider));
        macros.add(this.getMacro(GLOBAL_SYSTEM_INCLUDE_PATHS, configuration, provider));
        macros.add(this.getMacro(GLOBAL_USER_INCLUDE_PATHS, configuration, provider));
        macros.add(this.getMacro(VARIANT_FILE, configuration, provider));
        macros.add(this.getMacro(EPOC32_RELEASE_ROOT, configuration, provider));
        return macros.toArray(new IBuildMacro[macros.size()]);
    }

    private String getGlobalIncludePaths(IConfiguration config, String IncludeType) {
        try {
            IOption[] iOptionArray = config.getToolChain().getOptions();
            int n = 0;
            int n2 = iOptionArray.length;
            while (n < n2) {
                IOption option = iOptionArray[n];
                if (option.isValid() && option.getValueType() == 4 && option.getId().toLowerCase().contains(IncludeType.toLowerCase())) {
                    String includePath = new String("");
                    String[] stringArray = option.getIncludePaths();
                    int n3 = 0;
                    int n4 = stringArray.length;
                    while (n3 < n4) {
                        String path = stringArray[n3];
                        includePath = String.valueOf(includePath) + path + WHITESPACE;
                        ++n3;
                    }
                    return includePath;
                }
                ++n;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return null;
    }
}

