/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.symbian.cdt.sdk.SDK;
import com.symbian.cdt.sdk.SDKException;
import com.symbian.cdt.sdk.SDKSupportPlugin;
import com.symbian.cdt.sdk.api.ISDK;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String SCAN_ON_STARTUP_TEXT = "Scan for SDKs installed every time on start-up";
    private static final String SCAN_BUTTON_TEXT = "&Rescan Now";
    private static final String PROPERTY_BUTTON_TEXT = "&Properties";
    private static final String ADD_BUTTON_TEXT = "&Add";
    private static final String REMOVE_BUTTON_TEXT = "&Remove";
    private static final String PAGE_LABEL = "SDK Preferences Page";
    private Button addButton;
    private Button propertyButton;
    private Button removeButton;
    private Button scanButton;
    private TableViewer tableViewer;
    private Table table;
    private Map<String, ISDK> devicesMap;
    private Map<String, String> nameIDMap;
    private Map<String, ISDK> lastKnownMap = new HashMap<String, ISDK>();
    private Color RED;
    private Color BLACK;

    public SDKPreferencePage() {
        super(1);
        this.setPreferenceStore(SDKSupportPlugin.getDefault().getPreferenceStore());
        this.setDescription("Global SDK Preferences");
    }

    public void createFieldEditors() {
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        this.RED = this.getShell().getDisplay().getSystemColor(3);
        this.BLACK = this.getShell().getDisplay().getSystemColor(2);
        content.setLayout((Layout)new GridLayout());
        Label pageLabel = new Label(content, 0);
        pageLabel.setText(PAGE_LABEL);
        Composite subComposite = new Composite(content, 0);
        subComposite.setLayout((Layout)new GridLayout(2, false));
        subComposite.setLayoutData((Object)new GridData(1808));
        this.devicesMap = SDKSupportPlugin.getDefault().getSDKMap();
        this.lastKnownMap.putAll(this.devicesMap);
        this.nameIDMap = this.initSdkNameID(this.devicesMap);
        this.tableViewer = new TableViewer(subComposite, 2048);
        this.addTableItems(this.devicesMap);
        this.addButtonControls(subComposite);
        Button check = new Button(subComposite, 32);
        check.setText(SCAN_ON_STARTUP_TEXT);
        check.setSelection(true);
        check.setToolTipText(SCAN_ON_STARTUP_TEXT);
        this.scanButton = new Button(subComposite, 8);
        this.scanButton.setText(SCAN_BUTTON_TEXT);
        this.scanButton.setToolTipText("Rescan for SDKs...");
        this.addButtonListener(this.scanButton);
    }

    private void addTableItems(Map<String, ISDK> map) {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SDKLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new SDKContentProvider());
        this.table = this.tableViewer.getTable();
        this.tableViewer.setInput(map);
        this.table.setToolTipText("SDKs List");
        this.table.setVisible(true);
        this.addSelectionListener(this.table);
        this.table.setLayoutData((Object)new GridData(1808));
        this.setColorToList(this.table);
    }

    private void addButtonControls(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        this.addButton = new Button(composite, 8);
        this.addButton.setText(ADD_BUTTON_TEXT);
        this.addButtonListener(this.addButton);
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(REMOVE_BUTTON_TEXT);
        this.removeButton.setEnabled(false);
        this.addButtonListener(this.removeButton);
        this.propertyButton = new Button(composite, 8);
        this.propertyButton.setText(PROPERTY_BUTTON_TEXT);
        this.propertyButton.setEnabled(false);
        this.addButtonListener(this.propertyButton);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 5;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void addSelectionListener(final Table sdkTable) {
        sdkTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] children = sdkTable.getSelection();
                if (children.length == 1) {
                    SDKPreferencePage.this.propertyButton.setEnabled(true);
                    SDKPreferencePage.this.removeButton.setEnabled(true);
                } else {
                    SDKPreferencePage.this.propertyButton.setEnabled(false);
                    SDKPreferencePage.this.removeButton.setEnabled(false);
                }
            }
        });
    }

    private void addButtonListener(Button aButton) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!e.getSource().equals(SDKPreferencePage.this.propertyButton)) {
                    if (e.getSource().equals(SDKPreferencePage.this.addButton)) {
                        SDKPreferencePage.this.addButtonAction();
                    } else if (e.getSource().equals(SDKPreferencePage.this.removeButton)) {
                        SDKPreferencePage.this.removeButtonAction();
                    } else if (e.getSource().equals(SDKPreferencePage.this.scanButton)) {
                        SDKPreferencePage.this.table.removeAll();
                        SDKPreferencePage.this.lastKnownMap.clear();
                        SDKPreferencePage.this.lastKnownMap.putAll(SDKSupportPlugin.getDefault().getSDKMap());
                        SDKPreferencePage.this.addTableItems(SDKPreferencePage.this.lastKnownMap);
                        SDKPreferencePage.this.nameIDMap = SDKPreferencePage.this.initSdkNameID(SDKPreferencePage.this.lastKnownMap);
                        SDKPreferencePage.this.tableViewer.refresh();
                    }
                }
                SDKPreferencePage.this.setColorToList(SDKPreferencePage.this.table);
            }
        };
        aButton.addSelectionListener((SelectionListener)listener);
    }

    private void addButtonAction() {
        FileDialog sdkPage = new FileDialog(this.getShell(), 4096);
        sdkPage.setText("Select the manifest file of the SDK you want to add");
        sdkPage.setFilterExtensions(new String[]{"*.xml"});
        sdkPage.setFilterNames(new String[]{"manifest.xml"});
        if (sdkPage.open() != null) {
            try {
                SDKSupportPlugin.getDefault().addSDK(new File(sdkPage.getFileName()));
                this.table.removeAll();
                this.lastKnownMap.clear();
                this.lastKnownMap.putAll(SDKSupportPlugin.getDefault().getSDKMap());
                this.addTableItems(this.lastKnownMap);
                this.nameIDMap = this.initSdkNameID(this.lastKnownMap);
            }
            catch (SDKException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error in Adding SDK", (String)("SDK cannot be added because of the following error:\n" + e.getStatus().getMessage()));
            }
        }
    }

    private void removeButtonAction() {
        String sdkName = this.table.getSelection()[0].getText();
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)("Removing SDK " + sdkName), (String)("Removing " + sdkName + " SDK "))) {
            TableItem child = this.table.getSelection()[0];
            String sdkID = this.nameIDMap.get(child.getText());
            SDKSupportPlugin.getDefault().removeSDK(sdkID);
            this.lastKnownMap.remove(sdkID);
            this.nameIDMap.remove(child);
            this.table.removeAll();
            this.addTableItems(this.lastKnownMap);
        }
    }

    private Map<String, String> initSdkNameID(Map<String, ISDK> map) {
        Set<String> sdkSet;
        HashMap<String, String> resultNameIDMap = new HashMap<String, String>();
        if (!map.isEmpty() && !(sdkSet = map.keySet()).isEmpty()) {
            for (String sdkID : sdkSet) {
                String sdkName = map.get(sdkID).getLabel();
                resultNameIDMap.put(sdkName, sdkID);
            }
        }
        return resultNameIDMap;
    }

    private void setColorToList(Table sdkList) {
        TableItem[] tableItemArray = sdkList.getItems();
        int n = 0;
        int n2 = tableItemArray.length;
        while (n < n2) {
            TableItem child = tableItemArray[n];
            ISDK isdk = this.lastKnownMap.get(this.nameIDMap.get(child.getText()));
            if (isdk != null) {
                if (isdk.getBuildConfigurations().size() < 0) {
                    sdkList.setForeground(this.RED);
                } else {
                    sdkList.setForeground(this.BLACK);
                }
            }
            ++n;
        }
    }

    public void init(IWorkbench workbench) {
    }

    static class SDKContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        SDKContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] obj = null;
            Map sdkMap = (Map)inputElement;
            if (!sdkMap.isEmpty()) {
                Set sdkSet = sdkMap.keySet();
                if (!sdkSet.isEmpty()) {
                    obj = new Object[sdkSet.size()];
                }
                int i = 0;
                for (String sdkID : sdkSet) {
                    SDK sdk = (SDK)sdkMap.get(sdkID);
                    obj[i++] = sdk;
                }
            }
            return obj;
        }
    }

    static class SDKLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SDKLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String name = "";
            if (element instanceof SDK) {
                SDK sdk = (SDK)element;
                name = sdk.getLabel();
            }
            return name;
        }
    }
}

