/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.sdk;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.symbian.cdt.sdk.RestartDialog;
import com.symbian.cdt.sdk.SDK;
import com.symbian.cdt.sdk.SDKException;
import com.symbian.cdt.sdk.api.ISDK;
import com.symbian.cdt.sdk.api.ISDKListFetcher;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKSupportPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String EXTENSION_POINT_DEVICES = String.valueOf(SDKSupportPlugin.getUniqueId()) + ".devices";
    public static final String EXTENSION_POINT_BUILD_CONFIG = String.valueOf(SDKSupportPlugin.getUniqueId()) + ".buildConfiguration";
    static final String PLUGIN_ID = "com.symbian.cdt.sdk";
    private static SDKSupportPlugin plugin;
    private Map<String, ISDK> sdkMap = Collections.synchronizedMap(new HashMap());
    private Set<String> newlyInstalledSDKIds;
    private Set<String> uninstalledSDKIds;
    private String currentSDKId;
    private boolean inited = false;

    public SDKSupportPlugin() {
        plugin = this;
    }

    public static String getUniqueId() {
        if (SDKSupportPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return SDKSupportPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.init();
    }

    private synchronized void init() {
        if (!this.inited) {
            this.inited = true;
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, e.getMessage(), (Throwable)e));
                return;
            }
            Location configurationLocation = Platform.getConfigurationLocation();
            File lastKnownListFile = null;
            if (!configurationLocation.isReadOnly()) {
                try {
                    URL url = new URL(configurationLocation.getURL(), PLUGIN_ID);
                    File configFolder = new File(url.getFile());
                    if (!configFolder.exists()) {
                        configFolder.mkdirs();
                    }
                    lastKnownListFile = new File(configFolder, "lastKnownSDKList.xml");
                    Document lastKnownDoc = docBuilder.parse(lastKnownListFile);
                    NodeIterator ni = XPathAPI.selectNodeIterator(lastKnownDoc, "/sdks/sdk");
                    Node n = ni.nextNode();
                    while (n != null) {
                        NamedNodeMap attribs = n.getAttributes();
                        String id = attribs.getNamedItem("id").getNodeValue();
                        String name = attribs.getNamedItem("name").getNodeValue();
                        String epocRoot = attribs.getNamedItem("epocRoot").getNodeValue();
                        File epocRootFile = new File(epocRoot);
                        if (epocRootFile.exists()) {
                            try {
                                ISDK sdk = SDK.getSDK(id, name, epocRootFile);
                                this.sdkMap.put(sdk.getUniqueId(), sdk);
                            }
                            catch (Throwable t) {
                                ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, t.getMessage(), t));
                            }
                        }
                        n = ni.nextNode();
                    }
                }
                catch (TransformerException transformerException) {
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanSDKs() {
        SDKSupportPlugin sDKSupportPlugin = this;
        synchronized (sDKSupportPlugin) {
            this.buildLatestSDKMap();
            this.updateLastKnownSDKList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildLatestSDKMap() {
        Map<String, ISDK> map = this.sdkMap;
        synchronized (map) {
            IConfigurationElement[] configElements;
            Iterator<String> iter = this.sdkMap.keySet().iterator();
            while (iter.hasNext()) {
                if (this.sdkMap.get(iter.next()).isManuallyAdded()) continue;
                iter.remove();
            }
            IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_DEVICES);
            int n = 0;
            int n2 = iConfigurationElementArray.length;
            while (n < n2) {
                IConfigurationElement element = iConfigurationElementArray[n];
                IExtension extn = element.getDeclaringExtension();
                IConfigurationElement[] iConfigurationElementArray2 = extn.getConfigurationElements();
                int n3 = 0;
                int n4 = iConfigurationElementArray2.length;
                while (n3 < n4) {
                    IConfigurationElement devices = iConfigurationElementArray2[n3];
                    try {
                        ISDKListFetcher sdkListFetcher = (ISDKListFetcher)devices.createExecutableExtension("sdkListFetcher");
                        Map<String, ISDKListFetcher.SDKInfo> sdkList = sdkListFetcher.getSDKList(devices.getAttribute("path"));
                        for (String sdkId : sdkList.keySet()) {
                            ISDKListFetcher.SDKInfo info = sdkList.get(sdkId);
                            try {
                                ISDK sdk = SDK.getSDK(sdkId, info.name, info.epocRoot);
                                this.sdkMap.put(sdk.getUniqueId(), sdk);
                            }
                            catch (Throwable t) {
                                ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, t.getMessage(), t));
                            }
                        }
                    }
                    catch (Throwable t) {
                        ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, t.getMessage(), t));
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }

    private void updateLastKnownSDKList() {
        Iterator<String> iter;
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, e.getMessage(), (Throwable)e));
            return;
        }
        Location configurationLocation = Platform.getConfigurationLocation();
        HashSet<String> lastKnownSet = new HashSet<String>();
        File lastKnownListFile = null;
        if (!configurationLocation.isReadOnly()) {
            try {
                URL url = new URL(configurationLocation.getURL(), PLUGIN_ID);
                File configFolder = new File(url.getFile());
                if (!configFolder.exists()) {
                    configFolder.mkdirs();
                }
                lastKnownListFile = new File(configFolder, "lastKnownSDKList.xml");
                Document lastKnownDoc = docBuilder.parse(lastKnownListFile);
                NodeIterator ni = XPathAPI.selectNodeIterator(lastKnownDoc, "/sdks/sdk");
                Node n = ni.nextNode();
                while (n != null) {
                    lastKnownSet.add(n.getAttributes().getNamedItem("id").getNodeValue());
                    n = ni.nextNode();
                }
            }
            catch (TransformerException transformerException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {}
        }
        this.uninstalledSDKIds = new TreeSet<String>(lastKnownSet);
        this.uninstalledSDKIds.removeAll((Collection)this.sdkMap.keySet());
        this.newlyInstalledSDKIds = new TreeSet<String>((Collection)this.sdkMap.keySet());
        this.newlyInstalledSDKIds.removeAll(lastKnownSet);
        System.out.println("Uninstalled: " + this.uninstalledSDKIds);
        System.out.println("Newly installed: " + this.newlyInstalledSDKIds);
        if (this.newlyInstalledSDKIds.size() > 0) {
            this.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow window = SDKSupportPlugin.this.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        Shell shell = window.getShell();
                        RestartDialog.show(shell, "The following SDKs are newly found:\n\n" + SDKSupportPlugin.this.newlyInstalledSDKIds + "\n\nTo enable eclipse to use these SDKs a restart is recommended. " + "Press yes for a restart and no for letting the changes take effect without restarting.");
                    }
                }
            });
        }
        docBuilder.reset();
        Document d = docBuilder.newDocument();
        Node sdks = d.appendChild(d.createElement("sdks"));
        for (String id : this.sdkMap.keySet()) {
            Node sdk = sdks.appendChild(d.createElement("sdk"));
            NamedNodeMap attribs = sdk.getAttributes();
            Attr idNode = d.createAttribute("id");
            idNode.setNodeValue(id);
            attribs.setNamedItem(idNode);
            Attr nameNode = d.createAttribute("name");
            nameNode.setNodeValue(this.sdkMap.get(id).getName());
            attribs.setNamedItem(nameNode);
            Attr epocRootNode = d.createAttribute("epocRoot");
            epocRootNode.setNodeValue(this.sdkMap.get(id).getEpocRoot().getAbsolutePath());
            attribs.setNamedItem(epocRootNode);
        }
        DOMSource domSource = new DOMSource(d);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StreamResult fileResult = new StreamResult(lastKnownListFile);
        try {
            transFactory.newTransformer().transform(domSource, fileResult);
        }
        catch (TransformerConfigurationException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, e.getMessage(), (Throwable)e));
        }
        catch (TransformerException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, e.getMessage(), (Throwable)e));
        }
        if (this.currentSDKId == null && (iter = this.sdkMap.keySet().iterator()).hasNext()) {
            this.currentSDKId = iter.next();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static SDKSupportPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Set<String> getNewlyInstalledSDKIds() {
        return this.newlyInstalledSDKIds;
    }

    public Map<String, ISDK> getSDKMap() {
        return this.sdkMap;
    }

    public Set<String> getUninstalledSDKIds() {
        return this.uninstalledSDKIds;
    }

    public ISDK getSDK(String sdkUniqueId) {
        return this.sdkMap.get(sdkUniqueId);
    }

    public void switchContextTo(String sdkUniqueId) {
        this.switchContextTo(this.getSDK(sdkUniqueId));
    }

    public void switchContextTo(ISDK sdk) {
        this.currentSDKId = sdk.getId();
    }

    public void resolveSDKBuildConfigurations() {
        for (ISDK sdk : this.sdkMap.values()) {
            sdk.resolveBuildConfigurations();
        }
    }

    public void earlyStartup() {
        IPreferenceStore store = SDKSupportPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("SCAN_ON_STARTUP")) {
            this.rescanSDKs();
        }
    }

    public ISDK getSDKForBuildConfiguration(IConfiguration selectedConfig) {
        for (ISDK sdk : this.sdkMap.values()) {
            for (IConfiguration config : sdk.getBuildConfigurations().values()) {
                if (!this.isParentConfiguration(config, selectedConfig)) continue;
                return sdk;
            }
        }
        return null;
    }

    private boolean isParentConfiguration(IConfiguration probableParent, IConfiguration probableChild) {
        while (probableChild != null) {
            if (probableParent.getId().equals(probableChild.getId())) {
                return true;
            }
            probableChild = probableChild.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISDK addSDK(File manifestFile) throws SDKException {
        if (manifestFile.exists()) {
            ISDK sdk = SDK.getSDK(manifestFile);
            SDKSupportPlugin sDKSupportPlugin = this;
            synchronized (sDKSupportPlugin) {
                this.sdkMap.put(sdk.getUniqueId(), sdk);
                this.updateLastKnownSDKList();
            }
            return sdk;
        }
        throw new SDKException((IStatus)new Status(4, SDKSupportPlugin.getUniqueId(), 4, "Manifest file not found: " + manifestFile, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSDK(String sdkUniqueId) {
        SDKSupportPlugin sDKSupportPlugin = this;
        synchronized (sDKSupportPlugin) {
            block4: {
                if (this.sdkMap.remove(sdkUniqueId) == null) break block4;
                this.updateLastKnownSDKList();
                return true;
            }
        }
        return false;
    }
}

