/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.conference.examples.processes;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngineHelper;
import com.symbian.cdt.templateengine.process.ProcessArgument;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.process.ProcessHelper;
import com.symbian.cdt.templateengine.process.ProcessRunner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class AppendCreate
extends ProcessRunner {
    public void process(Template template, ProcessArgument[] args, String processId) throws ProcessFailureException {
        ProcessArgument[][] files;
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProcessArgument[][] processArgumentArray = files = args[1].getComplexArrayValue();
        int n = 0;
        int n2 = processArgumentArray.length;
        while (n < n2) {
            String fileContents;
            URL sourceURL;
            ProcessArgument[] file = processArgumentArray[n];
            String sourcePath = file[0].getSimpleValue();
            String targetPath = file[1].getSimpleValue();
            boolean replaceable = file[2].getSimpleValue().equals("true");
            try {
                sourceURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate((Template)template, (String)sourcePath);
                if (sourceURL == null) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, "Add File failure: template source not found: " + sourcePath));
                }
            }
            catch (IOException iOException) {
                throw new ProcessFailureException("Append failure: template source not found: " + sourcePath);
            }
            try {
                fileContents = ProcessHelper.readFromFile((URL)sourceURL);
            }
            catch (IOException iOException) {
                throw new ProcessFailureException("Append failure: cannot read template source: " + sourcePath);
            }
            if (replaceable) {
                fileContents = ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), (Map)template.getValueStore());
            }
            try {
                IFile iFile = projectHandle.getFile(targetPath);
                if (!iFile.getParent().exists()) {
                    ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
                }
                ByteArrayInputStream contents = new ByteArrayInputStream(fileContents.getBytes());
                if (!iFile.exists()) {
                    iFile.create((InputStream)contents, true, null);
                    iFile.refreshLocal(1, null);
                } else {
                    iFile.appendContents((InputStream)contents, true, true, null);
                }
                projectHandle.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new ProcessFailureException("Append failure: failed while trying to append contents.", (Throwable)e);
            }
            ++n;
        }
    }
}

