/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.conference.examples.ui;

import com.symbian.cdt.templateengine.ui.IWizardDataPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSelectionPage
extends NewElementWizardPage
implements IWizardDataPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private StringButtonDialogField fProjectField;
    private StatusInfo fProjectStatus;
    private IWorkspaceRoot fWorkspaceRoot;
    private ICProject fCurrCProject;
    private Map<String, String> data = new HashMap<String, String>(2);

    public ProjectSelectionPage() {
        super(PAGE_NAME);
        this.setTitle("Select a project");
        this.setDescription("Select a project");
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fProjectField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fProjectField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fProjectField.setLabelText("Project Name");
        this.fProjectField.setButtonLabel("Browse");
        this.fProjectStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        ICProject jproject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            selectedElement = EditorUtility.getActiveEditorCInput();
        }
        String projPath = null;
        if (selectedElement instanceof IResource) {
            IProject proj = ((IResource)selectedElement).getProject();
            if (proj != null) {
                projPath = proj.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof ICElement && (jproject = ((ICElement)selectedElement).getCProject()) != null) {
            projPath = jproject.getProject().getFullPath().makeRelative().toString();
        }
        if (projPath != null) {
            this.fProjectField.setText(projPath);
        } else {
            this.setDefaultAttributes();
        }
    }

    private void setDefaultAttributes() {
        String projPath = "";
        try {
            IProject[] projects = this.fWorkspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject proj = projects[i];
                if (proj.hasNature("org.eclipse.cdt.core.cnature") || proj.hasNature("org.eclipse.cdt.core.ccnature")) {
                    projPath = proj.getFullPath().makeRelative().toString();
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.fProjectField.setText(projPath);
    }

    public Map<String, String> getPageData() {
        String projName = this.fCurrCProject.getResource().getName().trim();
        this.data.put("projectName", projName);
        this.data.put("baseName", this.getBaseName(projName));
        return this.data;
    }

    private String getBaseName(String projName) {
        String baseName = projName;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        return baseName;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.fProjectField.doFillIntoGrid(composite, 3);
        int maxFieldWidth = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.fProjectField.getTextControl(null), (int)maxFieldWidth);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProjectField.getTextControl(null));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.new_srcfldr_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void packRootChangeControlPressed(DialogField field) {
        ICProject jproject;
        if (field == this.fProjectField && (jproject = this.chooseProject()) != null) {
            IPath path = jproject.getProject().getFullPath().makeRelative();
            this.fProjectField.setText(path.toString());
        }
    }

    protected void packRootDialogFieldChanged(DialogField field) {
        if (field == this.fProjectField) {
            this.updateProjectStatus();
        }
        this.updateStatus(new IStatus[]{this.fProjectStatus});
    }

    private void updateProjectStatus() {
        this.fCurrCProject = null;
        String str = this.fProjectField.getText();
        if (str.length() == 0) {
            this.fProjectStatus.setError("Please enter a project name");
            return;
        }
        Path path = new Path(str);
        if (path.segmentCount() != 1) {
            this.fProjectStatus.setError("Invalid Project Path");
            return;
        }
        IProject project = this.fWorkspaceRoot.getProject(path.toString());
        if (!project.exists()) {
            this.fProjectStatus.setError("The project does not exist");
            return;
        }
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                this.fCurrCProject = CoreModel.getDefault().create(project);
                this.fProjectStatus.setOK();
                return;
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log((Throwable)e);
            this.fCurrCProject = null;
        }
        this.fProjectStatus.setError("Please select a C or C++ project");
    }

    private ICProject chooseProject() {
        Object[] projects;
        try {
            projects = CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot).getCProjects();
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log((Throwable)e);
            projects = new ICProject[]{};
        }
        CElementLabelProvider labelProvider = new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Choose a Project");
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.fCurrCProject});
        if (dialog.open() == 0) {
            return (ICProject)dialog.getFirstResult();
        }
        return null;
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        RootFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            ProjectSelectionPage.this.packRootChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            ProjectSelectionPage.this.packRootDialogFieldChanged(field);
        }
    }
}

