/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.testwizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWizard
extends Wizard
implements IWizard {
    private IWizardContainer container = null;
    private List<IWizardPage> pages = new ArrayList<IWizardPage>();
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private ImageDescriptor defaultImageDescriptor = null;
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;

    protected AbstractWizard() {
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard((IWizard)this);
    }

    public void addPages() {
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.size()) {
            if (!this.pages.get(i).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            page.createControl(pageContainer);
            Assert.isNotNull((Object)page.getControl());
            ++i;
        }
    }

    public void dispose() {
        if (this.pages != null) {
            IWizardPage firstPage = this.pages.get(0);
            int i = 0;
            while (i < this.pages.size()) {
                this.pages.get(i).dispose();
                ++i;
            }
            this.pages.clear();
            this.pages.add(firstPage);
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public Image getDefaultPageImage() {
        if (this.defaultImage != null) {
            return this.defaultImage;
        }
        if (this.defaultImageDescriptor != null) {
            this.defaultImage = this.defaultImageDescriptor.createImage();
            return this.defaultImage;
        }
        return JFaceResources.getImageRegistry().get("org.eclipse.jface.wizard.Wizard.pageImage");
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return this.pages.get(index + 1);
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        this.pages.get(index - 1).getControl().update();
        return this.pages.get(index - 1);
    }

    public Shell getShell() {
        if (this.container == null) {
            return null;
        }
        return this.container.getShell();
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return this.pages.get(0);
    }

    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public boolean performCancel() {
        return true;
    }

    public abstract boolean performFinish();

    public void setContainer(IWizardContainer wizardContainer) {
        this.container = wizardContainer;
    }

    public void setDefaultPageImageDescriptor(ImageDescriptor imageDescriptor) {
        this.defaultImageDescriptor = imageDescriptor;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.dialogSettings = settings;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public void setHelpAvailable(boolean b) {
        this.isHelpAvailable = b;
    }

    public void setNeedsProgressMonitor(boolean b) {
        this.needsProgressMonitor = b;
    }

    public void setTitleBarColor(RGB color) {
        this.titleBarColor = color;
    }

    public void setWindowTitle(String newTitle) {
        this.windowTitle = newTitle;
        if (this.container != null) {
            this.container.updateWindowTitle();
        }
    }

    public void clearPreviousPages() {
        if (this.pages != null) {
            this.pages.clear();
        }
    }

    public void removeUIPage(IWizardPage aProcessPage) {
        if (this.pages != null) {
            this.pages.remove(aProcessPage);
            aProcessPage.dispose();
        }
    }

    public void removeUIPages(List<IWizardPage> aPages) {
        if (aPages != null) {
            for (IWizardPage page : aPages) {
                this.pages.remove(page);
                page.dispose();
            }
        }
    }
}

