/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.testwizard;

import com.symbian.cdt.templateengine.Template;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MissingMacroCollectionPage
extends WizardPage {
    private static final String MACRO = "Macro";
    private static final String EXPANSION_VALUE = "Expansion Value";
    private static final String title = "Unexpandable Macros";
    private Template template;
    private TableViewer viewer;

    MissingMacroCollectionPage(Template template) {
        super(title);
        this.setTitle(title);
        this.setDescription("Please supply the values for the following macros (replace-markers). Without these, the process cannot be executed properly.");
        this.template = template;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        super.setControl((Control)composite);
    }

    private void createTable(Composite composite) {
        Table macrosTable = new Table(composite, 68356);
        macrosTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, 70, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(65, 130, true));
        macrosTable.setLayout((Layout)layout);
        TableColumn nameColumn = new TableColumn(macrosTable, 16384);
        nameColumn.setText(MACRO);
        TableColumn valColumn = new TableColumn(macrosTable, 16384);
        valColumn.setText(EXPANSION_VALUE);
        macrosTable.setHeaderVisible(true);
        this.viewer = new TableViewer(macrosTable);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((TableItemData)element).macro;
                    }
                    case 1: {
                        return ((TableItemData)element).value;
                    }
                }
                throw new IllegalArgumentException();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener lpl) {
            }
        });
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals(MissingMacroCollectionPage.EXPANSION_VALUE);
            }

            public Object getValue(Object element, String property) {
                if (property.equals(MissingMacroCollectionPage.MACRO)) {
                    return ((TableItemData)element).macro;
                }
                return ((TableItemData)element).value;
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                TableItemData data = (TableItemData)tableItem.getData();
                if (MissingMacroCollectionPage.EXPANSION_VALUE.equals(property)) {
                    data.value = value.toString();
                }
                MissingMacroCollectionPage.this.viewer.refresh((Object)data);
                MissingMacroCollectionPage.this.checkAndSetPageComplete();
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.viewer.getTable());
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setColumnProperties(new String[]{MACRO, EXPANSION_VALUE});
        this.viewer.setInput((Object)new Object[0]);
    }

    private void checkAndSetPageComplete() {
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = 0;
        int n2 = tableItemArray.length;
        while (n < n2) {
            TableItem item = tableItemArray[n];
            String text = item.getText(1);
            if (text == null || text.equals("")) {
                this.setPageComplete(false);
                return;
            }
            ++n;
        }
        Map valueStore = this.template.getValueStore();
        TableItem[] tableItemArray2 = this.viewer.getTable().getItems();
        n2 = 0;
        int n3 = tableItemArray2.length;
        while (n2 < n3) {
            TableItem item = tableItemArray2[n2];
            valueStore.put(item.getText(0), item.getText(1));
            ++n2;
        }
        this.setPageComplete(true);
    }

    public void setPreviousPage(IWizardPage page) {
        this.viewer.getTable().removeAll();
        boolean complete = true;
        for (String macro : this.template.getAllMissingMacrosInProcesses()) {
            this.viewer.add((Object)new TableItemData(macro, ""));
            complete = false;
        }
        this.setPageComplete(complete);
        super.setPreviousPage(page);
    }

    private static class TableItemData {
        String macro;
        String value;

        TableItemData(String macro, String value) {
            this.macro = macro;
            this.value = value;
        }
    }
}

