/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.testwizard;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ProcessPage
extends WizardPage {
    private static final String NESTING_INDENT = "  ";
    private static final String TITLE = "Process Execution";
    private Template template;
    private IStatus[] statuses;
    private org.eclipse.swt.widgets.List list;

    public ProcessPage(Template template) {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription("A list of status messages is shown below identifying the status on execution of processes.");
        this.template = template;
    }

    public void createControl(Composite aParent) {
        Composite composite = new Composite(aParent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(0);
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 32;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gridData);
        this.list = new org.eclipse.swt.widgets.List(composite, 2818);
        GridData data = new GridData(1808);
        data.heightHint = this.list.getItemHeight() * 7;
        data.horizontalSpan = 2;
        this.list.setLayoutData((Object)data);
        this.list.setFont(composite.getFont());
        super.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        IStatus[] iStatusArray = this.statuses = this.template.executeTemplateProcesses(false);
        int n = 0;
        int n2 = iStatusArray.length;
        while (n < n2) {
            IStatus status = iStatusArray[n];
            this.populateList(this.list, status);
            ++n;
        }
        return true;
    }

    private void populateList(org.eclipse.swt.widgets.List listToPopulate, IStatus status) {
        this.populateList(listToPopulate, status, 0);
    }

    private void populateList(org.eclipse.swt.widgets.List listToPopulate, IStatus buildingStatus, int nesting) {
        List statuses;
        Throwable t = buildingStatus.getException();
        boolean isCoreException = t instanceof CoreException;
        boolean isProcessFailure = t instanceof ProcessFailureException;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < nesting) {
            sb.append(NESTING_INDENT);
            ++i;
        }
        String message = buildingStatus.getMessage();
        sb.append(message);
        listToPopulate.add(sb.toString());
        sb.delete(0, sb.length());
        if (!isCoreException && !isProcessFailure && t != null) {
            int i2 = 0;
            while (i2 < nesting) {
                sb.append(NESTING_INDENT);
                ++i2;
            }
            message = t.getLocalizedMessage();
            if (message == null) {
                message = t.toString();
            }
            sb.append(message);
            listToPopulate.add(sb.toString());
        }
        ++nesting;
        if (isCoreException) {
            IStatus eStatus = ((CoreException)t).getStatus();
            if (message == null || message.indexOf(eStatus.getMessage()) == -1) {
                this.populateList(listToPopulate, eStatus, nesting);
            }
        } else if (isProcessFailure && (statuses = ((ProcessFailureException)t).getStatuses()) != null) {
            for (IStatus eStatus : statuses) {
                this.populateList(listToPopulate, eStatus, nesting);
            }
        }
        IStatus[] children = buildingStatus.getChildren();
        int i3 = 0;
        while (i3 < children.length) {
            this.populateList(listToPopulate, children[i3], nesting);
            ++i3;
        }
    }
}

