/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.testwizard;

import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateInfo;
import com.symbian.cdt.templateengine.process.ProcessFailureException;
import com.symbian.cdt.templateengine.ui.pages.UIWizardPage;
import com.symbian.cdt.templateengine.ui.uitree.UIElement;
import com.symbian.cdt.templateengine.ui.uitree.uiwidgets.UIComposite;
import com.symbian.cdt.testwizard.AbstractWizard;
import com.symbian.cdt.testwizard.MissingMacroCollectionPage;
import com.symbian.cdt.testwizard.ProcessPage;
import com.symbian.cdt.testwizard.XMLValidatePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.xml.sax.SAXException;

public class TemplateTestWizard
extends AbstractWizard
implements INewWizard {
    private static final String sWizardTitle = "Template Engine Validation and Verification Wizard";
    private static final String pageTableLabel = "Page Info ";
    private static final String pageTableToolTip = "This table contains information about the  Widgets contained on this page.";
    private Template template;
    private Map<String, UIWizardPage> pageMap = new HashMap<String, UIWizardPage>();
    private boolean createValidatePage = true;
    private XMLValidatePage iXMLValidatePage;
    private Composite iPageContainer;
    private TemplateInfo templateInfo;
    private boolean generateTable;
    private boolean generateProcessPages;
    private boolean traversePages;

    public TemplateTestWizard() {
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(sWizardTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection aselection) {
        this.pageMap.clear();
    }

    public void addPages() {
        if (this.iXMLValidatePage == null) {
            this.iXMLValidatePage = new XMLValidatePage();
            this.iXMLValidatePage.setWizard(this);
            this.addPage((IWizardPage)this.iXMLValidatePage);
        }
    }

    public void addTemplatePages() throws IOException, ProcessFailureException, SAXException, ParserConfigurationException {
        this.clearPages();
        this.template = Template.getTemplate((TemplateInfo)this.templateInfo);
        this.pageMap.clear();
        this.pageMap.putAll(this.template.getUIPages((IWizard)this));
        for (String pageId : this.template.getPagesOrderVector()) {
            UIWizardPage uiPage = this.pageMap.get(pageId);
            uiPage.setWizard((IWizard)this);
            this.addPage((IWizardPage)uiPage);
        }
        this.createPageControls(this.iPageContainer);
        super.getStartingPage().setPreviousPage(null);
        this.iXMLValidatePage.setPreviousPage(null);
    }

    public void createPageControls(Composite pageContainer) {
        this.iPageContainer = pageContainer;
        if (this.createValidatePage && this.iXMLValidatePage != null) {
            this.iXMLValidatePage.createControl(pageContainer);
            this.createValidatePage = false;
        }
        if (this.template != null) {
            for (String pageId : this.template.getPagesOrderVector()) {
                UIWizardPage page = this.pageMap.get(pageId);
                page.createControl(pageContainer);
                page.getComposite().getUIElement().setValues(this.template.getValueStore());
            }
        }
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return true;
    }

    private static void updatePagesWithTable(UIComposite aPageComposite) {
        HashMap headerMap = new HashMap();
        Label tableLable = new Label((Composite)aPageComposite, 0);
        tableLable.setText(pageTableLabel);
        tableLable.setToolTipText(pageTableToolTip);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        tableLable.setLayoutData((Object)gridData);
        Composite tableComposite = new Composite((Composite)aPageComposite, 0);
        Table templateInfoTable = TemplateTestWizard.createTable(tableComposite);
        UIElement groupElement = aPageComposite.getUIElement();
        headerMap.putAll(groupElement.getAttributes());
        try {
            int j = 0;
            while (j < groupElement.getChildCount()) {
                headerMap.putAll(groupElement.getChild(j).getAttributes());
                ++j;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        int columnCount = TemplateTestWizard.prepareColumnHeaders(headerMap.keySet().toArray(new String[0]), templateInfoTable);
        try {
            TemplateTestWizard.addTableItem((HashMap)groupElement.getAttributes(), templateInfoTable, headerMap, columnCount);
            int j = 0;
            while (j < groupElement.getChildCount()) {
                TemplateTestWizard.addTableItem((HashMap)groupElement.getChild(j).getAttributes(), templateInfoTable, headerMap, columnCount);
                ++j;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        templateInfoTable.setHeaderVisible(true);
        templateInfoTable.setLinesVisible(true);
    }

    public static int prepareColumnHeaders(String[] columnNames, Table aTableInfo) {
        int columnCount = 0;
        String[] stringArray = columnNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String columnHeader = stringArray[n];
            TableColumn tableColumn = new TableColumn(aTableInfo, 16384);
            tableColumn.setText(columnHeader);
            tableColumn.setWidth(100);
            ++columnCount;
            ++n;
        }
        return columnCount;
    }

    public static void addTableItem(HashMap aAttributes, Table aTable, HashMap aHeaderMap, int aColumnCount) {
        Iterator aKeySet = aHeaderMap.keySet().iterator();
        TableItem itemRow = null;
        String[] dataArray = new String[aColumnCount];
        itemRow = new TableItem(aTable, 0);
        String data = "";
        String key = "";
        int index = 0;
        while (aKeySet.hasNext()) {
            key = (String)aKeySet.next();
            data = (String)aAttributes.get(key);
            dataArray[index++] = data != null && data.length() > 0 ? data : " ";
        }
        itemRow.setText(dataArray);
    }

    public boolean canFinish() {
        if (this.template != null) {
            for (String pageId : this.template.getPagesOrderVector()) {
                UIWizardPage uiPage = this.pageMap.get(pageId);
                if (uiPage.isPageComplete()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Table createTable(Composite tableComposite) {
        Font font = tableComposite.getFont();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        layout.numColumns = 1;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setFont(font);
        GridData gridData = new GridData(4, 4, true, true, -1, -1);
        tableComposite.setLayoutData((Object)gridData);
        TableViewer variableTable = new TableViewer(tableComposite, 68354);
        Table templateInfoTable = variableTable.getTable();
        TableLayout tableLayout = new TableLayout();
        templateInfoTable.setLayout((Layout)tableLayout);
        templateInfoTable.setHeaderVisible(true);
        templateInfoTable.setLinesVisible(true);
        templateInfoTable.setFont(font);
        GridData grData = new GridData(4, -1, true, true);
        variableTable.getControl().setLayoutData((Object)grData);
        return templateInfoTable;
    }

    public void dispose() {
        super.dispose();
        this.clearPages();
    }

    public void setXMLTemplateFile(TemplateInfo aXMLFile) {
        this.templateInfo = aXMLFile;
    }

    public void setGenerateTable() {
        this.generateTable = true;
    }

    public void clearGenerateTable() {
        this.generateTable = false;
    }

    public IWizardPage getNextPage(IWizardPage aPage) {
        if (aPage == super.getStartingPage() && this.generateTable && this.templateInfo != null) {
            this.traversePages = true;
            this.traverseAllPages();
            this.traversePages = false;
            this.dispose();
            try {
                this.addTemplatePages();
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (ProcessFailureException e) {
                TemplateEngine.showError((String)"Error loading the template.", (Throwable)e);
                return null;
            }
            for (String pageId : this.template.getPagesOrderVector()) {
                TemplateTestWizard.updatePagesWithTable(this.pageMap.get(pageId).getComposite());
            }
            this.clearGenerateTable();
            this.doRedraw();
        }
        List pageIds = this.template.getPagesOrderVector();
        if (this.generateProcessPages && !this.traversePages && aPage == this.pageMap.get(pageIds.get(pageIds.size() - 1))) {
            this.updateTemplateValueStore();
            this.addProcessPages(aPage);
            this.generateProcessPages = false;
        }
        return super.getNextPage(aPage);
    }

    private void clearPages() {
        super.clearPreviousPages();
        if (this.iXMLValidatePage != null) {
            this.addPage((IWizardPage)this.iXMLValidatePage);
        }
        this.pageMap.clear();
    }

    private void traverseAllPages() {
        IWizardPage page = super.getNextPage(super.getStartingPage());
        if (page != null) {
            while (page != null) {
                Composite pageComposite = (Composite)page.getControl();
                super.getContainer().getShell().setRedraw(false);
                pageComposite.setVisible(false);
                page.setVisible(false);
                int i = 0;
                while (i < pageComposite.getChildren().length) {
                    pageComposite.getChildren()[i].setVisible(false);
                    ++i;
                }
                super.getContainer().showPage(page);
                super.getContainer().showPage(page.getPreviousPage());
                super.getContainer().getShell().setRedraw(true);
                page = super.getNextPage(page);
            }
        }
    }

    public void setProcessPage() {
        this.generateProcessPages = true;
    }

    public void resetProcessPage() {
        this.generateProcessPages = false;
    }

    private void addProcessPages(IWizardPage currentPage) {
        if (this.getContainer().getCurrentPage() == currentPage) {
            Set missingMacrosInProcesses = this.template.getAllMissingMacrosInProcesses();
            Object page = currentPage;
            if (missingMacrosInProcesses != null && !missingMacrosInProcesses.isEmpty()) {
                page = new MissingMacroCollectionPage(this.template);
                this.addPage((IWizardPage)page);
                page.setWizard((IWizard)this);
                page.createControl(this.iPageContainer);
                page.getControl().setSize(this.getMaxPoint());
                Rectangle aRectangle = super.getStartingPage().getControl().getBounds();
                page.getControl().redraw(aRectangle.x, aRectangle.y, aRectangle.width, aRectangle.height, true);
                page.setPreviousPage(currentPage);
            }
            ProcessPage processPage = new ProcessPage(this.template);
            this.addPage((IWizardPage)processPage);
            processPage.setWizard(this);
            processPage.createControl(this.iPageContainer);
            processPage.getControl().setSize(this.getMaxPoint());
            Rectangle aRectangle = super.getStartingPage().getControl().getBounds();
            processPage.getControl().redraw(aRectangle.x, aRectangle.y, aRectangle.width, aRectangle.height, true);
            processPage.setPreviousPage((IWizardPage)page);
        }
    }

    public void removeProcessPages() {
        IWizardPage page = super.getNextPage(super.getStartingPage());
        ArrayList<IWizardPage> removePage = new ArrayList<IWizardPage>();
        if (page != null) {
            while (page != null) {
                if ((page = super.getNextPage(page)) instanceof MissingMacroCollectionPage) {
                    removePage.add(page);
                }
                if (!(page instanceof ProcessPage)) continue;
                removePage.add(page);
            }
        }
        super.removeUIPages(removePage);
    }

    private Point getMaxPoint() {
        Point maxPoint = null;
        Point tempPoint = null;
        IWizardPage[] pages = super.getPages();
        maxPoint = this.iXMLValidatePage.getControl().getSize();
        int i = 0;
        while (i < pages.length) {
            tempPoint = pages[i].getControl().getSize();
            if (tempPoint.y > maxPoint.y) {
                maxPoint.y = tempPoint.y;
            }
            ++i;
        }
        return maxPoint;
    }

    private void doRedraw() {
        IWizardPage[] currentPages = super.getPages();
        Rectangle aRectangle = super.getStartingPage().getControl().getBounds();
        int i = 0;
        while (i < currentPages.length) {
            currentPages[i].getControl().setSize(this.getMaxPoint());
            currentPages[i].getControl().redraw(aRectangle.x, aRectangle.y, aRectangle.width, aRectangle.height, true);
            ++i;
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    private void updateTemplateValueStore() {
        Map valueStore = this.template.getValueStore();
        for (String pageId : this.template.getPagesOrderVector()) {
            valueStore.putAll(this.pageMap.get(pageId).getPageData());
        }
    }
}

