/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.testwizard;

import com.symbian.cdt.templateengine.TemplateDescriptor;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.TemplateEngineHelper;
import com.symbian.cdt.templateengine.TemplateInfo;
import com.symbian.cdt.testwizard.TemplateTestWizard;
import com.symbian.cdt.testwizard.WidgetCreationHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLValidatePage
extends WizardPage {
    private TemplateTestWizard iTemplateTestWizard = null;
    private Composite validate = null;
    protected Label iFileLabel = null;
    private Label iFileButton = null;
    private Combo iFileName = null;
    private Label iValidateStatus = null;
    private ProgressBar iProgressBar = null;
    private Composite infoGroup = null;
    private Text iTemplateInfo = null;
    private Button iTestUIButton = null;
    private Button iTestProcessButton = null;
    private Composite iFailureInfoGroup = null;
    private Text iFailureInfoText = null;
    private Label iFailureLabel = null;
    private Text iFailureText = null;
    private Button iFailureButton = null;
    private String imageIcom = "icons" + File.separator + "MobileIcon.gif";
    private boolean canFlipToNextPage = false;
    private Color color = null;
    private Color defaultColor = null;
    private Map<String, TemplateInfo> templateInfoMap = null;
    private boolean pagesRemoved = false;

    public XMLValidatePage() {
        super("Select Template for Validation");
        this.setTitle("Template Test");
        this.setDescription("Select the Template to be tested");
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)TemplateEngineHelper.getFileInPluginOfTemplateEngine((IPath)new Path(this.imageIcom)).toURL());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.color = new Color((Device)Display.getCurrent(), 255, 255, 255);
        super.setImageDescriptor(imageDescriptor);
        this.updatetemplateInfoMap();
    }

    public void createControl(Composite aParent) {
        Composite iComposite = new Composite(aParent, 0);
        iComposite.setSize(aParent.getSize());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(0);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(0);
        GridData gridData = new GridData(768);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 500;
        gridData.widthHint = 400;
        iComposite.setLayout((Layout)layout);
        iComposite.setLayoutData((Object)gridData);
        this.createValidateGroup(iComposite);
        this.createInfoGroup(iComposite);
        this.createFailureInfoGroup(iComposite);
        super.setControl((Control)iComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(super.getControl(), "com.symbian.cdt.testwizard.com_symbian_template_testwizard_firstpage");
        this.getControl().setSize(500, 500);
    }

    public void setWizard(TemplateTestWizard aWizard) {
        this.iTemplateTestWizard = aWizard;
    }

    public IWizard getWizard() {
        return this.iTemplateTestWizard;
    }

    private void createValidateGroup(Composite aComposite) {
        this.validate = new Composite(aComposite, 0);
        this.validate.setLayoutData((Object)new GridData(1808));
        this.validate.setLayout((Layout)new GridLayout(3, false));
        this.iFileLabel = WidgetCreationHelper.createLabel(this.validate, "Template ", "Select the XML file to be validated. The XML Template Will be used to test the\nTemplateEngine GUI generation and Process.");
        String[] WizardIds = new String[this.templateInfoMap.keySet().size()];
        WizardIds = this.templateInfoMap.keySet().toArray(WizardIds);
        this.iFileName = new Combo(this.validate, 2056);
        this.iFileName.setLayoutData((Object)new GridData(768));
        this.iFileName.setItems(WizardIds);
        this.iFileName.select(0);
        this.iFileName.addSelectionListener((SelectionListener)new BrowseButtonSelectionHandler());
        this.iFileButton = WidgetCreationHelper.createLabel(this.validate, "", "");
        this.iFileButton.setText("");
        this.iValidateStatus = WidgetCreationHelper.createLabel(this.validate, "Valid/Invalid", "On click of 'Valdate XML' button the XML Template is validated against the schema selected. \nThe progress bar will be green colored on successful validation it will be red otherwise.");
        this.iProgressBar = new ProgressBar(this.validate, 67840);
        this.iProgressBar.setLayoutData((Object)new GridData(768));
        this.iProgressBar.setToolTipText("Green for successful Validation.\nRed for validation failure.");
        this.defaultColor = this.iProgressBar.getBackground();
        WidgetCreationHelper.createLabel(this.validate, "", "");
        Composite checkComposite = new Composite(aComposite, 0);
        checkComposite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1, 1, false, false);
        checkComposite.setLayoutData((Object)gridData);
        this.iTestUIButton = WidgetCreationHelper.createButton(checkComposite, "Test GUI", 16);
        this.iTestUIButton.setToolTipText("Test GUI generation of the TemplateEngine");
        this.iTestUIButton.addSelectionListener((SelectionListener)new BrowseButtonSelectionHandler());
        this.iTestProcessButton = WidgetCreationHelper.createButton(checkComposite, "Test GUI and Process", 16);
        this.iTestProcessButton.setToolTipText("Test process part of the TemplateEngine");
        this.iTestProcessButton.addSelectionListener((SelectionListener)new BrowseButtonSelectionHandler());
        this.disableValidateGroup();
        this.disableActionGroup();
    }

    private void disableValidateGroup() {
        this.iFileName.setBackground(this.color);
        this.iProgressBar.setEnabled(true);
        this.iProgressBar.setForeground(this.defaultColor);
        this.iProgressBar.setBackground(this.defaultColor);
        int progressMax = this.iProgressBar.getMaximum();
        int i = 0;
        while (i < progressMax) {
            this.iProgressBar.setSelection(i);
            ++i;
        }
        this.iProgressBar.setEnabled(false);
        this.iProgressBar.setEnabled(false);
        this.iValidateStatus.setEnabled(false);
    }

    private void enableValidateGroup() {
        this.iValidateStatus.setEnabled(true);
        this.iProgressBar.setEnabled(true);
        this.iProgressBar.setForeground(this.defaultColor);
        this.iProgressBar.setBackground(this.defaultColor);
        int progressMax = this.iProgressBar.getMaximum();
        int i = 0;
        while (i < progressMax) {
            this.iProgressBar.setSelection(i);
            ++i;
        }
    }

    private void disableActionGroup() {
        if (this.iTestUIButton.getSelection()) {
            this.iTestUIButton.setSelection(false);
        }
        this.iTestUIButton.setEnabled(false);
        if (this.iTestProcessButton.getSelection()) {
            this.iTestProcessButton.setSelection(false);
        }
        this.iTestProcessButton.setEnabled(false);
    }

    private void enableActionGroup() {
        this.iTestUIButton.setSelection(false);
        this.iTestProcessButton.setSelection(false);
        this.iTestUIButton.setEnabled(true);
        this.iTestProcessButton.setEnabled(true);
    }

    private void createInfoGroup(Composite aComposite) {
        GridData groupData = new GridData(1808);
        this.infoGroup = new Composite(aComposite, 0);
        this.infoGroup.setLayout((Layout)new GridLayout());
        this.infoGroup.setLayoutData((Object)groupData);
        WidgetCreationHelper.createLabel(this.infoGroup, "Template Information :", "Template Information :");
        this.iTemplateInfo = WidgetCreationHelper.createText(this.infoGroup, "", 2882);
        this.disableInfoGroup();
    }

    private void disableInfoGroup() {
        this.iTemplateInfo.setText("");
    }

    private void createFailureInfoGroup(Composite aComposite) {
        this.iFailureInfoGroup = new Composite(aComposite, 0);
        this.iFailureInfoGroup.setLayout((Layout)new GridLayout());
        this.iFailureInfoGroup.setLayoutData((Object)new GridData(1808));
        WidgetCreationHelper.createLabel(this.iFailureInfoGroup, "XML Validation Info :", "XML Validation Info :");
        this.iFailureInfoText = WidgetCreationHelper.createText(this.iFailureInfoGroup, "", 2882);
        Composite failureComposite = new Composite(aComposite, 0);
        failureComposite.setLayout((Layout)new GridLayout(3, false));
        failureComposite.setLayoutData((Object)new GridData(768));
        this.iFailureLabel = WidgetCreationHelper.createLabel(failureComposite, "ValidationLog", "Select the file to save the Validation\nfailure information.");
        this.iFailureText = WidgetCreationHelper.createText(failureComposite, "", 2052);
        this.iFailureButton = WidgetCreationHelper.createButton(failureComposite, "  Select Log  ", 8);
        this.iFailureButton.addSelectionListener((SelectionListener)new BrowseButtonSelectionHandler());
        this.disableFailureGroup();
    }

    private void disableFailureGroup() {
        this.iFailureText.setText("");
        this.iFailureText.setBackground(this.defaultColor);
        this.iFailureInfoText.setText("");
        this.iFailureText.setEnabled(false);
        this.iFailureText.setEditable(false);
        this.iFailureLabel.setEnabled(false);
        this.iFailureButton.setEnabled(false);
        this.iFailureInfoGroup.setEnabled(false);
    }

    private void enableFailureGroup() {
        this.iFailureInfoGroup.setEnabled(true);
        this.iFailureText.setEnabled(true);
        this.iFailureText.setBackground(this.color);
        this.iFailureLabel.setEnabled(true);
        this.iFailureButton.setEnabled(true);
    }

    private boolean stringNotNull(String aToTest) {
        boolean retVal = false;
        if (aToTest != null && aToTest.length() > 0) {
            retVal = true;
        }
        return retVal;
    }

    private boolean checkExtension(String aExpectedExtension, String aExtension) {
        boolean retVal = false;
        if (aExpectedExtension.equalsIgnoreCase(aExtension)) {
            retVal = true;
        }
        return retVal;
    }

    private void updateTemplateInfo(String aXMLFileName) {
        TemplateDescriptor templateDescriptor;
        String templateInfo = "";
        URL url = null;
        try {
            url = new URL(aXMLFileName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        try {
            templateDescriptor = new TemplateDescriptor(url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        Element element = templateDescriptor.getRootElement();
        NamedNodeMap attribs = element.getAttributes();
        int i = 0;
        int l = attribs.getLength();
        while (i < l) {
            Node attribute = attribs.item(i);
            templateInfo = String.valueOf(templateInfo) + attribute.getNodeName() + " = " + attribute.getNodeValue() + "\n";
            ++i;
        }
        this.iTemplateInfo.setEditable(true);
        this.iTemplateInfo.setText(templateInfo);
        this.iTemplateInfo.setEditable(false);
    }

    private void updateFailureText(String aValidationInfo) {
        this.iFailureInfoText.setEditable(true);
        this.iFailureInfoText.setText(aValidationInfo);
        this.iFailureInfoText.setEditable(false);
    }

    private void writeToFile(String aFileName) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new File(aFileName));
            printWriter.println("----------------------------------------------------------------------------------------------------------------------");
            printWriter.println(new File(this.iFileName.getText()).toURI());
            printWriter.println(this.iFailureInfoText.getText());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exp) {
            TemplateEngine.log((Throwable)exp);
        }
    }

    public boolean canFlipToNextPage() {
        return this.canFlipToNextPage;
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    private void updatetemplateInfoMap() {
        this.templateInfoMap = new HashMap<String, TemplateInfo>();
        for (List infos : TemplateEngine.getTemplateEngine().getTemplateInfoMap().values()) {
            for (TemplateInfo info : infos) {
                try {
                    TemplateDescriptor desc = new TemplateDescriptor(TemplateEngineHelper.getTemplateResourceURL((String)info.getPluginId(), (String)info.getTemplatePath()));
                    this.templateInfoMap.put(desc.getRootElement().getAttribute("label"), info);
                }
                catch (Throwable t) {
                    TemplateEngine.log((Throwable)t);
                }
            }
        }
    }

    class BrowseButtonSelectionHandler
    extends SelectionAdapter {
        BrowseButtonSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent aSelectionEvent) {
            String fileName = null;
            if (aSelectionEvent.getSource() == XMLValidatePage.this.iFileName) {
                XMLValidatePage.this.disableActionGroup();
                XMLValidatePage.this.disableFailureGroup();
                XMLValidatePage.this.disableInfoGroup();
                TemplateInfo templateInfo = (TemplateInfo)XMLValidatePage.this.templateInfoMap.get(XMLValidatePage.this.iFileName.getText());
                try {
                    fileName = TemplateEngineHelper.getTemplateResourceURL((String)templateInfo.getPluginId(), (String)templateInfo.getTemplatePath()).toString();
                }
                catch (IOException ioe) {
                    TemplateEngine.log((Throwable)ioe);
                }
                if (!XMLValidatePage.this.stringNotNull(fileName)) {
                    return;
                }
                if (XMLValidatePage.this.checkExtension(fileName.substring(fileName.lastIndexOf(".") + 1), "xml")) {
                    this.enableValidate();
                    if (this.doValidate()) {
                        XMLValidatePage.this.infoGroup.setEnabled(true);
                        XMLValidatePage.this.updateTemplateInfo(fileName);
                        XMLValidatePage.this.enableActionGroup();
                        XMLValidatePage.this.pagesRemoved = true;
                        XMLValidatePage.this.canFlipToNextPage = false;
                        XMLValidatePage.this.getContainer().updateButtons();
                    } else {
                        XMLValidatePage.this.canFlipToNextPage = false;
                        XMLValidatePage.this.getContainer().updateButtons();
                    }
                } else {
                    this.doValidate();
                    XMLValidatePage.this.canFlipToNextPage = false;
                    XMLValidatePage.this.getContainer().updateButtons();
                }
                return;
            }
            if (aSelectionEvent.getSource() == XMLValidatePage.this.iFailureButton) {
                fileName = new FileDialog(new Shell(Display.getDefault(), 0)).open();
                if (!XMLValidatePage.this.stringNotNull(fileName)) {
                    return;
                }
                XMLValidatePage.this.iFailureText.setText(fileName);
                XMLValidatePage.this.writeToFile(fileName);
                return;
            }
            if (aSelectionEvent.getSource() == XMLValidatePage.this.iTestUIButton) {
                if (XMLValidatePage.this.iTestUIButton.getSelection()) {
                    XMLValidatePage.this.canFlipToNextPage = true;
                    XMLValidatePage.this.getContainer().updateButtons();
                    if (XMLValidatePage.this.pagesRemoved && XMLValidatePage.this.iTemplateTestWizard != null) {
                        TemplateInfo templateInfo = (TemplateInfo)XMLValidatePage.this.templateInfoMap.get(XMLValidatePage.this.iFileName.getText());
                        XMLValidatePage.this.iTemplateTestWizard.setXMLTemplateFile(templateInfo);
                        XMLValidatePage.this.iTemplateTestWizard.setGenerateTable();
                        XMLValidatePage.this.pagesRemoved = false;
                    }
                }
                if (!XMLValidatePage.this.iTestUIButton.getSelection() && !XMLValidatePage.this.iTestProcessButton.getSelection()) {
                    XMLValidatePage.this.canFlipToNextPage = false;
                    XMLValidatePage.this.getContainer().updateButtons();
                }
                return;
            }
            if (aSelectionEvent.getSource() == XMLValidatePage.this.iTestProcessButton) {
                if (XMLValidatePage.this.iTestProcessButton.getSelection() && XMLValidatePage.this.iTemplateTestWizard != null) {
                    if (XMLValidatePage.this.pagesRemoved) {
                        TemplateInfo templateInfo = (TemplateInfo)XMLValidatePage.this.templateInfoMap.get(XMLValidatePage.this.iFileName.getText());
                        XMLValidatePage.this.iTemplateTestWizard.setXMLTemplateFile(templateInfo);
                        XMLValidatePage.this.iTemplateTestWizard.setGenerateTable();
                        XMLValidatePage.this.pagesRemoved = false;
                    }
                    XMLValidatePage.this.canFlipToNextPage = true;
                    XMLValidatePage.this.getContainer().updateButtons();
                    XMLValidatePage.this.iTemplateTestWizard.setProcessPage();
                }
                if (!XMLValidatePage.this.iTestProcessButton.getSelection()) {
                    XMLValidatePage.this.iTemplateTestWizard.resetProcessPage();
                    XMLValidatePage.this.iTemplateTestWizard.removeProcessPages();
                }
                if (!XMLValidatePage.this.iTestProcessButton.getSelection() && !XMLValidatePage.this.iTestUIButton.getSelection()) {
                    XMLValidatePage.this.canFlipToNextPage = false;
                    XMLValidatePage.this.getContainer().updateButtons();
                }
                return;
            }
        }

        private void enableValidate() {
            String fileName = null;
            TemplateInfo templateInfo = (TemplateInfo)XMLValidatePage.this.templateInfoMap.get(XMLValidatePage.this.iFileName.getText());
            fileName = templateInfo.getTemplatePath();
            String xmlFile = fileName;
            if (XMLValidatePage.this.stringNotNull(xmlFile)) {
                XMLValidatePage.this.enableValidateGroup();
            }
        }

        private boolean doValidate() {
            boolean retVal = false;
            String validationResult = null;
            XMLValidatePage.this.enableFailureGroup();
            Color validationColor = null;
            TemplateInfo templateInfo = (TemplateInfo)XMLValidatePage.this.templateInfoMap.get(XMLValidatePage.this.iFileName.getText());
            InputStream xml = null;
            try {
                xml = TemplateEngineHelper.getTemplateResourceURL((String)templateInfo.getPluginId(), (String)templateInfo.getTemplatePath()).openStream();
            }
            catch (IOException iOException) {
                validationResult = "A descriptor for the selected template is not found.";
                validationColor = new Color((Device)Display.getCurrent(), 255, 0, 0);
            }
            if (xml != null) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
                    SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(TemplateEngine.getTemplateEngine().getTemplateSchemaURL().openStream())).newValidator().validate(new DOMSource(document));
                    validationColor = new Color((Device)Display.getCurrent(), 0, 255, 0);
                    validationResult = "Validation successful";
                    retVal = true;
                }
                catch (Throwable t) {
                    validationResult = t.getMessage();
                    validationColor = new Color((Device)Display.getCurrent(), 255, 0, 0);
                }
            }
            XMLValidatePage.this.iProgressBar.setForeground(validationColor);
            int progressMax = XMLValidatePage.this.iProgressBar.getMaximum();
            int i = 0;
            while (i < progressMax) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
                XMLValidatePage.this.iProgressBar.setSelection(i);
                ++i;
            }
            XMLValidatePage.this.updateFailureText(validationResult);
            return retVal;
        }
    }
}

