/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.mmp.core;

import com.symbian.cdt.project.mmp.core.LexStream;
import com.symbian.cdt.project.mmp.core.MMP;
import com.symbian.cdt.project.mmp.core.MMPScanner;
import com.symbian.cdt.project.mmp.core.ParseException;
import com.symbian.cdt.project.mmp.core.Token;
import com.symbian.cdt.project.mmp.core.ast.AIFElement;
import com.symbian.cdt.project.mmp.core.ast.BitmapStatementElement;
import com.symbian.cdt.project.mmp.core.ast.BooleanElement;
import com.symbian.cdt.project.mmp.core.ast.CapabilityListValueElement;
import com.symbian.cdt.project.mmp.core.ast.IMMPElement;
import com.symbian.cdt.project.mmp.core.ast.IntListValueElement;
import com.symbian.cdt.project.mmp.core.ast.OptionElement;
import com.symbian.cdt.project.mmp.core.ast.PlatformSpecificMMPOverridesElement;
import com.symbian.cdt.project.mmp.core.ast.ResourceStatementElement;
import com.symbian.cdt.project.mmp.core.ast.SourceStatementElement;
import com.symbian.cdt.project.mmp.core.ast.StringListValueElement;
import com.symbian.cdt.project.mmp.core.grammar.MMPPHeader;
import com.symbian.cdt.project.mmp.core.grammar.MMPPsym;
import com.symbian.cdt.project.mmp.core.token.CapValueToken;
import com.symbian.cdt.project.mmp.core.token.ColorDepthToken;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MMPParser
extends MMPPHeader
implements MMPPsym {
    static final int STACK_INCREMENT = 256;
    private LexStream lexStream;
    private int stateStackTop;
    private int[] stack;
    private Token[] locationStack;
    private ValuesStack<String> stringValuesStack = new ValuesStack();
    private ValuesStack<Integer> intValuesStack = new ValuesStack();
    private ValuesStack<String> langValuesStack = new ValuesStack();
    private ValuesStack<CapValueToken> capValuesStack = new ValuesStack();
    private ValuesStack<IMMPElement> mmpElementsStack = new ValuesStack();

    MMPParser(LexStream lexStream) {
        this.lexStream = lexStream;
    }

    final Token getToken(int i) {
        return this.locationStack[this.stateStackTop + (i - 1)];
    }

    void consumeToken(Token token) {
        switch (token.getKind()) {
            case 1: {
                this.stringValuesStack.push(token.getName());
                break;
            }
            case 44: {
                this.intValuesStack.push(Integer.parseInt(token.getName().substring(2), 16));
                break;
            }
            case 47: {
                this.intValuesStack.push(Integer.parseInt(token.getName()));
                break;
            }
            case 45: {
                this.capValuesStack.push((CapValueToken)token);
                break;
            }
            case 49: {
                this.langValuesStack.push(token.getName());
            }
        }
        if (DEBUG) {
            System.out.println("Shifting token " + token.getName());
        }
    }

    void reallocateStacks() {
        Token[] oldLocStack;
        int[] oldStack = this.stack;
        this.stack = new int[(oldStack == null ? 0 : oldStack.length) + 256];
        if (oldStack != null) {
            System.arraycopy(oldStack, 0, this.stack, 0, oldStack.length);
        }
        this.locationStack = new Token[((oldLocStack = this.locationStack) == null ? 0 : oldLocStack.length) + 256];
        if (oldLocStack != null) {
            System.arraycopy(oldLocStack, 0, this.locationStack, 0, oldLocStack.length);
        }
    }

    public static MMP getMMP(String fileName) throws IOException, ParseException {
        return new MMPParser(new MMPScanner(fileName).scan()).parse();
    }

    public MMP parse() throws ParseException {
        this.lexStream.reset();
        Token currentToken = this.lexStream.getToken();
        int act = 84;
        this.stateStackTop = -1;
        while (true) {
            if (++this.stateStackTop >= (this.stack == null ? 0 : this.stack.length)) {
                this.reallocateStacks();
            }
            this.stack[this.stateStackTop] = act;
            this.locationStack[this.stateStackTop] = currentToken;
            if ((act = MMPParser.t_action(act, currentToken.getKind())) <= 83) {
                --this.stateStackTop;
            } else if (act > 283) {
                this.consumeToken(currentToken);
                currentToken = this.lexStream.getToken();
                act -= 283;
            } else {
                if (act >= 282) break;
                this.consumeToken(currentToken);
                currentToken = this.lexStream.getToken();
                continue;
            }
            do {
                this.stateStackTop -= rhs[act] - 1;
                this.consumeRule(act);
            } while ((act = MMPParser.nt_action(this.stack[this.stateStackTop], lhs[act])) <= 83);
        }
        if (act == 283) {
            throw new ParseException("Error detected on token " + currentToken);
        }
        System.out.println("Input parsed successfully");
        return (MMP)this.mmpElementsStack.pop().next();
    }

    @Override
    public void consumeCompilationBlock() {
        MMP mmp = new MMP();
        this.constructMMP(mmp);
        this.mmpElementsStack.push(mmp);
    }

    @Override
    public void consumeStatementList() {
        this.mmpElementsStack.concatLists();
    }

    @Override
    public void consumeAIFExpression() {
        Token token5;
        AIFElement aif = new AIFElement(this.stringValuesStack.pop().next(), this.stringValuesStack.pop().next(), this.stringValuesStack.pop().next(), (token5 = this.getToken(5)).getKind() == 48 ? (ColorDepthToken)token5 : null, this.stringValuesStack.pop());
        this.mmpElementsStack.push(aif);
    }

    @Override
    public void consumeStringValueList() {
        this.stringValuesStack.concatLists();
    }

    @Override
    public void consumeAlwaysBuildAsARMExpression() {
        this.mmpElementsStack.push(new BooleanElement(11));
    }

    @Override
    public void consumeASSPABIExpression() {
        this.mmpElementsStack.push(new BooleanElement(12));
    }

    @Override
    public void consumeASSPLIBRARYExpression() {
        this.mmpElementsStack.push(new StringListValueElement(13, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeASSPEXPORTSExpression() {
        this.mmpElementsStack.push(new BooleanElement(14));
    }

    @Override
    public void consumeBaseAddressExpression() {
        this.mmpElementsStack.push(new IntListValueElement(15, this.intValuesStack.pop()));
    }

    @Override
    public void consumeCapabilityExpression() {
        this.mmpElementsStack.push(new CapabilityListValueElement(this.capValuesStack.pop()));
    }

    @Override
    public void consumeCapabilityValueList() {
        this.capValuesStack.concatLists();
    }

    @Override
    public void consumeCapabilityValueSubtraction() {
        this.capValuesStack.push(CapValueToken.negativeOf(this.capValuesStack.pop().next()));
    }

    @Override
    public void consumeCompressTargetExpression() {
        this.mmpElementsStack.push(new BooleanElement(17));
    }

    @Override
    public void consumeDebugLibraryExpression() {
        this.mmpElementsStack.push(new StringListValueElement(18, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeDefFileExpression() {
        this.mmpElementsStack.push(new StringListValueElement(19, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeDocumentExpression() {
        this.mmpElementsStack.push(new StringListValueElement(20, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeEPOCHeapSizeExpression() {
        this.mmpElementsStack.push(new IntListValueElement(21, new Integer[]{this.intValuesStack.pop().next(), this.intValuesStack.pop().next()}));
    }

    @Override
    public void consumeEPOCProcessPriorityExpression() {
        this.mmpElementsStack.push(new StringListValueElement(22, new String[]{this.getToken(2).getName()}));
    }

    @Override
    public void consumeEPOCStackSizeExpression() {
        this.mmpElementsStack.push(new IntListValueElement(23, this.intValuesStack.pop()));
    }

    @Override
    public void consumeExportLibraryExpression() {
        this.mmpElementsStack.push(new StringListValueElement(24, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeExportUnfrozenExpression() {
        this.mmpElementsStack.push(new BooleanElement(25));
    }

    @Override
    public void consumeLangExpression() {
        this.mmpElementsStack.push(new StringListValueElement(6, this.langValuesStack.pop()));
    }

    @Override
    public void consumeLangList() {
        this.langValuesStack.concatLists();
    }

    @Override
    public void consumeLibraryExpression() {
        this.mmpElementsStack.push(new StringListValueElement(26, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeLinkAsExpression() {
        this.mmpElementsStack.push(new StringListValueElement(27, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeMacroExpression() {
        this.mmpElementsStack.push(new StringListValueElement(28, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeNoCompressTargetExpression() {
        this.mmpElementsStack.push(new BooleanElement(29));
    }

    @Override
    public void consumeNoExportLibraryExpression() {
        this.mmpElementsStack.push(new BooleanElement(30));
    }

    @Override
    public void consumeNoStrictDefExpression() {
        this.mmpElementsStack.push(new BooleanElement(31));
    }

    @Override
    public void consumeOptionExpression() {
        this.mmpElementsStack.push(new OptionElement(this.getToken(2).getName(), this.stringValuesStack.pop()));
    }

    @Override
    public void consumeResourceExpression() {
        this.mmpElementsStack.push(new StringListValueElement(7, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeSourceExpression() {
        this.mmpElementsStack.push(new StringListValueElement(5, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeSourcePathExpression() {
        this.mmpElementsStack.push(new StringListValueElement(3, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeSrcDbgExpression() {
        this.mmpElementsStack.push(new BooleanElement(33));
    }

    @Override
    public void consumeStaticLibraryExpression() {
        this.mmpElementsStack.push(new StringListValueElement(34, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeStrictDependExpression() {
        this.mmpElementsStack.push(new BooleanElement(35));
    }

    @Override
    public void consumeSystemIncludeExpression() {
        this.mmpElementsStack.push(new StringListValueElement(36, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeSystemResourceExpression() {
        this.mmpElementsStack.push(new StringListValueElement(37, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeTargetExpression() {
        this.mmpElementsStack.push(new StringListValueElement(8, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeTargetTypeExpression() {
        this.mmpElementsStack.push(new StringListValueElement(38, new String[]{this.getToken(2).getName()}));
    }

    @Override
    public void consumeTargetPathExpression() {
        this.mmpElementsStack.push(new StringListValueElement(4, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeUIDExpression1() {
        this.mmpElementsStack.push(new IntListValueElement(9, this.intValuesStack.pop()));
    }

    @Override
    public void consumeUIDExpression2() {
        this.mmpElementsStack.push(new IntListValueElement(9, new Integer[]{this.intValuesStack.pop().next(), this.intValuesStack.pop().next()}));
    }

    @Override
    public void consumeUserIncludeExpression() {
        this.mmpElementsStack.push(new StringListValueElement(39, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeVendorIdExpression() {
        this.mmpElementsStack.push(new IntListValueElement(40, this.intValuesStack.pop()));
    }

    @Override
    public void consumeWin32LibraryExpression() {
        this.mmpElementsStack.push(new StringListValueElement(41, this.stringValuesStack.pop()));
    }

    @Override
    public void consumeBitmapStatement() {
        BitmapStatementElement bitmapStatementElement = new BitmapStatementElement(this.stringValuesStack.pop().next());
        this.constructBitmapStatement(this.mmpElementsStack.pop(), bitmapStatementElement);
        this.constructBitmapStatement(this.mmpElementsStack.pop(), bitmapStatementElement);
        this.mmpElementsStack.push(bitmapStatementElement);
    }

    private void constructBitmapStatement(Iterator<IMMPElement> statementListInsideBitmapBlock, BitmapStatementElement bitmapStatementElement) {
        while (statementListInsideBitmapBlock.hasNext()) {
            IMMPElement statement = statementListInsideBitmapBlock.next();
            switch (statement.getKind()) {
                case 4: {
                    bitmapStatementElement.setTargetPath(((StringListValueElement)statement).getValue()[0]);
                    break;
                }
                case 3: {
                    bitmapStatementElement.setSourcePath(((StringListValueElement)statement).getValue()[0]);
                    break;
                }
                case 46: {
                    bitmapStatementElement.setHeader(true);
                    break;
                }
                case 5: {
                    bitmapStatementElement.setSource((SourceStatementElement)statement);
                }
            }
        }
    }

    @Override
    public void consumeStatementListInsideBitmapBlock1() {
        this.mmpElementsStack.concatLists();
    }

    @Override
    public void consumeStatementListInsideBitmapBlock2() {
        this.mmpElementsStack.concatLists();
        this.mmpElementsStack.concatLists();
    }

    @Override
    public void consumeStatementListInsideBitmapBlockOptEmpty() {
        this.mmpElementsStack.pushZeroLength();
    }

    @Override
    public void consumeStatementListInsideBitmapBlockOpt() {
        this.mmpElementsStack.concatLists();
    }

    @Override
    public void consumeSourceStatement() {
        this.mmpElementsStack.push(new SourceStatementElement((ColorDepthToken)this.getToken(2), this.stringValuesStack.pop()));
    }

    @Override
    public void consumeResourceStatement() {
        ResourceStatementElement resourceStatementElement = new ResourceStatementElement(this.stringValuesStack.pop().next());
        this.constructResourceStatement(this.mmpElementsStack.pop(), resourceStatementElement);
    }

    private void constructResourceStatement(Iterator<IMMPElement> statementListInsideResourceBlock, ResourceStatementElement resourceStatementElement) {
        while (statementListInsideResourceBlock.hasNext()) {
            IMMPElement statement = statementListInsideResourceBlock.next();
            switch (statement.getKind()) {
                case 8: {
                    resourceStatementElement.setTargetFile(((StringListValueElement)statement).getValue()[0]);
                    break;
                }
                case 4: {
                    resourceStatementElement.setTargetPath(((StringListValueElement)statement).getValue()[0]);
                    break;
                }
                case 46: {
                    resourceStatementElement.setHeader(true);
                    break;
                }
                case 6: {
                    resourceStatementElement.setLang(((StringListValueElement)statement).getValue());
                    break;
                }
                case 9: {
                    Integer[] value = ((IntListValueElement)statement).getValue();
                    resourceStatementElement.setUid1(value[0]);
                    if (value.length <= 1) break;
                    resourceStatementElement.setUid2(value[0]);
                }
            }
        }
    }

    @Override
    public void consumeStatementListInsideResourceBlock() {
        this.mmpElementsStack.concatLists();
    }

    @Override
    public void consumeStatementListInsideResourceBlockEmpty() {
        this.mmpElementsStack.pushZeroLength();
    }

    @Override
    public void consumePlatformStatement1() {
        this.mmpElementsStack.push(this.constructPlatformSpecificMMPOverridesElement(true));
    }

    @Override
    public void consumePlatformStatement2() {
        this.mmpElementsStack.push(this.constructPlatformSpecificMMPOverridesElement(false));
    }

    private PlatformSpecificMMPOverridesElement constructPlatformSpecificMMPOverridesElement(boolean copyForStaticLinkage) {
        PlatformSpecificMMPOverridesElement platformSpecificMMPOverridesElement = new PlatformSpecificMMPOverridesElement(this.getToken(2).getName(), copyForStaticLinkage);
        this.constructMMP(platformSpecificMMPOverridesElement);
        return platformSpecificMMPOverridesElement;
    }

    private void constructMMP(MMP mmp) {
        Iterator<IMMPElement> statements = this.mmpElementsStack.pop();
        block50: while (statements.hasNext()) {
            IMMPElement statement = statements.next();
            if (statement instanceof BooleanElement) {
                switch (statement.getKind()) {
                    case 11: {
                        mmp.setAlwaysBuildAsArm(true);
                        break;
                    }
                    case 12: {
                        mmp.setASSPABI(true);
                        break;
                    }
                    case 14: {
                        mmp.setASSPExports(true);
                        break;
                    }
                    case 17: {
                        mmp.setCompressTarget(true);
                        break;
                    }
                    case 25: {
                        mmp.setExportUnfrozen(true);
                        break;
                    }
                    case 29: {
                        mmp.setNoCompressTarget(true);
                        break;
                    }
                    case 30: {
                        mmp.setNoExportLibrary(true);
                        break;
                    }
                    case 31: {
                        mmp.setNoStrictDef(true);
                        break;
                    }
                    case 33: {
                        mmp.setSrcDbg(true);
                        break;
                    }
                    case 35: {
                        mmp.setStrictDepend(true);
                    }
                }
                continue;
            }
            if (statement instanceof StringListValueElement) {
                StringListValueElement stringList = (StringListValueElement)statement;
                switch (statement.getKind()) {
                    case 13: {
                        mmp.setASSPLibrary(stringList.getValue());
                        break;
                    }
                    case 18: {
                        mmp.setDebugLibrary(stringList.getValue());
                        break;
                    }
                    case 19: {
                        mmp.setDefFile(stringList.getValue()[0]);
                        break;
                    }
                    case 20: {
                        mmp.setDocument(stringList.getValue());
                        break;
                    }
                    case 22: {
                        mmp.setEPOCProcessPriority(stringList.getValue()[0]);
                        break;
                    }
                    case 24: {
                        mmp.setExportLibrary(stringList.getValue()[0]);
                        break;
                    }
                    case 6: {
                        mmp.setLang(stringList.getValue());
                        break;
                    }
                    case 26: {
                        mmp.setLibrary(stringList.getValue());
                        break;
                    }
                    case 27: {
                        mmp.setLinkAs(stringList.getValue()[0]);
                        break;
                    }
                    case 28: {
                        mmp.setMacro(stringList.getValue());
                        break;
                    }
                    case 7: {
                        mmp.setResource(stringList.getValue());
                        break;
                    }
                    case 5: {
                        mmp.setSource(stringList.getValue());
                        break;
                    }
                    case 3: {
                        mmp.setSourcePath(stringList.getValue()[0]);
                        break;
                    }
                    case 34: {
                        mmp.setStaticLibrary(stringList.getValue());
                        break;
                    }
                    case 36: {
                        mmp.setSystemInclude(stringList.getValue());
                        break;
                    }
                    case 37: {
                        mmp.setSystemResource(stringList.getValue());
                        break;
                    }
                    case 8: {
                        mmp.setTarget(stringList.getValue()[0]);
                        break;
                    }
                    case 38: {
                        mmp.setTargetType(stringList.getValue()[0]);
                        break;
                    }
                    case 4: {
                        mmp.setTargetPath(stringList.getValue()[0]);
                        break;
                    }
                    case 39: {
                        mmp.setUserInclude(stringList.getValue());
                        break;
                    }
                    case 41: {
                        mmp.setWin32Library(stringList.getValue());
                    }
                }
                continue;
            }
            if (statement instanceof IntListValueElement) {
                IntListValueElement intList = (IntListValueElement)statement;
                switch (statement.getKind()) {
                    case 9: {
                        Integer[] value = intList.getValue();
                        mmp.setUID1(value[0]);
                        if (value.length <= 1) continue block50;
                        mmp.setUID2(value[1]);
                        break;
                    }
                    case 40: {
                        mmp.setVendorId(intList.getValue()[0]);
                        break;
                    }
                    case 15: {
                        mmp.setBaseAddress(intList.getValue()[0]);
                        break;
                    }
                    case 21: {
                        mmp.setEPOCHeapSize(intList.getValue()[0], intList.getValue()[1]);
                        break;
                    }
                    case 23: {
                        mmp.setEPOCStackSize(intList.getValue()[0]);
                    }
                }
                continue;
            }
            switch (statement.getKind()) {
                case 10: {
                    mmp.setAIF((AIFElement)statement);
                    break;
                }
                case 16: {
                    mmp.setCapabilities(((CapabilityListValueElement)statement).getValue());
                    break;
                }
                case 32: {
                    OptionElement option = (OptionElement)statement;
                    mmp.setOption(option.getValue(), option.getCompilerOptions());
                    break;
                }
                case 7: {
                    mmp.addResourceBlock((ResourceStatementElement)statement);
                    break;
                }
                case 56: {
                    mmp.addBitmapBlock((BitmapStatementElement)statement);
                    break;
                }
                case 55: {
                    mmp.addPlatformBlock((PlatformSpecificMMPOverridesElement)statement);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesStack<V> {
        private V[] valuesStack = new Object[256];
        private int[] valuesLengthStack = new int[256];
        private int valuesPtr = -1;
        private int valuesLengthPtr = -1;

        ValuesStack() {
        }

        void push(V value) {
            int stackLength = this.valuesStack.length;
            if (++this.valuesPtr >= stackLength) {
                this.valuesStack = new Object[stackLength + 256];
                System.arraycopy(this.valuesStack, 0, this.valuesStack, 0, stackLength);
            }
            this.valuesStack[this.valuesPtr] = value;
            stackLength = this.valuesLengthStack.length;
            if (++this.valuesLengthPtr >= stackLength) {
                this.valuesLengthStack = new int[stackLength + 256];
                System.arraycopy(this.valuesLengthStack, 0, this.valuesLengthStack, 0, stackLength);
            }
            this.valuesLengthStack[this.valuesLengthPtr] = 1;
        }

        void concatLists() {
            int n = this.valuesLengthPtr - 1;
            this.valuesLengthStack[n] = this.valuesLengthStack[n] + this.valuesLengthStack[this.valuesLengthPtr];
            --this.valuesLengthPtr;
        }

        void pushZeroLength() {
            int stackLength = this.valuesLengthStack.length;
            if (++this.valuesLengthPtr >= stackLength) {
                this.valuesLengthStack = new int[stackLength + 256];
                System.arraycopy(this.valuesLengthStack, 0, this.valuesLengthStack, 0, stackLength);
            }
            this.valuesLengthStack[this.valuesLengthPtr] = 0;
        }

        Iterator<V> pop() {
            int length;
            if ((length = this.valuesLengthStack[this.valuesLengthPtr--]) > 0) {
                this.valuesPtr -= length;
                Object[] values = new Object[length];
                System.arraycopy(this.valuesStack, this.valuesPtr + 1, values, 0, length);
                return new ReadOnlyArrayIterator(values);
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ReadOnlyArrayIterator
        implements Iterator<V> {
            private V[] values;
            private int ptr = 0;

            public ReadOnlyArrayIterator(V[] values) {
                this.values = values;
            }

            @Override
            public boolean hasNext() {
                return this.ptr < this.values.length;
            }

            @Override
            public V next() {
                return this.values[this.ptr++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

