/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui;

import com.symbian.cdt.project.ProjectPlugin;
import com.symbian.cdt.templateengine.ui.IWizardDataPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewProjectCreationPage
extends WizardNewProjectCreationPage
implements IWizardDataPage {
    private Map<String, String> data = new HashMap<String, String>(2);
    private static final String ERROR_SUFFIX = " is an invalid name on this platform.";
    private static final Status OK_STATUS = new Status(0, ProjectPlugin.getUniqueId(), 0, "", null);

    public NewProjectCreationPage(String name) {
        super(name);
    }

    public Map<String, String> getPageData() {
        String projName = super.getProjectName().trim();
        this.data.put("projectName", projName);
        this.data.put("baseName", this.getBaseName(projName));
        this.data.put("location", super.getLocationPath().toPortableString());
        return this.data;
    }

    private String getBaseName(String projName) {
        String baseName = projName;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        return baseName;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            IStatus validName = this.isValidName(this.getProjectName());
            if (!validName.isOK()) {
                this.setErrorMessage(validName.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    private IStatus isValidName(String projectName) {
        String baseName = this.getBaseName(projectName);
        if (!Character.isLetter(baseName.charAt(0))) {
            return new Status(4, ProjectPlugin.getUniqueId(), 4, String.valueOf(projectName) + ERROR_SUFFIX, null);
        }
        int i = 1;
        int l = baseName.length();
        while (i < l) {
            char c = baseName.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return new Status(4, ProjectPlugin.getUniqueId(), 4, String.valueOf(projectName) + ERROR_SUFFIX, null);
            }
            ++i;
        }
        return OK_STATUS;
    }
}

