/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui;

import com.symbian.cdt.project.ui.NewProjectCreationPage;
import com.symbian.cdt.project.ui.SDKOptionsPage;
import com.symbian.cdt.templateengine.Template;
import com.symbian.cdt.templateengine.TemplateEngine;
import com.symbian.cdt.templateengine.ui.IWizardDataPage;
import com.symbian.cdt.templateengine.ui.TemplatesChoiceWizard;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewSymbianProjectWizard
extends TemplatesChoiceWizard
implements INewWizard,
IExecutableExtension {
    public static final String WIZARD_ID = NewSymbianProjectWizard.class.getName();
    private static final Template[] EMPTY_TEMPLATES = new Template[0];
    private IWizardDataPage[] pagesBeforeTemplatePages;
    private IWizardDataPage[] pagesAfterTemplatePages;
    private NewProjectCreationPage newProjectCreationPage;
    private SDKOptionsPage sdkOptionsPage;
    private IConfigurationElement configElement;
    static /* synthetic */ Class class$0;

    public NewSymbianProjectWizard() {
        this.setWindowTitle("New Symbian OS C++ Project Wizard");
    }

    protected IWizardDataPage[] getPagesBeforeTemplatePages() {
        if (this.pagesBeforeTemplatePages == null) {
            this.newProjectCreationPage = new NewProjectCreationPage("Symbian OS C++ Project");
            this.newProjectCreationPage.setTitle("Symbian OS C++ Project");
            this.newProjectCreationPage.setDescription("Create a new Symbian OS C++ Project.");
            this.sdkOptionsPage = new SDKOptionsPage("Project Type and SDKs");
            this.pagesBeforeTemplatePages = new IWizardDataPage[]{this.newProjectCreationPage, this.sdkOptionsPage};
        }
        return this.pagesBeforeTemplatePages;
    }

    protected IWizardDataPage[] getPagesAfterTemplatePages() {
        if (this.pagesAfterTemplatePages == null) {
            this.pagesAfterTemplatePages = new IWizardDataPage[0];
        }
        return this.pagesAfterTemplatePages;
    }

    public Template[] getTemplates() {
        IProjectType projectType = this.sdkOptionsPage.getSelectedProjectType();
        if (projectType == null) {
            return EMPTY_TEMPLATES;
        }
        TreeSet templateList = new TreeSet(Template.TEMPLATE_LABEL_CASE_INSENSITIVE_COMPARATOR);
        String[] stringArray = this.sdkOptionsPage.getSelectedSDKIds();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String sdkId = stringArray[n];
            templateList.addAll(Arrays.asList(TemplateEngine.getTemplateEngine().getTemplates(WIZARD_ID, sdkId, projectType.getId())));
            ++n;
        }
        return templateList.toArray(new Template[templateList.size()]);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public boolean performFinish() {
        boolean retVal = super.performFinish();
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return retVal;
    }
}

