/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui;

import com.symbian.cdt.build.BuildPlugin;
import com.symbian.cdt.sdk.SDKSupportPlugin;
import com.symbian.cdt.sdk.api.ISDK;
import com.symbian.cdt.templateengine.ui.IWizardDataPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKOptionsPage
extends WizardPage
implements IWizardDataPage {
    private static final Map<String, String> data = new HashMap<String, String>(1);
    protected Combo projectTypeCombo;
    private Set<String> selectedSDKIds;
    private IProjectType selectedProjectType;
    private CheckboxTableViewer tableViewer;
    private String[] projectTypeNames;
    private List<IProjectType> projectTypes;
    private SortedSet<ISDK> allValidSDKs;

    public SDKOptionsPage(String pageName) {
        super(pageName);
        this.setTitle("Project Type and SDKs");
        this.setDescription("Select the project type and the working set of SDKs.");
        this.setPageComplete(false);
        this.selectedProjectType = null;
        this.selectedSDKIds = new HashSet<String>();
    }

    public boolean canFlipToNextPage() {
        return this.validatePage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createTypeSelectGroup(composite);
        this.createSDKSelectionGroup(composite);
        this.populateTypes();
        this.projectTypeCombo.select(0);
        this.handleTypeSelection();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createSDKSelectionGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label configLabel = new Label(composite, 16384);
        configLabel.setFont(composite.getFont());
        configLabel.setText("SDKs");
        Table table = new Table(composite, 2854);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.setLayout((Layout)new TableLayout());
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NameProvider());
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object parent) {
                return ((SortedSet)parent).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                SDKOptionsPage.this.handleSDKIdsSelectionChange();
            }
        });
    }

    private void createTypeSelectGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label platformLabel = new Label(composite, 16384);
        platformLabel.setFont(composite.getFont());
        platformLabel.setText("Project Type");
        this.projectTypeCombo = new Combo(composite, 2060);
        this.projectTypeCombo.setFont(composite.getFont());
        this.projectTypeCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SDKOptionsPage.this.handleTypeSelection();
            }
        });
        this.projectTypeCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SDKOptionsPage.this.projectTypeCombo = null;
            }
        });
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.projectTypeCombo.setLayoutData((Object)gd);
    }

    public String[] getSelectedSDKIds() {
        return this.selectedSDKIds.toArray(new String[this.selectedSDKIds.size()]);
    }

    public String[] getSelectedConfigIds() {
        ArrayList<String> configIds = new ArrayList<String>();
        for (String sdkId : this.selectedSDKIds) {
            ISDK sdk = SDKSupportPlugin.getDefault().getSDK(sdkId);
            if (sdk == null) continue;
            for (String configId : sdk.getBuildConfigurations().keySet()) {
                configIds.add(configId);
            }
        }
        return configIds.toArray(new String[configIds.size()]);
    }

    public IProjectType getSelectedProjectType() {
        return this.selectedProjectType;
    }

    protected void handleTypeSelection() {
        int index;
        if (this.projectTypeCombo != null && (index = this.projectTypeCombo.getSelectionIndex()) != -1 && this.selectedProjectType != this.projectTypes.get(index)) {
            this.selectedProjectType = this.projectTypes.get(index);
        }
        this.populateSDKs();
        this.setPageComplete(this.validatePage());
    }

    private void populateSDKs() {
        Object[] selectedSDKs;
        if (this.selectedProjectType == null) {
            return;
        }
        IConfiguration[] allConfigs = this.selectedProjectType.getConfigurations();
        TreeSet<ISDK> sdks = new TreeSet<ISDK>(new Comparator<ISDK>(){

            @Override
            public int compare(ISDK sdk1, ISDK sdk2) {
                return String.CASE_INSENSITIVE_ORDER.compare(sdk1.getLabel(), sdk2.getLabel());
            }
        });
        IConfiguration[] iConfigurationArray = allConfigs;
        int n = 0;
        int n2 = iConfigurationArray.length;
        while (n < n2) {
            IConfiguration config = iConfigurationArray[n];
            ISDK sdk = SDKSupportPlugin.getDefault().getSDKForBuildConfiguration(config);
            if (sdk != null) {
                sdks.add(sdk);
            }
            ++n;
        }
        this.allValidSDKs = sdks;
        Object[] objectArray = selectedSDKs = sdks.toArray(new ISDK[sdks.size()]);
        n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            ISDK sdk = objectArray[n2];
            this.selectedSDKIds.add(sdk.getUniqueId());
            ++n2;
        }
        this.tableViewer.setInput(this.allValidSDKs);
        this.tableViewer.setCheckedElements(selectedSDKs);
        this.handleSDKIdsSelectionChange();
    }

    private void handleSDKIdsSelectionChange() {
        Object[] checkedElements = this.tableViewer.getCheckedElements();
        this.selectedSDKIds.clear();
        int i = 0;
        while (i < checkedElements.length) {
            this.selectedSDKIds.add(((ISDK)checkedElements[i]).getUniqueId());
            ++i;
        }
        this.setPageComplete(this.validatePage());
    }

    private void populateTypes() {
        this.projectTypes = Arrays.asList(BuildPlugin.getDefault().getSymbianProjectTypes());
        this.projectTypeNames = new String[this.projectTypes.size()];
        int index = 0;
        for (IProjectType projType : this.projectTypes) {
            this.projectTypeNames[index++] = projType.getName();
        }
        this.projectTypeCombo.removeAll();
        this.projectTypeCombo.setItems(this.projectTypeNames);
    }

    private boolean validatePage() {
        if (this.tableViewer.getCheckedElements().length > 0) {
            this.setErrorMessage(null);
            return true;
        }
        if (this.allValidSDKs.isEmpty()) {
            this.setErrorMessage("No valid SDK configurations found for this project type.");
        } else {
            this.setErrorMessage("Please select atleast one SDK to work with.");
        }
        return false;
    }

    public Map<String, String> getPageData() {
        if (this.selectedProjectType == null) {
            data.put("projectType", null);
        } else {
            data.put("projectType", this.selectedProjectType.getId());
        }
        if (this.selectedSDKIds == null) {
            data.put("configs", null);
        } else {
            String[] selectedConfigIds = this.getSelectedConfigIds();
            StringBuilder b = new StringBuilder();
            String[] stringArray = selectedConfigIds;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String s = stringArray[n];
                b.append(s);
                if (s != selectedConfigIds[selectedConfigIds.length - 1]) {
                    b.append(',');
                }
                ++n;
            }
            data.put("configs", b.toString());
        }
        return data;
    }

    private static class NameProvider
    extends LabelProvider
    implements ITableLabelProvider {
        NameProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ISDK) {
                return ((ISDK)obj).getLabel();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

