/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui.editors;

import com.symbian.cdt.project.ProjectPlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIFDefEditor
extends EditorPart
implements IResourceChangeListener {
    private Action action;
    private Text mbmFileText;
    private Text aifFileText;
    private List bmpList;
    private List selectedList;
    private Combo colorScaleCombo;
    private Combo colorDepthCombo;
    private Combo maskDepthCombo;
    private Button aifFileButton;
    private Button mbmFileButton;
    private Button rightButton;
    private Button upButton;
    private Button leftButton;
    private Button downButton;
    private Button mbmInputCheck;
    private Group aifFileGroup;
    private Group mbmFileGroup;
    private Group bmpFileGroup;
    private boolean dirty;
    private static final String SAVE = "org.eclipse.ui.file.save";
    static final String[] DEPTH_ITEMS = new String[]{"2", "4", "8"};
    static final String[] COLOR_SCALE_ITEMS = new String[]{"Yes", "No"};

    public AIFDefEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void createFormPage(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        this.aifFileGroup = new Group(composite, 0);
        this.aifFileGroup.setText("Aif Resource File");
        this.aifFileGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.aifFileGroup.setLayoutData((Object)gd);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = null;
                int index = -1;
                try {
                    String str;
                    int i;
                    int[] indices;
                    if (e.getSource().equals(AIFDefEditor.this.aifFileButton) && (fileName = AIFDefEditor.this.openResourceDialog("aifdef")) != null) {
                        AIFDefEditor.this.aifFileText.setText(fileName.toString());
                        AIFDefEditor.this.setDirty(true);
                    }
                    if (e.getSource().equals(AIFDefEditor.this.mbmInputCheck)) {
                        if (AIFDefEditor.this.mbmInputCheck.getSelection()) {
                            AIFDefEditor.this.updateGroup(AIFDefEditor.this.mbmFileGroup, true);
                            AIFDefEditor.this.updateGroup(AIFDefEditor.this.bmpFileGroup, false);
                        } else {
                            AIFDefEditor.this.updateGroup(AIFDefEditor.this.mbmFileGroup, false);
                            AIFDefEditor.this.updateGroup(AIFDefEditor.this.bmpFileGroup, true);
                        }
                        AIFDefEditor.this.setDirty(true);
                    }
                    if (e.getSource().equals(AIFDefEditor.this.mbmFileButton) && (fileName = AIFDefEditor.this.openResourceDialog("mbm")) != null) {
                        AIFDefEditor.this.mbmFileText.setText(fileName.toString());
                        AIFDefEditor.this.setDirty(true);
                    }
                    if (e.getSource().equals(AIFDefEditor.this.rightButton)) {
                        indices = AIFDefEditor.this.bmpList.getSelectionIndices();
                        if (indices != null) {
                            i = 0;
                            while (i < indices.length) {
                                AIFDefEditor.this.selectedList.add(AIFDefEditor.this.bmpList.getItem(indices[i]));
                                ++i;
                            }
                            AIFDefEditor.this.setDirty(true);
                            i = 0;
                            while (i < AIFDefEditor.this.selectedList.getItemCount()) {
                                if (AIFDefEditor.this.bmpList.indexOf(AIFDefEditor.this.selectedList.getItem(i)) != -1) {
                                    AIFDefEditor.this.bmpList.remove(AIFDefEditor.this.selectedList.getItem(i));
                                }
                                ++i;
                            }
                        }
                        AIFDefEditor.this.selectedList.setSelection(AIFDefEditor.this.selectedList.getItemCount() - 1);
                    }
                    if (e.getSource().equals(AIFDefEditor.this.leftButton)) {
                        indices = AIFDefEditor.this.selectedList.getSelectionIndices();
                        if (indices != null) {
                            i = 0;
                            while (i < indices.length) {
                                AIFDefEditor.this.bmpList.add(AIFDefEditor.this.selectedList.getItem(indices[i]));
                                ++i;
                            }
                            AIFDefEditor.this.setDirty(true);
                            i = 0;
                            while (i < AIFDefEditor.this.bmpList.getItemCount()) {
                                if (AIFDefEditor.this.selectedList.indexOf(AIFDefEditor.this.bmpList.getItem(i)) != -1) {
                                    AIFDefEditor.this.selectedList.remove(AIFDefEditor.this.bmpList.getItem(i));
                                }
                                ++i;
                            }
                        }
                        AIFDefEditor.this.bmpList.setSelection(AIFDefEditor.this.bmpList.getItemCount() - 1);
                    }
                    if (e.getSource().equals(AIFDefEditor.this.upButton) && (index = AIFDefEditor.this.selectedList.getSelectionIndex()) > 0) {
                        str = AIFDefEditor.this.selectedList.getItem(index);
                        AIFDefEditor.this.selectedList.remove(index);
                        AIFDefEditor.this.selectedList.add(str, index - 1);
                        AIFDefEditor.this.selectedList.setSelection(index - 1);
                        AIFDefEditor.this.setDirty(true);
                    }
                    if (e.getSource().equals(AIFDefEditor.this.downButton) && (index = AIFDefEditor.this.selectedList.getSelectionIndex()) >= 0) {
                        str = AIFDefEditor.this.selectedList.getItem(index);
                        AIFDefEditor.this.selectedList.remove(index);
                        AIFDefEditor.this.selectedList.add(str, index + 1);
                        AIFDefEditor.this.selectedList.setSelection(index + 1);
                        AIFDefEditor.this.setDirty(true);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                AIFDefEditor.this.updateButtons();
            }
        };
        new Label((Composite)this.aifFileGroup, 0).setText("Aif File");
        this.aifFileText = new Text((Composite)this.aifFileGroup, 18432);
        this.aifFileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AIFDefEditor.this.setDirty(true);
            }
        });
        gd = new GridData(768);
        this.aifFileText.setLayoutData((Object)gd);
        this.aifFileButton = new Button((Composite)this.aifFileGroup, 131072);
        this.aifFileButton.setText("Browse...");
        this.aifFileButton.addSelectionListener((SelectionListener)listener);
        new Label(composite, 0).setText("");
        this.mbmInputCheck = new Button(composite, 32);
        this.mbmInputCheck.setText("Use MBM as Input");
        this.mbmInputCheck.addSelectionListener((SelectionListener)listener);
        this.mbmFileGroup = new Group(composite, 0);
        this.mbmFileGroup.setText("MBM Resource File");
        this.mbmFileGroup.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.mbmFileGroup.setLayoutData((Object)gd);
        new Label((Composite)this.mbmFileGroup, 0).setText("Mbm File");
        this.mbmFileText = new Text((Composite)this.mbmFileGroup, 18432);
        this.mbmFileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AIFDefEditor.this.setDirty(true);
            }
        });
        this.mbmFileText.setLayoutData((Object)new GridData(768));
        this.mbmFileButton = new Button((Composite)this.mbmFileGroup, 131072);
        this.mbmFileButton.setText("Browse...");
        this.mbmFileButton.addSelectionListener((SelectionListener)listener);
        this.bmpFileGroup = new Group(composite, 0);
        this.bmpFileGroup.setText("BMP Resource File");
        this.bmpFileGroup.setLayout((Layout)new GridLayout(6, false));
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.bmpFileGroup.setLayoutData((Object)gd);
        Label tmp = new Label((Composite)this.bmpFileGroup, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        tmp.setLayoutData((Object)gd);
        Label bmpLabel = new Label((Composite)this.bmpFileGroup, 0);
        bmpLabel.setText("BMP");
        gd = new GridData();
        gd.horizontalSpan = 2;
        bmpLabel.setLayoutData((Object)gd);
        Label selectedLabel = new Label((Composite)this.bmpFileGroup, 0);
        selectedLabel.setText("Selected BMP's");
        gd = new GridData();
        gd.horizontalSpan = 2;
        selectedLabel.setLayoutData((Object)gd);
        new Label((Composite)this.bmpFileGroup, 0).setText("Color Scale");
        this.colorScaleCombo = new Combo((Composite)this.bmpFileGroup, 8);
        this.colorScaleCombo.setLayoutData((Object)new GridData(768));
        this.colorScaleCombo.setItems(COLOR_SCALE_ITEMS);
        this.colorScaleCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AIFDefEditor.this.setDirty(true);
            }
        });
        this.bmpList = new List((Composite)this.bmpFileGroup, 2562);
        gd = new GridData(1808);
        gd.minimumWidth = 90;
        gd.heightHint = 75;
        gd.verticalSpan = 3;
        this.bmpList.setLayoutData((Object)gd);
        for (String bmp : this.getBMPs()) {
            this.bmpList.add(bmp);
        }
        this.bmpList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AIFDefEditor.this.updateButtons();
            }
        });
        this.rightButton = new Button((Composite)this.bmpFileGroup, 8);
        this.rightButton.setText("-->");
        this.rightButton.addSelectionListener((SelectionListener)listener);
        this.selectedList = new List((Composite)this.bmpFileGroup, 2560);
        gd = new GridData(1808);
        gd.verticalSpan = 3;
        gd.minimumWidth = 90;
        gd.heightHint = 75;
        this.selectedList.setLayoutData((Object)gd);
        this.selectedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AIFDefEditor.this.updateButtons();
            }
        });
        this.upButton = new Button((Composite)this.bmpFileGroup, 8);
        this.upButton.setText("   Up  ");
        this.upButton.addSelectionListener((SelectionListener)listener);
        new Label((Composite)this.bmpFileGroup, 0).setText("Color Depth");
        this.colorDepthCombo = new Combo((Composite)this.bmpFileGroup, 8);
        this.colorDepthCombo.setLayoutData((Object)new GridData(768));
        this.colorDepthCombo.setItems(DEPTH_ITEMS);
        this.colorDepthCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AIFDefEditor.this.setDirty(true);
            }
        });
        this.leftButton = new Button((Composite)this.bmpFileGroup, 8);
        this.leftButton.setText("<--");
        this.leftButton.addSelectionListener((SelectionListener)listener);
        this.downButton = new Button((Composite)this.bmpFileGroup, 8);
        this.downButton.setText("Down");
        this.downButton.addSelectionListener((SelectionListener)listener);
        new Label((Composite)this.bmpFileGroup, 0).setText("Mask Depth");
        this.maskDepthCombo = new Combo((Composite)this.bmpFileGroup, 8);
        this.maskDepthCombo.setLayoutData((Object)new GridData(768));
        this.maskDepthCombo.setItems(DEPTH_ITEMS);
        this.updateGroup(this.mbmFileGroup, false);
        this.loadFromFile();
        this.updateButtons();
    }

    protected String openResourceDialog(final String extn) {
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        IProject project = input.getFile().getProject();
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){
            private IStatus errorStatus = new Status(4, ProjectPlugin.getUniqueId(), 4, "Error", null);
            private IStatus okStatus = new Status(0, ProjectPlugin.getUniqueId(), 0, "OK", null);

            public IStatus validate(Object[] selection) {
                Object[] objectArray = selection;
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Object element = objectArray[n];
                    if (!(element instanceof IFile) || ((IFile)element).getFileExtension() == null || !((IFile)element).getFileExtension().equals(extn)) {
                        return this.errorStatus;
                    }
                    ++n;
                }
                return this.okStatus;
            }
        };
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IFile && ((IFile)element).getFileExtension() != null && ((IFile)element).getFileExtension().equals(extn);
            }
        };
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSite().getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(validator);
        dialog.setTitle("Select File");
        dialog.setMessage("Hi");
        dialog.addFilter(filter);
        dialog.setInput((Object)project);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            return ((IFile)dialog.getFirstResult()).getFullPath().toOSString();
        }
        return null;
    }

    protected void updateGroup(Group group, boolean b) {
        Control[] controls = null;
        group.setEnabled(b);
        Control[] controlArray = controls = group.getChildren();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            Control cntrl = controlArray[n];
            cntrl.setEnabled(b);
            ++n;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        block7: {
            try {
                this.saveFile((IFileEditorInput)this.getEditorInput(), monitor);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status != null && status.getSeverity() == 8) break block7;
                String title = "Save As";
                String msg = "Error while saving: " + e.getMessage();
                Shell shell = this.getSite().getShell();
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                }
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveFile(IFileEditorInput input, IProgressMonitor monitor) throws CoreException {
        String str;
        block15: {
            String item;
            int index;
            block18: {
                block19: {
                    block17: {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        str = "";
                        index = -1;
                        item = null;
                        item = this.aifFileText.getText();
                        if (item.length() == 0 || item.trim().equals("")) break block17;
                        str = String.valueOf(str) + this.aifFileText.getText() + ",";
                        if (!this.mbmFileText.getEnabled()) break block18;
                        break block19;
                    }
                    this.displayError("aif file is mandatory");
                    this.aifFileButton.setFocus();
                    return;
                }
                item = this.mbmFileText.getText();
                if (item.length() != 0 && !item.trim().equals("")) {
                    str = String.valueOf(str) + this.mbmFileText.getText();
                    break block15;
                } else {
                    this.displayError("mbm file is mandatory");
                    this.mbmFileButton.setFocus();
                    return;
                }
            }
            index = this.colorScaleCombo.getSelectionIndex();
            if (index != -1 && (item = this.colorScaleCombo.getItem(index)).equalsIgnoreCase("yes")) {
                str = String.valueOf(str) + item + ",";
            }
            if ((index = this.colorDepthCombo.getSelectionIndex()) == -1) {
                this.displayError("Color Depth is mandatory");
                this.colorDepthCombo.setFocus();
                return;
            }
            item = this.colorDepthCombo.getItem(index);
            if (item.length() != 0) {
                str = String.valueOf(str) + item + ",";
            }
            if ((index = this.maskDepthCombo.getSelectionIndex()) != -1 && (item = this.maskDepthCombo.getItem(index)).length() != 0) {
                str = String.valueOf(str) + item + ",";
            }
            String[] selected = null;
            selected = this.selectedList.getItems();
            if (selected == null) {
                this.displayError("Atleast One Bmp should be selected");
                this.bmpList.select(0);
                return;
            }
            if (selected.length == 0) {
                this.displayError("Atleast One Bmp should be selected");
                this.bmpList.select(0);
                return;
            }
            String[] stringArray = selected;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String st = stringArray[n];
                str = String.valueOf(str) + st + ",";
                ++n;
            }
        }
        IFile file = input.getFile();
        byte[] bytes = str.getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        if (file.exists()) {
            file.setContents((InputStream)stream, false, true, monitor);
        } else {
            try {
                ContainerCreator creator = new ContainerCreator(file.getWorkspace(), file.getParent().getFullPath());
                creator.createContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            finally {
                monitor.done();
            }
        }
        this.setDirty(false);
    }

    public void doSaveAs() {
        block14: {
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile original = ((IFileEditorInput)input).getFile();
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            if (dialog.open() == 1) {
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            boolean success = false;
            try {
                try {
                    this.saveFile((IFileEditorInput)newInput, null);
                    success = true;
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status != null && status.getSeverity() == 8) break block14;
                    String title = "Save As";
                    String msg = "Error while saving: " + e.getMessage();
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block14;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            finally {
                if (success) {
                    this.setPartName(newInput.getName());
                    this.setInput((IEditorInput)newInput);
                }
            }
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.internalInit(site.getWorkbenchWindow(), site, editorInput);
    }

    protected final void internalInit(IWorkbenchWindow window, IEditorSite site, final IEditorInput input) throws PartInitException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AIFDefEditor.this.doSetInput(input);
                }
                catch (CoreException x) {
                    throw new InvocationTargetException(x);
                }
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(false, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof CoreException) {
                CoreException e = (CoreException)t;
                IStatus status = e.getStatus();
                if (status.getException() != null) {
                    throw new PartInitException(status);
                }
                throw new PartInitException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), t));
            }
            throw new PartInitException((IStatus)new Status(4, ProjectPlugin.getUniqueId(), 0, "Error initializing the editor", t));
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            super.setInput(input);
            this.setPartName(input.getName());
        }
    }

    private void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                AIFDefEditor.this.getSite().getPage().closeEditor((IEditorPart)AIFDefEditor.this, save);
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = AIFDefEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = 0;
                    int n2 = iWorkbenchPageArray.length;
                    while (n < n2) {
                        IWorkbenchPage page = iWorkbenchPageArray[n];
                        if (((FileEditorInput)AIFDefEditor.this.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = page.findEditor(AIFDefEditor.this.getEditorInput());
                            page.closeEditor(editorPart, true);
                        }
                        ++n;
                    }
                }
            });
        }
    }

    private void updateButtons() {
        if (!this.mbmInputCheck.getSelection()) {
            if (this.bmpList.getItems().length > 0) {
                this.rightButton.setEnabled(true);
            } else {
                this.rightButton.setEnabled(false);
            }
            if (this.bmpList.getSelectionIndex() != -1) {
                this.rightButton.setEnabled(true);
            } else {
                this.rightButton.setEnabled(false);
            }
            if (this.selectedList.getItems().length > 0) {
                this.leftButton.setEnabled(true);
            } else {
                this.leftButton.setEnabled(false);
            }
            if (this.selectedList.getSelectionIndex() != -1) {
                this.leftButton.setEnabled(true);
            } else {
                this.leftButton.setEnabled(false);
            }
            if (this.selectedList.getSelectionIndex() == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (this.selectedList.getSelectionIndex() == this.selectedList.getItemCount() - 1) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
            if (this.selectedList.getItemCount() == 0) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void createPartControl(Composite parent) {
        this.createFormPage(parent);
        this.action = new Action(){

            public void run() {
                AIFDefEditor.this.getSite().getPage().saveEditor((IEditorPart)AIFDefEditor.this, false);
            }
        };
        this.action.setActionDefinitionId(SAVE);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.action);
    }

    public void setFocus() {
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(257);
        if (this.action != null) {
            this.action.setEnabled(this.isDirty());
        }
    }

    private void loadFromFile() {
        String content = "";
        try {
            InputStream in = ((IFileEditorInput)this.getEditorInput()).getStorage().getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((content = br.readLine()) != null) {
                if (content.trim().length() == 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (content == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        int count = tokenizer.countTokens();
        String[] str = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            str[i] = tokenizer.nextToken();
            System.out.println("Content " + str[i]);
            ++i;
        }
        int incr = 0;
        if (str.length != 0) {
            if (str.length >= 2 && str.length < this.bmpList.getItemCount() + 4) {
                if (!this.isValidFile(str[0], "aifdef")) {
                    this.displayError("Wrong in aif file. Can not be loaded");
                    return;
                }
                this.aifFileText.setText(str[incr++]);
                if (str.length == 2) {
                    if (!this.isValidFile(str[1], "mbmdef")) {
                        this.displayError("Wrong in mbm file. Can not be loaded");
                        return;
                    }
                    this.mbmFileText.setText(str[incr]);
                    this.mbmInputCheck.setSelection(true);
                    this.updateGroup(this.bmpFileGroup, false);
                    this.updateGroup(this.mbmFileGroup, true);
                } else {
                    if (str[incr].equalsIgnoreCase("yes") || str[incr].equalsIgnoreCase("no")) {
                        this.colorScaleCombo.select(this.colorScaleCombo.indexOf(str[incr++]));
                    }
                    if (str[incr].length() == 1) {
                        if (this.isValidDepth(str[incr])) {
                            this.colorDepthCombo.select(this.colorDepthCombo.indexOf(str[incr++]));
                        } else {
                            this.displayError("Wrong in Color Depth Entry. Can not be loaded");
                            return;
                        }
                    }
                    if (str[incr].length() == 1) {
                        if (this.isValidDepth(str[incr].trim())) {
                            this.maskDepthCombo.select(this.maskDepthCombo.indexOf(str[incr++].trim()));
                        } else {
                            this.displayError("Wrong in Mask Depth Entry. Can not be loaded");
                            return;
                        }
                    }
                    if (str.length > 2) {
                        String[] ListItems = new String[str.length - incr];
                        int i2 = 0;
                        int j = incr;
                        while (j < str.length) {
                            ListItems[i2] = str[j];
                            ++i2;
                            ++j;
                        }
                        i2 = 0;
                        while (i2 < ListItems.length) {
                            if (!this.isValidListEntry(ListItems[i2])) {
                                this.displayError("Wrong in List Entry. Can not be loaded");
                                return;
                            }
                            this.selectedList.add(ListItems[i2]);
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < this.selectedList.getItemCount()) {
                            if (this.bmpList.indexOf(this.selectedList.getItem(i2)) != -1) {
                                this.bmpList.remove(this.selectedList.getItem(i2));
                            }
                            ++i2;
                        }
                    }
                }
            } else {
                this.displayError("Wrong in Entry. Can not be loaded");
            }
        }
        this.setDirty(false);
    }

    private boolean isValidListEntry(String item) {
        boolean retVal = false;
        if (item != null) {
            retVal = this.bmpList.indexOf(item) != -1;
        }
        return retVal;
    }

    private boolean isValidDepth(String str) {
        boolean retVal = false;
        if (str.length() == 1) {
            switch (str.toCharArray()[0]) {
                case '2': {
                    retVal = true;
                    break;
                }
                case '4': {
                    retVal = true;
                    break;
                }
                case '8': {
                    retVal = true;
                }
            }
        } else {
            retVal = false;
        }
        return retVal;
    }

    private boolean isValidFile(String fileName, String fileExtn) {
        String pathPattern = "([A-Za-z][:])?[/]?[A-Za-z0-9/. ]*";
        Pattern pattern = null;
        Matcher matcher = null;
        fileName = fileName.replace('\\', '/');
        if (fileExtn.equals("aifdef")) {
            pattern = Pattern.compile(String.valueOf(pathPattern) + "[aifdef]*");
            matcher = pattern.matcher(fileName);
        }
        if (fileExtn.equals("mbmdef")) {
            pattern = Pattern.compile(String.valueOf(pathPattern) + "[mbmdef]{1}");
            matcher = pattern.matcher(fileName);
        }
        return matcher.matches();
    }

    private void displayError(String err) {
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Aif Def Editor", (String)err);
    }

    private SortedSet<String> getBMPs() {
        final TreeSet<String> all = new TreeSet<String>();
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        IProject project = input.getFile().getProject();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        String extn = file.getFileExtension();
                        if (extn != null && extn.equals("bmp")) {
                            all.add(file.getProjectRelativePath().toPortableString());
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return all;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }
}

