/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui.editors;

import com.symbian.cdt.project.ui.editors.Line;
import com.symbian.cdt.project.ui.editors.MBMDefEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

class AddBMPWithoutMaskDialog
extends Dialog
implements SelectionListener {
    private Button colorScaleButton;
    private Combo colorDepth;
    private List bmpList;
    private Line[] lines;
    private MBMDefEditor editor;

    public AddBMPWithoutMaskDialog(Shell parentShell, MBMDefEditor editor) {
        super(parentShell);
        this.editor = editor;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBounds(420, 180, 250, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.createControls(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private void createControls(Composite composite) {
        new Label(composite, 0).setText("Color Scale");
        this.colorScaleButton = new Button(composite, 32);
        new Label(composite, 0).setText("Color Depth");
        this.colorDepth = new Combo(composite, 2056);
        this.colorDepth.setItems(MBMDefEditor.DEPTH_ITEMS);
        new Label(composite, 0).setText("Bitmap");
        this.bmpList = new List(composite, 2562);
        GridData gd = new GridData(2);
        gd.verticalAlignment = 1;
        gd.heightHint = 80;
        gd.widthHint = 80;
        this.bmpList.setLayoutData((Object)gd);
        for (String bmp : this.editor.getAllUnusedBMPs()) {
            this.bmpList.add(bmp);
        }
        this.colorDepth.addSelectionListener((SelectionListener)this);
        this.bmpList.addSelectionListener((SelectionListener)this);
    }

    protected void okPressed() {
        String[] bmps = this.bmpList.getSelection();
        String depth = "";
        if (this.colorDepth.getSelectionIndex() != -1) {
            depth = this.colorDepth.getItem(this.colorDepth.getSelectionIndex());
        }
        boolean scale = this.colorScaleButton.getSelection();
        this.lines = new Line[bmps.length];
        int i = 0;
        while (i < bmps.length) {
            this.lines[i] = new Line(scale, Integer.parseInt(depth), bmps[i]);
            ++i;
        }
        super.close();
    }

    public Line[] getLines() {
        return this.lines;
    }

    public void widgetSelected(SelectionEvent e) {
        this.getButton(0).setEnabled(this.bmpList.getSelectionCount() > 0 && this.colorDepth.getSelectionIndex() >= 0);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

