/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui.editors;

import com.symbian.cdt.project.ui.editors.Line;
import com.symbian.cdt.project.ui.editors.MBMDefEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

class AddBMPsDialog
extends Dialog {
    private Button colorScaleButton;
    private Combo colorDepth;
    private Combo maskDepth;
    private List bmpList;
    private List maskList;
    private Line line;
    private MBMDefEditor editor;

    public AddBMPsDialog(Shell parentShell, MBMDefEditor editor) {
        super(parentShell);
        this.editor = editor;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBounds(420, 180, 300, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.createControls(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private void createControls(Composite composite) {
        new Label(composite, 0).setText("Color Scale");
        this.colorScaleButton = new Button(composite, 32);
        new Label(composite, 0).setText("Color Depth");
        this.colorDepth = new Combo(composite, 2056);
        this.colorDepth.setItems(MBMDefEditor.DEPTH_ITEMS);
        new Label(composite, 0).setText("Mask Depth");
        this.maskDepth = new Combo(composite, 2056);
        this.maskDepth.setItems(MBMDefEditor.DEPTH_ITEMS);
        new Label(composite, 0).setText("Bitmap");
        this.bmpList = new List(composite, 2560);
        GridData gd = new GridData(2);
        gd.verticalAlignment = 1;
        gd.heightHint = 60;
        gd.widthHint = 100;
        this.bmpList.setLayoutData((Object)gd);
        for (String bmp : this.editor.getAllUnusedBMPs()) {
            this.bmpList.add(bmp);
        }
        new Label(composite, 0).setText("Mask");
        this.maskList = new List(composite, 2560);
        gd = new GridData(2);
        gd.verticalAlignment = 1;
        gd.heightHint = 60;
        gd.widthHint = 100;
        this.maskList.setLayoutData((Object)gd);
        int i = 0;
        int l = this.bmpList.getItemCount();
        while (i < l) {
            this.maskList.add(this.bmpList.getItem(i));
            ++i;
        }
        this.bmpList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String[] selData = AddBMPsDialog.this.bmpList.getSelection();
                AddBMPsDialog.this.maskList.removeAll();
                if (selData.length == 0) {
                    int i = 0;
                    int l = AddBMPsDialog.this.bmpList.getItemCount();
                    while (i < l) {
                        AddBMPsDialog.this.maskList.add(AddBMPsDialog.this.bmpList.getItem(i));
                        ++i;
                    }
                } else {
                    int i = 0;
                    int l = AddBMPsDialog.this.bmpList.getItemCount();
                    while (i < l) {
                        String item = AddBMPsDialog.this.bmpList.getItem(i);
                        if (!selData[0].equals(item)) {
                            AddBMPsDialog.this.maskList.add(item);
                        }
                        ++i;
                    }
                }
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddBMPsDialog.this.getButton(0).setEnabled(AddBMPsDialog.this.bmpList.getSelectionCount() > 0 && AddBMPsDialog.this.maskList.getSelectionCount() > 0 && AddBMPsDialog.this.colorDepth.getSelectionIndex() >= 0 && AddBMPsDialog.this.maskDepth.getSelectionIndex() >= 0);
            }
        };
        this.colorDepth.addSelectionListener((SelectionListener)listener);
        this.maskDepth.addSelectionListener((SelectionListener)listener);
        this.bmpList.addSelectionListener((SelectionListener)listener);
        this.maskList.addSelectionListener((SelectionListener)listener);
    }

    protected void okPressed() {
        this.line = new Line(this.colorScaleButton.getSelection(), Integer.parseInt(this.colorDepth.getItem(this.colorDepth.getSelectionIndex())), Integer.parseInt(this.maskDepth.getItem(this.maskDepth.getSelectionIndex())), this.bmpList.getSelection()[0], this.maskList.getSelection()[0]);
        super.close();
    }

    public Line getLine() {
        return this.line;
    }
}

