/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui.editors;

import com.symbian.cdt.project.ui.editors.TextFile;

class Line {
    private boolean colorScale;
    private int colorDepth;
    private int maskDepth;
    private String bmp;
    private String mask;
    private TextFile textFile;
    private static final String DELIMITER = "|";

    Line(String lineStr, TextFile textFile) {
        this.textFile = textFile;
        this.colorScale = lineStr.charAt(0) == 'c';
        int i = this.colorScale ? 1 : 0;
        this.colorDepth = lineStr.charAt(i) - 48;
        if (lineStr.charAt(++i) == ',') {
            this.maskDepth = lineStr.charAt(++i) - 48;
            ++i;
        }
        if (this.maskDepth > 0) {
            int delimiter = lineStr.indexOf(DELIMITER, i + 1);
            this.bmp = lineStr.substring(i + 1, delimiter);
            this.mask = lineStr.substring(delimiter + 1);
        } else {
            this.bmp = lineStr.substring(i + 1);
            this.mask = null;
        }
    }

    Line(boolean scale, int depth, String bmp) {
        this.colorScale = scale;
        this.colorDepth = depth;
        this.bmp = bmp;
    }

    public Line(boolean colorScale, int colorDepth, int maskDepth, String bmp, String mask) {
        this.colorScale = colorScale;
        this.colorDepth = colorDepth;
        this.maskDepth = maskDepth;
        this.bmp = bmp;
        this.mask = mask;
    }

    public String getBmp() {
        return this.bmp;
    }

    public int getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(int colorDepth) {
        this.colorDepth = colorDepth;
        this.textFile.setDirty(true);
    }

    public boolean isColorScale() {
        return this.colorScale;
    }

    public void setColorScale(boolean colorScale) {
        this.colorScale = colorScale;
        this.textFile.setDirty(true);
    }

    public String getMask() {
        return this.mask;
    }

    public int getMaskDepth() {
        return this.maskDepth;
    }

    public void setMaskDepth(int maskDepth) {
        this.maskDepth = maskDepth;
        this.textFile.setDirty(true);
    }

    public TextFile getTextFile() {
        return this.textFile;
    }

    public void setTextFile(TextFile textFile) {
        this.textFile = textFile;
        textFile.setDirty(true);
    }

    public String toString() {
        return String.valueOf(this.colorScale ? "c" : "") + this.colorDepth + (this.maskDepth > 0 ? "," + this.maskDepth : "") + DELIMITER + this.bmp + (this.maskDepth > 0 ? DELIMITER + this.mask : "");
    }
}

