/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui.editors;

import com.symbian.cdt.project.ProjectPlugin;
import com.symbian.cdt.project.ui.editors.AddBMPWithoutMaskDialog;
import com.symbian.cdt.project.ui.editors.AddBMPsDialog;
import com.symbian.cdt.project.ui.editors.Line;
import com.symbian.cdt.project.ui.editors.TextFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBMDefEditor
extends EditorPart
implements IResourceChangeListener,
ISelectionChangedListener {
    static final String COLOR_SCALE = "Color Scale";
    static final String COLOR_DEPTH = "Color Depth";
    static final String MASK_DEPTH = "Mask Depth";
    static final String BITMAP = "Bitmap";
    static final String MASK = "Mask";
    static final String[] DEPTH_ITEMS = new String[]{"2", "4", "8"};
    static final String[] COLOR_SCALE_ITEMS = new String[]{"Yes", "No"};
    private static final Map<String, Integer> DEPTH_ITEMS_MAP = new HashMap<String, Integer>(3);
    private static final String SAVE = "org.eclipse.ui.file.save";
    private static final String[] COLUMN_PROPERTIES;
    private TableViewer tv;
    private Button up;
    private Button down;
    private Button remove;
    private Button addBMP;
    private Button addMask;
    private TextFile inputFile;
    private Action action;

    static {
        int i = 0;
        while (i < DEPTH_ITEMS.length) {
            DEPTH_ITEMS_MAP.put(DEPTH_ITEMS[i], i);
            ++i;
        }
        COLUMN_PROPERTIES = new String[]{COLOR_SCALE, COLOR_DEPTH, MASK_DEPTH, BITMAP, MASK};
    }

    public MBMDefEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void createFormPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        composite.setLayout((Layout)layout);
        Label pageLabel = new Label(composite, 0);
        pageLabel.setText("Bitmaps");
        Composite subComposite = new Composite(composite, 0);
        GridLayout subLayout = new GridLayout(2, false);
        GridData gridData = new GridData(1808);
        subComposite.setLayout((Layout)subLayout);
        subComposite.setLayoutData((Object)gridData);
        this.createTable(subComposite);
        this.createButtonArea(subComposite);
    }

    private void createTable(Composite aComposite) {
        this.tv = new TableViewer(aComposite, 67586);
        this.tv.setUseHashlookup(true);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((TextFile)inputElement).getLines();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new NameProvider());
        Table table = this.tv.getTable();
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc = new TableColumn(table, 0x1000000, 0);
        tc.setText(COLOR_SCALE);
        tc = new TableColumn(table, 131072);
        tc.setText(COLOR_DEPTH);
        tc = new TableColumn(table, 131072);
        tc.setText(MASK_DEPTH);
        tc = new TableColumn(table, 16384);
        tc.setText(BITMAP);
        tc = new TableColumn(table, 16384);
        tc.setText(MASK);
        int i = 0;
        int n = table.getColumnCount();
        while (i < n) {
            table.getColumn(i).pack();
            ++i;
        }
        table.getColumn(3).setWidth(150);
        table.getColumn(4).setWidth(150);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tv.setColumnProperties(COLUMN_PROPERTIES);
        this.tv.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tv.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MBMDefEditor.this.updateInputFile();
            }
        });
        ComboBoxCellEditor checkEditor = new ComboBoxCellEditor((Composite)table, COLOR_SCALE_ITEMS, 8);
        ComboBoxCellEditor comboEditor = new ComboBoxCellEditor((Composite)table, DEPTH_ITEMS, 8);
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[0] = checkEditor;
        cellEditorArray[1] = comboEditor;
        cellEditorArray[2] = comboEditor;
        this.tv.setCellEditors(cellEditorArray);
        this.tv.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals(MBMDefEditor.COLOR_SCALE) || property.equals(MBMDefEditor.COLOR_DEPTH) || property.equals(MBMDefEditor.MASK_DEPTH) && this.getValue(element, property) != null;
            }

            public Object getValue(Object element, String property) {
                Line line = (Line)element;
                if (MBMDefEditor.COLOR_SCALE.equals(property)) {
                    return line.isColorScale() ? 0 : 1;
                }
                if (MBMDefEditor.COLOR_DEPTH.equals(property)) {
                    return DEPTH_ITEMS_MAP.get("" + line.getColorDepth());
                }
                if (MBMDefEditor.MASK_DEPTH.equals(property)) {
                    return DEPTH_ITEMS_MAP.get("" + line.getMaskDepth());
                }
                if (MBMDefEditor.BITMAP.equals(property)) {
                    return line.getBmp();
                }
                if (MBMDefEditor.MASK.equals(property)) {
                    return line.getMask();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                Line line = (Line)element;
                if (MBMDefEditor.COLOR_SCALE.equals(property)) {
                    line.setColorScale((Integer)value == 0);
                } else if (MBMDefEditor.COLOR_DEPTH.equals(property)) {
                    line.setColorDepth(Integer.parseInt(DEPTH_ITEMS[(Integer)value]));
                } else if (MBMDefEditor.MASK_DEPTH.equals(property)) {
                    line.setMaskDepth(Integer.parseInt(DEPTH_ITEMS[(Integer)value]));
                }
                MBMDefEditor.this.tv.refresh();
            }
        });
    }

    private void createButtonArea(Composite container) {
        Composite composite = new Composite(container, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        composite.setLayoutData((Object)gridData);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (e.getSource().equals(MBMDefEditor.this.addBMP)) {
                        AddBMPWithoutMaskDialog dialog = new AddBMPWithoutMaskDialog(MBMDefEditor.this.getSite().getShell(), MBMDefEditor.this);
                        int state = dialog.open();
                        if (state == 0) {
                            Line[] lineArray = dialog.getLines();
                            int n = 0;
                            int n2 = lineArray.length;
                            while (n < n2) {
                                Line line = lineArray[n];
                                MBMDefEditor.this.inputFile.addLine(line);
                                ++n;
                            }
                        }
                    } else if (e.getSource().equals(MBMDefEditor.this.addMask)) {
                        AddBMPsDialog dialog = new AddBMPsDialog(MBMDefEditor.this.getSite().getShell(), MBMDefEditor.this);
                        int state = dialog.open();
                        if (state == 0) {
                            MBMDefEditor.this.inputFile.addLine(dialog.getLine());
                        }
                    } else if (e.getSource().equals(MBMDefEditor.this.remove)) {
                        Iterator iter = ((IStructuredSelection)MBMDefEditor.this.tv.getSelection()).iterator();
                        while (iter.hasNext()) {
                            MBMDefEditor.this.inputFile.removeLine((Line)iter.next());
                        }
                    } else if (e.getSource().equals(MBMDefEditor.this.up)) {
                        IStructuredSelection sel = (IStructuredSelection)MBMDefEditor.this.tv.getSelection();
                        int start = MBMDefEditor.this.inputFile.indexOf((Line)sel.getFirstElement());
                        MBMDefEditor.this.inputFile.move(start, start + sel.size(), true);
                    } else if (e.getSource().equals(MBMDefEditor.this.down)) {
                        IStructuredSelection sel = (IStructuredSelection)MBMDefEditor.this.tv.getSelection();
                        int start = MBMDefEditor.this.inputFile.indexOf((Line)sel.getFirstElement());
                        MBMDefEditor.this.inputFile.move(start, start + sel.size(), false);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                MBMDefEditor.this.tv.refresh();
                MBMDefEditor.this.updateButtons();
            }
        };
        this.addBMP = new Button(composite, 8);
        this.addBMP.setText("Add BMPs &Without Mask");
        this.addBMP.setToolTipText("Add BMPs Without Mask");
        this.addBMP.addSelectionListener((SelectionListener)listener);
        this.addMask = new Button(composite, 8);
        this.addMask.setText("Add BMP With &Mask");
        this.addMask.setToolTipText("Add BMP With Mask");
        this.addMask.addSelectionListener((SelectionListener)listener);
        this.up = new Button(composite, 8);
        this.up.setText("&Up");
        this.up.setEnabled(false);
        this.up.setToolTipText("Up");
        this.up.addSelectionListener((SelectionListener)listener);
        this.down = new Button(composite, 8);
        this.down.setText("&Down");
        this.down.setEnabled(false);
        this.down.setToolTipText("Down");
        this.down.addSelectionListener((SelectionListener)listener);
        this.remove = new Button(composite, 8);
        this.remove.setText("&Remove");
        this.remove.setEnabled(false);
        this.remove.setToolTipText("Remove");
        this.remove.addSelectionListener((SelectionListener)listener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        block7: {
            try {
                this.saveFile((IFileEditorInput)this.getEditorInput(), monitor);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status != null && status.getSeverity() == 8) break block7;
                String title = "Save As";
                String msg = "Error while saving: " + e.getMessage();
                Shell shell = this.getSite().getShell();
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                }
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        }
    }

    private void saveFile(IFileEditorInput input, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IFile file = input.getFile();
        byte[] bytes = this.inputFile.toString().getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        if (file.exists()) {
            file.setContents((InputStream)stream, false, true, monitor);
        } else {
            try {
                ContainerCreator creator = new ContainerCreator(file.getWorkspace(), file.getParent().getFullPath());
                creator.createContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                file.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            finally {
                monitor.done();
            }
        }
        this.inputFile.setDirty(false);
    }

    public void doSaveAs() {
        block14: {
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile original = ((IFileEditorInput)input).getFile();
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            if (dialog.open() == 1) {
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            boolean success = false;
            try {
                try {
                    this.saveFile((IFileEditorInput)newInput, null);
                    success = true;
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status != null && status.getSeverity() == 8) break block14;
                    String title = "Save As";
                    String msg = "Error while saving: " + e.getMessage();
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block14;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            finally {
                if (success) {
                    this.setPartName(newInput.getName());
                    this.setInput((IEditorInput)newInput);
                }
            }
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.internalInit(site.getWorkbenchWindow(), site, editorInput);
    }

    protected final void internalInit(IWorkbenchWindow window, IEditorSite site, final IEditorInput input) throws PartInitException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    MBMDefEditor.this.doSetInput(input);
                }
                catch (CoreException x) {
                    throw new InvocationTargetException(x);
                }
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(false, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof CoreException) {
                CoreException e = (CoreException)t;
                IStatus status = e.getStatus();
                if (status.getException() != null) {
                    throw new PartInitException(status);
                }
                throw new PartInitException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), t));
            }
            throw new PartInitException((IStatus)new Status(4, ProjectPlugin.getUniqueId(), 0, "Error initializing the editor", t));
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            super.setInput(input);
            this.updateInputFile();
            this.setPartName(input.getName());
        }
    }

    private void updateInputFile() {
        try {
            if (this.inputFile == null) {
                this.inputFile = new TextFile(((IFileEditorInput)this.getEditorInput()).getStorage().getContents(), this);
            }
            if (this.tv != null) {
                this.tv.setInput((Object)this.inputFile);
                this.tv.refresh();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                MBMDefEditor.this.getSite().getPage().closeEditor((IEditorPart)MBMDefEditor.this, save);
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = MBMDefEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = 0;
                    int n2 = iWorkbenchPageArray.length;
                    while (n < n2) {
                        IWorkbenchPage page = iWorkbenchPageArray[n];
                        if (((FileEditorInput)MBMDefEditor.this.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = page.findEditor(MBMDefEditor.this.getEditorInput());
                            page.closeEditor(editorPart, true);
                        }
                        ++n;
                    }
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        int size = this.inputFile.getLines().length;
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        int selSize = sel.size();
        int start = selSize > 0 ? this.inputFile.indexOf((Line)sel.getFirstElement()) : -1;
        this.remove.setEnabled(selSize > 0);
        this.up.setEnabled(start > 0);
        this.down.setEnabled(selSize > 0 && start + selSize < size);
    }

    public SortedSet<String> getAllUnusedBMPs() {
        final TreeSet<String> all = new TreeSet<String>();
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        IProject project = input.getFile().getProject();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        String extn = file.getFileExtension();
                        if (extn != null && extn.equalsIgnoreCase("bmp")) {
                            all.add(file.getProjectRelativePath().toPortableString());
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        all.removeAll(this.inputFile.getAllUsedBMPs());
        return all;
    }

    public boolean isDirty() {
        return this.inputFile.isDirty();
    }

    public void createPartControl(Composite parent) {
        this.createFormPage(parent);
        this.action = new Action(){

            public void run() {
                MBMDefEditor.this.getSite().getPage().saveEditor((IEditorPart)MBMDefEditor.this, false);
            }
        };
        this.action.setActionDefinitionId(SAVE);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.action);
    }

    public void setFocus() {
        if (this.tv != null) {
            this.tv.getTable().setFocus();
        }
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(257);
        if (this.action != null) {
            this.action.setEnabled(this.isDirty());
        }
    }

    private static class NameProvider
    extends LabelProvider
    implements ITableLabelProvider {
        NameProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Line) {
                Line line = (Line)obj;
                switch (index) {
                    case 0: {
                        return line.isColorScale() ? COLOR_SCALE_ITEMS[0] : COLOR_SCALE_ITEMS[1];
                    }
                    case 1: {
                        return "" + line.getColorDepth();
                    }
                    case 2: {
                        return line.getMaskDepth() > 0 ? "" + line.getMaskDepth() : null;
                    }
                    case 3: {
                        return line.getBmp();
                    }
                    case 4: {
                        return line.getMask();
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

