/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.project.ui.editors;

import com.symbian.cdt.project.ui.editors.Line;
import com.symbian.cdt.project.ui.editors.MBMDefEditor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class TextFile {
    private List<Line> lines = new ArrayList<Line>();
    private Set<String> allUsedBMPs = new HashSet<String>();
    private boolean dirty;
    private MBMDefEditor editor;

    TextFile(InputStream in, MBMDefEditor editor) throws IOException {
        this.readDocument(in);
        this.editor = editor;
    }

    private void readDocument(InputStream in) throws IOException {
        String s;
        this.lines.clear();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((s = br.readLine()) != null) {
            Line line = new Line(s, this);
            this.lines.add(line);
            this.allUsedBMPs.add(line.getBmp());
            if (line.getMask() == null || line.getMask().equals("")) continue;
            this.allUsedBMPs.add(line.getMask());
        }
    }

    Line[] getLines() {
        return this.lines.toArray(new Line[this.lines.size()]);
    }

    Line getLine(int index) {
        return this.lines.get(index);
    }

    void updateLine(int index, Line line) {
        Line oldLine = this.lines.set(index, line);
        if (oldLine != null) {
            this.allUsedBMPs.remove(oldLine.getBmp());
            if (oldLine.getMask() != null && !oldLine.getMask().equals("")) {
                this.allUsedBMPs.remove(oldLine.getMask());
            }
        }
        this.allUsedBMPs.add(line.getBmp());
        if (line.getMask() != null && !line.getMask().equals("")) {
            this.allUsedBMPs.add(line.getMask());
        }
        this.setDirty(true);
    }

    void removeLine(Line line) {
        if (this.lines.isEmpty()) {
            return;
        }
        int i = this.lines.indexOf(line);
        if (i == -1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.allUsedBMPs.remove(line.getBmp());
        if (line.getMask() != null && !line.getMask().equals("")) {
            this.allUsedBMPs.remove(line.getMask());
        }
        this.lines.remove(i);
        this.setDirty(true);
    }

    void move(int start, int end, boolean up) {
        if (this.lines.isEmpty()) {
            return;
        }
        if (start > end || start < 0 || end > this.lines.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (start == 0 && up || end == this.lines.size() && !up) {
            return;
        }
        if (up) {
            int i = start - 1;
            Line line = this.lines.remove(i);
            i = end - 1;
            this.lines.add(i, line);
        } else {
            int i = end;
            Line line = this.lines.remove(i);
            i = start;
            this.lines.add(i, line);
        }
        this.setDirty(true);
    }

    void addLine(Line line) {
        this.allUsedBMPs.add(line.getBmp());
        if (line.getMask() != null && !line.getMask().equals("")) {
            this.allUsedBMPs.add(line.getMask());
        }
        line.setTextFile(this);
        this.lines.add(line);
        this.setDirty(true);
    }

    Set getAllUsedBMPs() {
        return this.allUsedBMPs;
    }

    int indexOf(Line line) {
        return this.lines.indexOf(line);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Line line : this.lines) {
            b.append(line.toString()).append('\n');
        }
        return b.toString();
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editor.firePropertyChange(257);
    }
}

