/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class AifCommandLineGenerator
implements IManagedCommandLineGenerator {
    static final String EMPTY_STRING = "";
    static final String WHITESPACE = " ";
    static final String GLOBAL_SYSTEM_INCLUDE_PATHS = "GLOBAL_SYSTEM_INCLUDE_PATHS";
    static final String GLOBAL_USER_INCLUDE_PATHS = "GLOBAL_USER_INCLUDE_PATHS";
    static final String INCLUDE_COMMAND = "-I";
    static final String INCLUDE_EXPLICIT_COMMAND = "-I-";
    static final String EPOCROOT = "EPOCROOT";
    static final String TARGETPATH_COMMAND = "-targetPath";
    static final String Z_FOLDER = "Z";
    static final String EPOC32 = "EPOC32";
    static final String DATA = "DATA";
    private String EPOC32_DATA_DIR = "";
    private String targetPath = "";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        this.setEpoc32DataDir(tool);
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + WHITESPACE);
        try {
            commandLine.append(String.valueOf(this.includeGlobalIncludesInCommandLine(this.getConfigurationFromTool(tool), flags)) + WHITESPACE);
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        commandLine.append(outputFlag.trim());
        commandLine.append(outputPrefix.trim());
        commandLine.append(String.valueOf(this.fullOutputName(outputName).trim()) + WHITESPACE);
        commandLine.append(this.stringArrayToString(inputResources));
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + WHITESPACE);
            ++n;
        }
        return sb.toString().trim();
    }

    private String includeGlobalIncludesInCommandLine(IConfiguration configuration, String[] flags) throws BuildMacroException {
        StringBuffer cmdLineFlags = new StringBuffer();
        String[] stringArray = flags;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String flag = stringArray[n];
            if (flag.compareToIgnoreCase(INCLUDE_EXPLICIT_COMMAND) == 0) {
                String userIncludePath = new String(EMPTY_STRING);
                String[] stringArray2 = ManagedBuildManager.getBuildMacroProvider().getMacro(GLOBAL_USER_INCLUDE_PATHS, 3, (Object)configuration, true).getStringValue().split(WHITESPACE);
                int n3 = 0;
                int n4 = stringArray2.length;
                while (n3 < n4) {
                    String path = stringArray2[n3];
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, EMPTY_STRING, WHITESPACE, 3, (Object)configuration);
                    if ((resolved = resolved.trim()).length() > 0) {
                        path = resolved;
                    }
                    userIncludePath = String.valueOf(userIncludePath) + INCLUDE_COMMAND + path + WHITESPACE;
                    ++n3;
                }
                cmdLineFlags.append(userIncludePath);
                cmdLineFlags.append("-I- ");
                String systemIncludePath = new String();
                String[] stringArray3 = ManagedBuildManager.getBuildMacroProvider().getMacro(GLOBAL_SYSTEM_INCLUDE_PATHS, 3, (Object)configuration, true).getStringValue().split(WHITESPACE);
                n4 = 0;
                int n5 = stringArray3.length;
                while (n4 < n5) {
                    String path = stringArray3[n4];
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, EMPTY_STRING, WHITESPACE, 3, (Object)configuration);
                    if ((resolved = resolved.trim()).length() > 0) {
                        path = resolved;
                    }
                    systemIncludePath = String.valueOf(systemIncludePath) + INCLUDE_COMMAND + path + WHITESPACE;
                    ++n4;
                }
                cmdLineFlags.append(systemIncludePath);
            } else if (flag.startsWith(TARGETPATH_COMMAND)) {
                this.targetPath = flag.replace(TARGETPATH_COMMAND, EMPTY_STRING);
            } else {
                cmdLineFlags.append(String.valueOf(flag) + WHITESPACE);
            }
            ++n;
        }
        return cmdLineFlags.toString().trim();
    }

    private IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    private String fullOutputName(String outputName) {
        if (this.targetPath.equals(EMPTY_STRING)) {
            return "\"" + this.EPOC32_DATA_DIR + "${notdir " + outputName + "}\"";
        }
        return "\"" + this.EPOC32_DATA_DIR + Z_FOLDER + File.separator + this.targetPath + File.separator + "${notdir " + outputName + "}\"";
    }

    private void setEpoc32DataDir(ITool tool) {
        try {
            this.EPOC32_DATA_DIR = String.valueOf(ManagedBuildManager.getBuildMacroProvider().getMacro(EPOCROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue()) + EPOC32 + File.separator + DATA + File.separator;
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
    }
}

