/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import com.symbian.cdt.build.SymbianMakefileGenerator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.BitSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EKA1WINSCWMakeFileGenerator
extends SymbianMakefileGenerator {
    protected static final String GENERATED_FOLDER = ".generated";
    protected static final String UID_FILE = "/winscw_uid.cpp";
    protected static final String UID_AUTO_HEADER = "//Auto-generated file. Please do not modify.\n";
    protected static final String PKG_AUTO_HEADER = ";Auto-generated file. Please do not modify.\n";
    private static final String UID_HEADER = "#include <e32std.h>\n#pragma data_seg(\".E32_UID\")\n__WINS_UID (\n";

    protected IPath checkAndCreateBuildDirectory(IManagedBuildInfo info) throws CoreException {
        IPath retVal = super.checkAndCreateBuildDirectory(info);
        IConfiguration config = info.getSelectedConfiguration();
        if (config == null) {
            config = info.getDefaultConfiguration();
        }
        this.checkAndCreateUIDFile(config);
        this.checkAndCreatePkgFile(config);
        return retVal;
    }

    private void checkAndCreateUIDFile(IConfiguration config) throws CoreException {
        String projectTypeId = config.getManagedProject().getProjectType().getId();
        if (projectTypeId.contains("lib")) {
            return;
        }
        IFile uidFile = this.project.getFile(".generated/winscw_uid.cpp");
        if (!uidFile.getParent().exists()) {
            this.createDirectory(GENERATED_FOLDER);
        }
        this.createUIDCPPFile(config, uidFile);
    }

    private void createUIDCPPFile(IConfiguration config, IFile uidFile) throws CoreException {
        StringBuffer buffer = this.makeUIDContentsBuffer(config);
        try {
            this.writeFileIfNeeded(config, uidFile, buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected StringBuffer makeUIDContentsBuffer(IConfiguration config) {
        StringBuffer buffer = new StringBuffer(UID_AUTO_HEADER).append(UID_HEADER);
        IToolChain toolChain = config.getToolChain();
        try {
            IOption option;
            IOption[] iOptionArray = toolChain.getOptions();
            int n = 0;
            int n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().equals("-uid1")) {
                    buffer.append(option.getStringValue()).append(',');
                    break;
                }
                ++n;
            }
            iOptionArray = toolChain.getOptions();
            n = 0;
            n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().equals("-uid2")) {
                    buffer.append(option.getStringValue()).append(',');
                    break;
                }
                ++n;
            }
            String uid3 = "0x00000000";
            IOption[] iOptionArray2 = toolChain.getOptions();
            n2 = 0;
            int n3 = iOptionArray2.length;
            while (n2 < n3) {
                IOption option2 = iOptionArray2[n2];
                if (option2.isValid() && option2.getCommand().toLowerCase().equals("-uid3")) {
                    String val = option2.getStringValue();
                    if (val != null && !val.trim().equals("")) {
                        uid3 = val;
                    }
                    buffer.append(uid3);
                    break;
                }
                ++n2;
            }
            buffer.append("\n)\n#pragma data_seg()\n");
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    private void writeFileIfNeeded(IConfiguration config, IFile oldFile, StringBuffer buffer) throws CoreException, IOException {
        boolean modified = true;
        if (oldFile.exists()) {
            InputStream contents = null;
            try {
                String s;
                contents = oldFile.getContents(true);
                BufferedReader br = new BufferedReader(new InputStreamReader(contents));
                StringBuffer sb = new StringBuffer();
                while ((s = br.readLine()) != null) {
                    sb.append(s).append("\n");
                }
                if (sb.equals(buffer)) {
                    modified = false;
                }
            }
            finally {
                if (contents != null) {
                    contents.close();
                }
            }
        }
        if (modified) {
            IProject project = (IProject)config.getOwner();
            IFile file = this.createFile(oldFile.getFullPath());
            Util.save((StringBuffer)buffer, (IFile)file);
            project.refreshLocal(2, null);
        }
    }

    private IFile createFile(IPath path) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(path);
        if (newFile == null) {
            newFile = root.getFile(path);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    public boolean isGeneratedResource(IResource resource) {
        String folderPath = GENERATED_FOLDER;
        String uidFilePath = String.valueOf(folderPath) + UID_FILE;
        String pkgFilePath = null;
        try {
            pkgFilePath = String.valueOf(folderPath) + "/" + this.getMacroValue(this.config, "BuildArtifactFileBaseName") + "." + "pkg";
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        if (resource.getProjectRelativePath().equals((Object)this.project.getFile(folderPath).getProjectRelativePath()) || resource.getProjectRelativePath().equals((Object)this.project.getFile(uidFilePath).getProjectRelativePath()) || pkgFilePath != null && resource.getProjectRelativePath().equals((Object)this.project.getFile(pkgFilePath).getProjectRelativePath())) {
            return false;
        }
        return super.isGeneratedResource(resource);
    }

    protected void checkAndCreatePkgFile(IConfiguration config) throws CoreException {
        String projectTypeId = config.getManagedProject().getProjectType().getId();
        if (projectTypeId.contains("lib")) {
            return;
        }
        String pkgFileName = String.valueOf(this.getMacroValue(config, "BuildArtifactFileBaseName")) + "." + "pkg";
        final IFile pkgFile = this.project.getFile(".generated/" + pkgFileName);
        final BitSet s = new BitSet(1);
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (s.get(0)) {
                        return false;
                    }
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        String extn = file.getFileExtension();
                        if (extn != null && extn.toLowerCase().equals("pkg") && !file.equals((Object)pkgFile)) {
                            s.set(0);
                            if (pkgFile.exists()) {
                                pkgFile.delete(1, (IProgressMonitor)new NullProgressMonitor());
                                pkgFile.refreshLocal(1, null);
                                EKA1WINSCWMakeFileGenerator.this.project.refreshLocal(2, null);
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!s.get(0)) {
            if (!pkgFile.getParent().exists()) {
                this.createDirectory(GENERATED_FOLDER);
            }
            this.createPkgFile(config, pkgFile);
        }
    }

    protected String getMacroValue(IConfiguration config, String macroName) throws BuildMacroException {
        return ManagedBuildManager.getBuildMacroProvider().getMacro(macroName, 3, (Object)config, true).getStringValue();
    }

    private void createPkgFile(IConfiguration config, IFile pkgFile) {
        StringBuffer buffer = this.makePkgContentsBuffer(config);
        try {
            this.writeFileIfNeeded(config, pkgFile, buffer);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private StringBuffer makePkgContentsBuffer(IConfiguration config) {
        StringBuffer buffer = new StringBuffer(PKG_AUTO_HEADER).append("\n");
        buffer.append(";Languages\n&EN\n\n#{\"");
        buffer.append(config.getOwner().getName()).append("\"},(");
        IToolChain toolChain = config.getToolChain();
        try {
            IOption option;
            IOption[] iOptionArray = toolChain.getOptions();
            int n = 0;
            int n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().equals("-uid2")) {
                    buffer.append(option.getStringValue()).append("),");
                    break;
                }
                ++n;
            }
            iOptionArray = toolChain.getOptions();
            n = 0;
            n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().equals("-version")) {
                    buffer.append(option.getStringValue()).append("\n\n");
                    break;
                }
                ++n;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        buffer.append("%{\"Symbian\"}\n\n:\"Symbian\"\n\n");
        try {
            buffer.append(this.getOutputFilePath(config)).append("-");
            buffer.append("\"c:\\sys\\bin\\").append(this.getOutputFileName(config)).append("\"\n");
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    protected String getOutputFilePath(IConfiguration config) throws BuildMacroException {
        String dir = config.getId().toUpperCase().contains("UDEB") ? "UDEB" : "UREL";
        String filePath = "\"" + this.getMacroValue(config, "EPOC32_RELEASE_ROOT");
        filePath = String.valueOf(filePath) + File.separator + "WINSCW" + File.separator + dir + File.separator;
        filePath = String.valueOf(filePath) + this.getOutputFileName(config) + "\"";
        return filePath;
    }

    private String getOutputFileName(IConfiguration config) throws BuildMacroException {
        return String.valueOf(this.getMacroValue(config, "BuildArtifactFileBaseName")) + "." + this.getMacroValue(config, "BuildArtifactFileExt");
    }
}

