/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.runtime.Path;

public class GCC98LinkerCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String WHITESPACE = " ";
    public final String EMPTY_STRING = "";
    public final String BASE_FILE_COMMAND = "--base-file";
    public final String WHOLE_ARCHIVE_COMMAND = "--whole-archive";
    public final String NO_WHOLE_ARCHIVE_COMMAND = "--no-whole-archive";
    public final String BASE_FILE_EXTENSION = ".bas";
    public final String IN_FILE_EXTENSION = ".in";
    public static final String MAP_COMMAND = "-Map";
    public static final String MAP_FILE_EXT = ".map";
    public static final String EPOC32_RELEASE_ROOT = "EPOC32_RELEASE_ROOT";
    public static final String ARM4 = "ARM4";
    public static final String UDEB = "UDEB";
    public static final String UREL = "UREL";
    public static final String DLL = "DLL";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + " ");
        commandLine.append(String.valueOf(this.stringArrayToString(flags)) + " ");
        commandLine.append(String.valueOf(this.baseFileCommand(outputName)) + " ");
        commandLine.append(String.valueOf(this.mapCommand(tool, outputName)) + " ");
        commandLine.append(String.valueOf(outputFlag.trim()) + " ");
        commandLine.append(outputPrefix.trim());
        commandLine.append("\"" + this.getFullOutputName(tool, outputName.trim()) + "\"" + " ");
        commandLine.append(this.addAdditionalFlagsAroundInObjs(inputResources));
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + " ");
            ++n;
        }
        return sb.toString().trim();
    }

    private String baseFileCommand(String outputName) {
        return "--base-file " + Path.fromOSString((String)outputName).removeFileExtension().toOSString() + ".bas";
    }

    private String mapCommand(ITool tool, String outputName) {
        String dir = this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB) ? UDEB : UREL;
        return "-Map " + this.getEpocReleaseRoot(tool) + File.separator + ARM4 + File.separator + dir + File.separator + outputName + MAP_FILE_EXT;
    }

    private String addAdditionalFlagsAroundInObjs(String[] inputResources) {
        if (inputResources.length <= 0) {
            return "";
        }
        String inputObjs = "--whole-archive ";
        inputObjs = String.valueOf(inputObjs) + inputResources[0] + " ";
        inputObjs = String.valueOf(inputObjs) + "--no-whole-archive ";
        int i = 1;
        while (i < inputResources.length) {
            inputObjs = String.valueOf(inputObjs) + inputResources[i] + " ";
            ++i;
        }
        return inputObjs.trim();
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    protected String getFullOutputName(ITool tool, String outputName) {
        if (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB)) {
            return String.valueOf(this.getEpocReleaseRoot(tool)) + File.separator + ARM4 + File.separator + UDEB + File.separator + outputName;
        }
        return outputName;
    }

    private String getEpocReleaseRoot(ITool tool) {
        String releaseRoot = new String("");
        try {
            releaseRoot = ManagedBuildManager.getBuildMacroProvider().getMacro(EPOC32_RELEASE_ROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return releaseRoot;
    }
}

