/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class GCCECompilerCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String WHITESPACE = " ";
    public final String GLOBAL_SYSTEM_INCLUDE_PATHS = "GLOBAL_SYSTEM_INCLUDE_PATHS";
    public final String GLOBAL_USER_INCLUDE_PATHS = "GLOBAL_USER_INCLUDE_PATHS";
    public final String INCLUDE_COMMAND = "-I";
    public final String FILE_INCLUDE_COMMAND = "-include";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        IConfiguration config = this.getConfigurationFromTool(tool);
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + " ");
        try {
            commandLine.append(String.valueOf(this.includeGlobalIncludesInCommandLine(config, flags)) + " ");
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        commandLine.append(String.valueOf(outputFlag.trim()) + " ");
        commandLine.append(outputPrefix.trim());
        commandLine.append(String.valueOf(outputName.trim()) + " ");
        commandLine.append(this.stringArrayToString(inputResources));
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + " ");
            ++n;
        }
        return sb.toString().trim();
    }

    private String includeGlobalIncludesInCommandLine(IConfiguration configuration, String[] flags) throws BuildMacroException {
        StringBuffer cmdLineFlags = new StringBuffer();
        boolean globalFlagsIncluded = false;
        String[] stringArray = flags;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String flag = stringArray[n];
            if (!globalFlagsIncluded && flag.startsWith("-I")) {
                cmdLineFlags.append(this.globalIncludePaths(configuration));
                globalFlagsIncluded = true;
            } else if (flag.startsWith("-include")) {
                flag = flag.replace("-include", "-include ");
            }
            cmdLineFlags.append(String.valueOf(flag) + " ");
            ++n;
        }
        if (!globalFlagsIncluded) {
            cmdLineFlags.append(this.globalIncludePaths(configuration));
        }
        return cmdLineFlags.toString().trim();
    }

    private IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    private String globalIncludePaths(IConfiguration configuration) throws BuildMacroException {
        String resolved;
        String path;
        String includePath = new String();
        String[] stringArray = ManagedBuildManager.getBuildMacroProvider().getMacro("GLOBAL_USER_INCLUDE_PATHS", 3, (Object)configuration, true).getStringValue().split(" ");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            path = stringArray[n];
            resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, "", " ", 3, (Object)configuration);
            if ((resolved = resolved.trim()).length() > 0) {
                path = resolved;
            }
            includePath = String.valueOf(includePath) + "-I " + path + " ";
            ++n;
        }
        stringArray = ManagedBuildManager.getBuildMacroProvider().getMacro("GLOBAL_SYSTEM_INCLUDE_PATHS", 3, (Object)configuration, true).getStringValue().split(" ");
        n = 0;
        n2 = stringArray.length;
        while (n < n2) {
            path = stringArray[n];
            resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, "", " ", 3, (Object)configuration);
            if ((resolved = resolved.trim()).length() > 0) {
                path = resolved;
            }
            includePath = String.valueOf(includePath) + "-I " + path + " ";
            ++n;
        }
        return includePath;
    }
}

