/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class GCCELinkerCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String WHITESPACE = " ";
    public final String EMPTY_STRING = "";
    public static final String EPOC32_RELEASE_ROOT = "EPOC32_RELEASE_ROOT";
    public static final String GCCE = "GCCE";
    public static final String UDEB = "UDEB";
    public static final String UREL = "UREL";
    public static final String SONAME_COMMAND = "-soname";
    public static final String LINKAS_NUMBER = "000a0000";
    public static final String MAP_COMMAND = "-Map";
    public static final String MAP_FILE_EXT = ".map";
    public static final String EXTRA_LIBS = "-lsupc++ -lgcc ";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + " ");
        commandLine.append(String.valueOf(this.fixFlags(tool, flags)) + " ");
        commandLine.append(String.valueOf(this.createSonameCommand(tool, outputName)) + " ");
        commandLine.append(String.valueOf(outputFlag.trim()) + " ");
        commandLine.append(outputPrefix.trim());
        commandLine.append("\"" + this.getFullOutputName(tool, outputName.trim()) + "\"" + " ");
        commandLine.append(String.valueOf(this.mapCommand(tool, outputName)) + " ");
        commandLine.append(String.valueOf(this.addAdditionalFlagsAroundInObjs(inputResources)) + " ");
        commandLine.append("-lsupc++ -lgcc  ");
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + " ");
            ++n;
        }
        return sb.toString().trim();
    }

    private String createSonameCommand(ITool tool, String outputName) {
        String soName = "";
        String secureid = "";
        String uid3 = "";
        try {
            IOption[] iOptionArray = this.getConfigurationFromTool(tool).getToolChain().getOptions();
            int n = 0;
            int n2 = iOptionArray.length;
            while (n < n2) {
                IOption option = iOptionArray[n];
                String command = "";
                if (option.isValid()) {
                    command = option.getCommand().toLowerCase();
                }
                if (command != null) {
                    if (command.equals("-secureid")) {
                        secureid = option.getStringValue();
                    } else if (command.equals("-uid3")) {
                        uid3 = option.getStringValue();
                    }
                }
                ++n;
            }
            if (!secureid.equals("")) {
                soName = secureid;
            } else if (!uid3.equals("")) {
                soName = uid3;
            }
            if (soName.startsWith("0x") || soName.startsWith("0X")) {
                soName = soName.substring(2);
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        String linkAsName = "-soname ${basename ${notdir " + outputName + "}}" + "{" + LINKAS_NUMBER + "}[" + soName + "]." + this.getTargetType(tool);
        return linkAsName;
    }

    protected String getTargetType(ITool tool) {
        IConfiguration config = this.getConfigurationFromTool(tool);
        String targetType = config.getArtifactExtension();
        return targetType;
    }

    protected String fixFlags(ITool tool, String[] flags) {
        String stringOptions = String.valueOf(this.stringArrayToString(flags)) + " ";
        try {
            IOption[] iOptionArray = tool.getOptions();
            int n = 0;
            int n2 = iOptionArray.length;
            while (n < n2) {
                IOption option = iOptionArray[n];
                if (option.getValueType() == 2) {
                    String target = option.getCommand();
                    stringOptions = stringOptions.replace(target, String.valueOf(target) + " ");
                }
                ++n;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return stringOptions;
    }

    private String addAdditionalFlagsAroundInObjs(String[] inputResources) {
        String inputObjs = "";
        int i = 0;
        while (i < inputResources.length) {
            inputObjs = String.valueOf(inputObjs) + inputResources[i] + " ";
            ++i;
        }
        return inputObjs.trim();
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    protected String getFullOutputName(ITool tool, String outputName) {
        String releaseRoot = new String("");
        try {
            releaseRoot = ManagedBuildManager.getBuildMacroProvider().getMacro(EPOC32_RELEASE_ROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        if (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB)) {
            return String.valueOf(releaseRoot) + File.separator + GCCE + File.separator + UDEB + File.separator + outputName;
        }
        return outputName;
    }

    private String mapCommand(ITool tool, String outputName) {
        String command = "";
        command = String.valueOf(command) + "-Map " + this.getEpocReleaseRoot(tool) + File.separator + GCCE + File.separator;
        command = String.valueOf(command) + (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB) ? UDEB : UREL);
        command = String.valueOf(command) + File.separator + outputName + MAP_FILE_EXT;
        return command;
    }

    private String getEpocReleaseRoot(ITool tool) {
        String releaseRoot = new String("");
        try {
            releaseRoot = ManagedBuildManager.getBuildMacroProvider().getMacro(EPOC32_RELEASE_ROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return releaseRoot;
    }
}

