/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class MBMCommandLineGenerator
implements IManagedCommandLineGenerator {
    public static final String EMPTY_STRING = "";
    public static final String WHITESPACE = " ";
    public static final String EPOCROOT = "EPOCROOT";
    public static final String TARGETPATH_COMMAND = "-targetpath";
    public static final String Z_FOLDER = "Z";
    public static final String EPOC32 = "EPOC32";
    public static final String DATA = "DATA";
    public static final String PROJ_DIR_PATH = "ProjDirPath";
    public static final String P_COMMAND = "-p";
    protected String EPOC32_DATA_DIR = "";
    protected String targetPath = "";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        this.setEpoc32DataDir(tool);
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + WHITESPACE);
        commandLine.append(String.valueOf(this.stripTargetPathFromFlags(flags)) + WHITESPACE);
        commandLine.append(P_COMMAND + this.getProjDirPath(tool) + WHITESPACE);
        commandLine.append(outputFlag.trim());
        commandLine.append(outputPrefix.trim());
        commandLine.append(String.valueOf(this.getFullOutputName(outputName, tool).trim()) + WHITESPACE);
        commandLine.append(this.stringArrayToString(inputResources));
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    protected String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + WHITESPACE);
            ++n;
        }
        return sb.toString().trim();
    }

    protected String stripTargetPathFromFlags(String[] flags) {
        StringBuffer cmdLineFlags = new StringBuffer();
        String[] stringArray = flags;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String flag = stringArray[n];
            if (flag.toLowerCase().startsWith(TARGETPATH_COMMAND)) {
                this.targetPath = flag.replace(TARGETPATH_COMMAND, EMPTY_STRING);
            } else {
                cmdLineFlags.append(String.valueOf(flag) + WHITESPACE);
            }
            ++n;
        }
        return cmdLineFlags.toString().trim();
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    protected String getFullOutputName(String outputName, ITool tool) {
        if (this.targetPath.equals(EMPTY_STRING)) {
            return "\"" + this.EPOC32_DATA_DIR + "${notdir " + outputName + "}\"";
        }
        return "\"" + this.EPOC32_DATA_DIR + Z_FOLDER + File.separator + this.targetPath + File.separator + "${notdir " + outputName + "}\"";
    }

    protected void setEpoc32DataDir(ITool tool) {
        this.EPOC32_DATA_DIR = String.valueOf(this.getEpocRoot(tool)) + EPOC32 + File.separator + DATA + File.separator;
    }

    protected String getEpocRoot(ITool tool) {
        try {
            return ManagedBuildManager.getBuildMacroProvider().getMacro(EPOCROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
            return EMPTY_STRING;
        }
    }

    protected String getProjDirPath(ITool tool) {
        try {
            return "\"" + ManagedBuildManager.getBuildMacroProvider().getMacro(PROJ_DIR_PATH, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue() + File.separator + "\"";
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
            return EMPTY_STRING;
        }
    }
}

