/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class PetranCommandLineGenerator
implements IManagedCommandLineGenerator {
    public static final String WHITESPACE = " ";
    public static final String EMPTY_STRING = "";
    public static final String UID1_COMMAND = "-uid1";
    public static final String UID2_COMMAND = "-uid2";
    public static final String UID3_COMMAND = "-uid3";
    public static final String EPOC32_RELEASE_ROOT = "EPOC32_RELEASE_ROOT";
    public static final String ARM4 = "ARM4";
    public static final String UDEB = "UDEB";
    public static final String UREL = "UREL";
    public static final String DLL = "DLL";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + WHITESPACE);
        commandLine.append(String.valueOf(this.fixFlags(tool, flags)) + WHITESPACE);
        commandLine.append("\"" + this.getFullInputName(tool, inputResources) + "\"" + WHITESPACE);
        commandLine.append(String.valueOf(outputFlag.trim()) + WHITESPACE);
        commandLine.append(outputPrefix.trim());
        commandLine.append("\"" + this.getFullOutputName(tool, outputName.trim()) + "\"" + WHITESPACE);
        IProject project = this.getConfigurationFromTool(tool).getOwner().getProject();
        IFile file = project.getFile(String.valueOf(this.getConfigurationFromTool(tool).getName().replace(WHITESPACE, "_").replace('.', '_')) + "_" + outputName);
        try {
            if (!file.isLinked()) {
                file.createLink(Path.fromOSString((String)this.getFullOutputName(tool, outputName)), 144, null);
            }
            file.refreshLocal(1, null);
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags).trim(), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources).trim());
    }

    protected String getFullInputName(ITool tool, String[] inputResources) {
        if (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB)) {
            return String.valueOf(this.getEpocReleaseRoot(tool)) + File.separator + ARM4 + File.separator + UDEB + File.separator + "$(strip " + this.stringArrayToString(inputResources).trim() + ")";
        }
        return "$(strip " + this.stringArrayToString(inputResources).trim() + ")";
    }

    protected String getFullOutputName(ITool tool, String outputName) {
        if (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB)) {
            return String.valueOf(this.getEpocReleaseRoot(tool)) + File.separator + ARM4 + File.separator + UDEB + File.separator + outputName;
        }
        return String.valueOf(this.getEpocReleaseRoot(tool)) + File.separator + ARM4 + File.separator + UREL + File.separator + outputName;
    }

    protected String getEpocReleaseRoot(ITool tool) {
        String releaseRoot = new String(EMPTY_STRING);
        try {
            releaseRoot = ManagedBuildManager.getBuildMacroProvider().getMacro(EPOC32_RELEASE_ROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return releaseRoot;
    }

    protected String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + WHITESPACE);
            ++n;
        }
        return sb.toString().trim();
    }

    protected String fixFlags(ITool tool, String[] flags) {
        IOption option;
        int n;
        int n2;
        IOption[] iOptionArray;
        String stringOptions = String.valueOf(this.stringArrayToString(flags)) + WHITESPACE;
        try {
            iOptionArray = tool.getOptions();
            n2 = 0;
            n = iOptionArray.length;
            while (n2 < n) {
                option = iOptionArray[n2];
                if (option.getValueType() == 2) {
                    String target = option.getCommand();
                    stringOptions = stringOptions.replace(target, String.valueOf(target) + WHITESPACE);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        try {
            iOptionArray = this.getConfigurationFromTool(tool).getToolChain().getOptions();
            n2 = 0;
            n = iOptionArray.length;
            while (n2 < n) {
                String value;
                option = iOptionArray[n2];
                if (option.isValid() && option.getCommand().toLowerCase().equals(UID1_COMMAND) && (value = option.getStringValue()) != null && !value.equals(EMPTY_STRING)) {
                    stringOptions = String.valueOf(stringOptions) + "-uid1 " + value + WHITESPACE;
                }
                if (option.isValid() && option.getCommand().toLowerCase().equals(UID2_COMMAND) && (value = option.getStringValue()) != null && !value.equals(EMPTY_STRING)) {
                    stringOptions = String.valueOf(stringOptions) + "-uid2 " + value + WHITESPACE;
                }
                if (option.isValid() && option.getCommand().toLowerCase().equals(UID3_COMMAND) && (value = option.getStringValue()) != null && !value.equals(EMPTY_STRING)) {
                    stringOptions = String.valueOf(stringOptions) + "-uid3 " + value + WHITESPACE;
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return stringOptions;
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }
}

