/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class PostLinkerCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String WHITESPACE = " ";
    public final String EMPTY_STRING = "";
    public final String LINKAS_COMMAND = "--linkas=";
    public final String TARGET_TYPE_COMMAND = "--targettype=";
    public final String LINKAS_NUMBER = "000a0000";
    public final String SID_COMMAND = "--sid=";
    public final String UID_COMMAND = "--uid";
    public final String VID_COMMAND = "--vid=";
    public final String UID = "uid";
    public final String EXEXP = "EXEXP";
    public final String PROJECT_TYPE_DOT = "PROJECTTYPE.";
    public final String DLL = "DLL";
    public final String EXE = "EXE";
    public final String LIB = "LIB";
    public final String PDLL = "PDLL";
    public final String ELFINPUT_COMMAND = "--elfinput=";
    public static final String EPOC32_RELEASE_ROOT = "EPOC32_RELEASE_ROOT";
    public static final String GCCE = "GCCE";
    public static final String UDEB = "UDEB";
    public static final String CAPABILITY_OPTION = "--capability=";
    public static final String DEFOUTPUT_OPTION = "--defoutput=";
    public static final String DSO_OPTION = "--dso=";
    public String sidValue;

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + " ");
        commandLine.append(String.valueOf(this.targetTypeForCommandLine(tool)) + " ");
        commandLine.append(String.valueOf(this.fixStringOptionsOfTool(tool, this.stringArrayToString(flags))) + " ");
        commandLine.append("--elfinput=" + this.getFullInputName(tool, inputResources) + " ");
        commandLine.append(String.valueOf(this.createDefOutputOption(tool, outputName)) + " ");
        commandLine.append(String.valueOf(this.createDsoOption(tool, outputName)) + " ");
        commandLine.append(String.valueOf(outputFlag.trim()) + "=");
        commandLine.append(outputPrefix.trim());
        commandLine.append(String.valueOf(outputName.trim()) + " ");
        commandLine.append(String.valueOf(this.createLinkAsCommand(tool, outputName.trim()).trim()) + " ");
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + " ");
            ++n;
        }
        return sb.toString().trim();
    }

    private String createLinkAsCommand(ITool tool, String outputName) {
        String linkAsName = "--linkas=${basename ${notdir " + outputName + "}}";
        linkAsName = String.valueOf(linkAsName) + "{000a0000}[" + this.sidValue + "]." + this.getTargetType(tool);
        return linkAsName;
    }

    protected String getBasicTargetType(ITool tool) {
        String id = this.getConfigurationFromTool(tool).getId().toUpperCase();
        if (id.contains("PROJECTTYPE.DLL")) {
            return "DLL";
        }
        if (id.contains("PROJECTTYPE.EXE")) {
            return "EXE";
        }
        if (id.contains("PROJECTTYPE.LIB")) {
            return "LIB";
        }
        if (id.contains("PROJECTTYPE.PDLL")) {
            return "DLL";
        }
        return "";
    }

    protected String createDefOutputOption(ITool tool, String outputName) {
        StringBuffer defOutput = new StringBuffer();
        if (this.getBasicTargetType(tool).equals("DLL")) {
            defOutput.append(DEFOUTPUT_OPTION);
            defOutput.append("${basename ${notdir " + outputName + "}}");
            defOutput.append("{000a0000}");
            defOutput.append(".def");
        }
        return defOutput.toString().trim();
    }

    protected String createDsoOption(ITool tool, String outputName) {
        StringBuffer defOutput = new StringBuffer();
        if (this.getBasicTargetType(tool).equals("DLL")) {
            defOutput.append(DSO_OPTION);
            defOutput.append("${basename ${notdir " + outputName + "}}");
            defOutput.append("{000a0000}");
            defOutput.append(".dso");
        }
        return defOutput.toString().trim();
    }

    protected String getTargetType(ITool tool) {
        IConfiguration config = this.getConfigurationFromTool(tool);
        String targetType = config.getArtifactExtension();
        return targetType;
    }

    private String targetTypeForCommandLine(ITool tool) {
        StringBuffer output = new StringBuffer();
        output.append("--targettype=");
        String basicTargetType = this.getBasicTargetType(tool);
        String targetType = this.getTargetType(tool);
        if (basicTargetType.compareToIgnoreCase("DLL") == 0 && targetType.compareToIgnoreCase("DLL") != 0 || targetType.compareToIgnoreCase("EXEXP") == 0) {
            output.append(String.valueOf(targetType) + " ");
        } else {
            output.append(String.valueOf(basicTargetType) + " ");
        }
        return output.toString().trim();
    }

    private String fixStringOptionsOfTool(ITool tool, String flags) {
        String stringOptions = String.valueOf(flags) + " ";
        try {
            String value;
            IOption option;
            IOption[] iOptionArray = this.getConfigurationFromTool(tool).getToolChain().getOptions();
            int n = 0;
            int n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().contains("capability") && (value = option.getStringValue()) != null && !value.equals("")) {
                    stringOptions = String.valueOf(stringOptions) + CAPABILITY_OPTION + value + " ";
                }
                ++n;
            }
            iOptionArray = this.getConfigurationFromTool(tool).getToolChain().getOptions();
            n = 0;
            n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().contains("secureid") && (value = option.getStringValue()) != null && !value.equals("")) {
                    this.sidValue = value;
                }
                ++n;
            }
            iOptionArray = this.getConfigurationFromTool(tool).getToolChain().getOptions();
            n = 0;
            n2 = iOptionArray.length;
            while (n < n2) {
                option = iOptionArray[n];
                int uidIndex = 1;
                while (uidIndex <= 3) {
                    String value2;
                    if (option.isValid() && option.getCommand().toLowerCase().contains("uid" + uidIndex) && (value2 = option.getStringValue()) != null && !value2.equals("")) {
                        stringOptions = String.valueOf(stringOptions) + "--uid" + uidIndex + "=" + value2 + " ";
                        if (uidIndex == 3 && this.sidValue == null) {
                            this.sidValue = value2;
                        }
                    }
                    ++uidIndex;
                }
                ++n;
            }
            stringOptions = String.valueOf(stringOptions) + "--sid=" + this.sidValue + " ";
            iOptionArray = this.getConfigurationFromTool(tool).getToolChain().getOptions();
            n = 0;
            n2 = iOptionArray.length;
            while (n < n2) {
                String value3;
                option = iOptionArray[n];
                if (option.isValid() && option.getCommand().toLowerCase().contains("vendorid") && (value3 = option.getStringValue()) != null && !value3.equals("")) {
                    stringOptions = String.valueOf(stringOptions) + "--vid=" + value3 + " ";
                }
                ++n;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return stringOptions;
    }

    protected String getFullInputName(ITool tool, String[] inputResources) {
        if (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB)) {
            return String.valueOf(this.getEpocReleaseRoot(tool)) + File.separator + GCCE + File.separator + UDEB + File.separator + "$(strip " + this.stringArrayToString(inputResources).trim() + ")";
        }
        return "$(strip " + this.stringArrayToString(inputResources).trim() + ")";
    }

    protected String getEpocReleaseRoot(ITool tool) {
        String releaseRoot = new String("");
        try {
            releaseRoot = ManagedBuildManager.getBuildMacroProvider().getMacro(EPOC32_RELEASE_ROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return releaseRoot;
    }

    private IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }
}

