/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class RCompCommandLineGenerator
implements IManagedCommandLineGenerator {
    public static final String EMPTY_STRING = "";
    public static final String WHITESPACE = " ";
    public static final String GLOBAL_SYSTEM_INCLUDE_PATHS = "GLOBAL_SYSTEM_INCLUDE_PATHS";
    public static final String GLOBAL_USER_INCLUDE_PATHS = "GLOBAL_USER_INCLUDE_PATHS";
    public static final String INCLUDE_COMMAND = "-I";
    public static final String INCLUDE_EXPLICIT_COMMAND = "-I-";
    public static final String MINUS_H_COMMAND = "-h";
    public static final String RSG_FILE_EXTENSION = ".rsg";
    public static final String EPOCROOT = "EPOCROOT";
    public static final String TARGETPATH_COMMAND = "-targetpath";
    public static final String UID2_COMMAND = "-uid2";
    public static final String UID3_COMMAND = "-uid3";
    public static final String Z_FOLDER = "Z";
    public static final String EPOC32 = "EPOC32";
    public static final String RELEASE = "RELEASE";
    public static final String DATA = "DATA";
    private String EPOC32_DATA_DIR = "";
    protected String targetPath = "";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        IConfiguration configuration = this.getConfigurationFromTool(tool);
        this.setEpoc32DataDir(tool);
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + WHITESPACE);
        try {
            commandLine.append(String.valueOf(this.processCommandLineFlags(flags, configuration)) + WHITESPACE);
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        commandLine.append(outputFlag.trim());
        commandLine.append(outputPrefix.trim());
        commandLine.append(String.valueOf(this.getFullOutputName(outputName, tool).trim()) + WHITESPACE);
        commandLine.append(String.valueOf(this.includeFileName(outputName)) + WHITESPACE);
        commandLine.append(this.stringArrayToString(inputResources));
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    protected String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + WHITESPACE);
            ++n;
        }
        return sb.toString().trim();
    }

    protected String processCommandLineFlags(String[] flags, IConfiguration configuration) throws BuildMacroException, BuildException {
        StringBuffer cmdLineFlags = new StringBuffer();
        String[] stringArray = flags;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String flag = stringArray[n];
            if (flag.compareToIgnoreCase(INCLUDE_EXPLICIT_COMMAND) == 0) {
                String userIncludePath = new String();
                String[] stringArray2 = ManagedBuildManager.getBuildMacroProvider().getMacro(GLOBAL_USER_INCLUDE_PATHS, 3, (Object)configuration, true).getStringValue().split(WHITESPACE);
                int n3 = 0;
                int n4 = stringArray2.length;
                while (n3 < n4) {
                    String path = stringArray2[n3];
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, EMPTY_STRING, WHITESPACE, 3, (Object)configuration);
                    if ((resolved = resolved.trim()).length() > 0) {
                        path = resolved;
                    }
                    userIncludePath = String.valueOf(userIncludePath) + INCLUDE_COMMAND + path + WHITESPACE;
                    ++n3;
                }
                cmdLineFlags.append(userIncludePath);
                cmdLineFlags.append("-I- ");
                String systemIncludePath = new String();
                String[] stringArray3 = ManagedBuildManager.getBuildMacroProvider().getMacro(GLOBAL_SYSTEM_INCLUDE_PATHS, 3, (Object)configuration, true).getStringValue().split(WHITESPACE);
                n4 = 0;
                int n5 = stringArray3.length;
                while (n4 < n5) {
                    String path = stringArray3[n4];
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, EMPTY_STRING, WHITESPACE, 3, (Object)configuration);
                    if ((resolved = resolved.trim()).length() > 0) {
                        path = resolved;
                    }
                    systemIncludePath = String.valueOf(systemIncludePath) + INCLUDE_COMMAND + path + WHITESPACE;
                    ++n4;
                }
                cmdLineFlags.append(systemIncludePath);
            } else if (flag.toLowerCase().startsWith(TARGETPATH_COMMAND)) {
                this.targetPath = flag.replace(TARGETPATH_COMMAND, EMPTY_STRING);
            } else if (flag.toLowerCase().startsWith(UID2_COMMAND)) {
                cmdLineFlags.append(String.valueOf(flag.replace(UID2_COMMAND, "-uid2 ")) + WHITESPACE);
            } else if (flag.toLowerCase().startsWith(UID3_COMMAND)) {
                cmdLineFlags.append(String.valueOf(flag.replace(UID3_COMMAND, "-uid3 ")) + WHITESPACE);
            } else {
                cmdLineFlags.append(String.valueOf(flag) + WHITESPACE);
            }
            ++n;
        }
        return cmdLineFlags.toString().trim();
    }

    protected String includeFileName(String outputName) {
        return "-h${basename ${notdir " + outputName + "}}" + RSG_FILE_EXTENSION;
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    protected String getFullOutputName(String outputName, ITool tool) {
        if (this.targetPath.equals(EMPTY_STRING)) {
            return "\"" + this.EPOC32_DATA_DIR + "${notdir " + outputName + "}\"";
        }
        return "\"" + this.EPOC32_DATA_DIR + Z_FOLDER + File.separator + this.targetPath + File.separator + "${notdir " + outputName + "}\"";
    }

    protected String getEpocRoot(ITool tool) {
        try {
            return ManagedBuildManager.getBuildMacroProvider().getMacro(EPOCROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
            return EMPTY_STRING;
        }
    }

    protected void setEpoc32DataDir(ITool tool) {
        this.EPOC32_DATA_DIR = String.valueOf(this.getEpocRoot(tool)) + EPOC32 + File.separator + DATA + File.separator;
    }
}

