/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import com.symbian.cdt.build.ManagedBuildSymbianToolInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SymbianMakefileGenerator
implements IManagedBuilderMakefileGenerator {
    private static final String COMMENT = "MakefileGenerator.comment";
    private static final String HEADER = "MakefileGenerator.comment.header";
    protected static final String MESSAGE_FINISH_BUILD = ManagedMakeMessages.getResourceString((String)"MakefileGenerator.message.finish.build");
    protected static final String MESSAGE_FINISH_FILE = ManagedMakeMessages.getResourceString((String)"MakefileGenerator.message.finish.file");
    protected static final String MESSAGE_START_BUILD = ManagedMakeMessages.getResourceString((String)"MakefileGenerator.message.start.build");
    protected static final String MESSAGE_START_FILE = ManagedMakeMessages.getResourceString((String)"MakefileGenerator.message.start.file");
    protected static final String MESSAGE_NO_TARGET_TOOL = ManagedMakeMessages.getResourceString((String)"MakefileGenerator.message.no.target");
    private static final String MOD_LIST = "MakefileGenerator.comment.module.list";
    private static final String MOD_VARS = "MakefileGenerator.comment.module.variables";
    private static final String MOD_RULES = "MakefileGenerator.comment.build.rule";
    private static final String BUILD_TOP = "MakefileGenerator.comment.build.toprules";
    private static final String ALL_TARGET = "MakefileGenerator.comment.build.alltarget";
    private static final String MAINBUILD_TARGET = "MakefileGenerator.comment.build.mainbuildtarget";
    private static final String BUILD_TARGETS = "MakefileGenerator.comment.build.toptargets";
    private static final String SRC_LISTS = "MakefileGenerator.comment.source.list";
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String OBJS_MACRO = "OBJS";
    private static final String DEPS_MACRO = "DEPS";
    private static final String MACRO_ADDITION_ADDPREFIX_HEADER = "${addprefix ";
    private static final String MACRO_ADDITION_ADDPREFIX_SUFFIX = ", \\\n";
    private static final String MACRO_ADDITION_PREFIX_SUFFIX = "+= \\\n";
    private static final String PREBUILD = "pre-build";
    private static final String MAINBUILD = "main-build";
    private static final String POSTBUILD = "post-build";
    private static final String SECONDARY_OUTPUTS = "secondary-outputs";
    public static final int PROJECT_RELATIVE = 1;
    public static final int PROJECT_SUBDIR_RELATIVE = 2;
    public static final int ABSOLUTE = 3;
    private String buildTargetName;
    private String buildTargetExt;
    protected IConfiguration config;
    private ITool[] buildTools;
    private boolean[] buildToolsUsed;
    private ManagedBuildSymbianToolInfo[] gnuToolInfos;
    private Vector deletedFileList;
    private Vector deletedDirList;
    private Vector dependencyMakefiles;
    protected IManagedBuildInfo info;
    private Vector invalidDirList;
    private Vector modifiedList;
    private IProgressMonitor monitor;
    protected IProject project;
    private IResource[] projectResources;
    private Vector ruleList;
    private Vector subdirList;
    private IPath topBuildDir;
    private Set<String> outputExtensionsSet;
    private HashMap buildSrcVars = new HashMap();
    private HashMap buildOutVars = new HashMap();
    private HashMap buildOutVarsForDel = new HashMap();
    private LinkedHashMap topBuildOutVars = new LinkedHashMap();
    private static final String FOR_DEL = "_FOR_DEL";

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        try {
            this.projectResources = project.members();
        }
        catch (CoreException coreException) {
            this.projectResources = null;
        }
        this.monitor = monitor;
        this.info = info;
        this.buildTargetName = info.getBuildArtifactName();
        this.buildTargetExt = info.getBuildArtifactExtension();
        try {
            this.buildTargetExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetExt, "", " ", 3, (Object)info.getDefaultConfiguration());
        }
        catch (BuildMacroException buildMacroException) {}
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetName, "", " ", 3, (Object)info.getDefaultConfiguration());
            resolved = resolved.trim();
            if (resolved.length() > 0) {
                this.buildTargetName = resolved;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        if (this.buildTargetExt == null) {
            this.buildTargetExt = new String();
        }
        this.config = info.getDefaultConfiguration();
        this.buildTools = this.config.getFilteredTools();
        this.buildToolsUsed = new boolean[this.buildTools.length];
        int i = 0;
        while (i < this.buildTools.length) {
            this.buildToolsUsed[i] = false;
            ++i;
        }
        this.gnuToolInfos = new ManagedBuildSymbianToolInfo[this.buildTools.length];
        this.topBuildDir = project.getFolder(info.getConfigurationName()).getFullPath();
    }

    public void generateDependencies() throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        Iterator subDirs = this.getSubdirList().listIterator();
        while (subDirs.hasNext()) {
            IContainer subDir = (IContainer)subDirs.next();
            IPath projectRelativePath = subDir.getProjectRelativePath();
            IPath buildRelativePath = this.topBuildDir.append(projectRelativePath);
            IFolder buildFolder = root.getFolder(buildRelativePath);
            if (buildFolder == null) continue;
            IResource[] files = buildFolder.members();
            int index = 0;
            while (index < files.length) {
                IFile depFile;
                IResource file = files[index];
                if ("d".equals(file.getFileExtension()) && (depFile = root.getFile(file.getFullPath())) != null) {
                    try {
                        this.updateMonitor(ManagedMakeMessages.getFormattedString((String)"GnuMakefileGenerator.message.postproc.dep.file", (String)depFile.getName()));
                        this.populateDummyTargets(depFile, false);
                    }
                    catch (CoreException e) {
                        throw e;
                    }
                    catch (IOException iOException) {}
                }
                ++index;
            }
        }
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        MultiStatus status;
        IContainer subDir;
        IFolder folder = this.project.getFolder(this.info.getConfigurationName());
        if (!folder.exists()) {
            return this.regenerateMakefiles();
        }
        this.topBuildDir = this.checkAndCreateBuildDirectory(this.info);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString((String)"MakefileGenerator.message.calc.delta", (String)this.project.getName()));
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.info);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString((String)"MakefileGenerator.message.finding.sources", (String)this.project.getName()));
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString((String)"MakefileGenerator.warning.no.source", (String)this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.buildOutVarsForDel.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subdirectory = (IContainer)iter.next();
            if (this.getModifiedList().contains(subdirectory)) continue;
            if (!subdirectory.exists()) {
                this.appendDeletedSubdirectory(subdirectory);
                continue;
            }
            IPath fragmentPath = this.getBuildWorkingDir().append(subdirectory.getProjectRelativePath()).append("subdir.mk");
            IFile makeFragment = this.project.getFile(fragmentPath);
            if (makeFragment.exists()) continue;
            this.getModifiedList().add(subdirectory);
        }
        iter = this.getDeletedFileList().listIterator();
        while (iter.hasNext()) {
            IResource deletedFile = (IResource)iter.next();
            this.deleteDepFile(deletedFile);
            this.deleteBuildTarget(deletedFile);
        }
        iter = this.getModifiedList().listIterator();
        while (iter.hasNext()) {
            subDir = (IContainer)iter.next();
            if (!subDir.exists()) {
                this.appendDeletedSubdirectory(subDir);
                continue;
            }
            this.checkCancel();
        }
        iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath makefilePath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, false);
        this.checkCancel();
        iter = this.getDeletedDirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir2 = (IContainer)iter.next();
            this.removeGeneratedDirectory(subDir2);
            this.checkCancel();
        }
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    public String getMakefileName() {
        return new String("makefile");
    }

    public boolean isGeneratedResource(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        String[] configNames = this.info.getConfigurationNames();
        int i = 0;
        while (i < configNames.length) {
            String name = configNames[i];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        Iterator iter = this.getDependencyMakefiles().listIterator();
        while (iter.hasNext()) {
            IPath relDepFilePath = this.topBuildDir.append((IPath)new Path((String)iter.next()));
            IFile depFile = root.getFile(relDepFilePath);
            if (depFile == null || !depFile.isAccessible()) continue;
            try {
                this.updateMonitor(ManagedMakeMessages.getFormattedString((String)"GnuMakefileGenerator.message.postproc.dep.file", (String)depFile.getName()));
                this.populateDummyTargets(depFile, true);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (IOException iOException) {}
        }
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status;
        this.topBuildDir = this.checkAndCreateBuildDirectory(this.info);
        this.checkCancel();
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString((String)"MakefileGenerator.warning.no.source", (String)this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.buildOutVarsForDel.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath makefilePath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, true);
        this.checkCancel();
        IPath objFilePath = this.topBuildDir.append("objects.mk");
        IFile objsFileHandle = this.createFile(objFilePath);
        this.populateObjectsMakefile(objsFileHandle);
        this.checkCancel();
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    protected void populateDummyTargets(IFile makefile, boolean force) throws CoreException, IOException {
        String firstLine;
        if (makefile == null || !makefile.exists()) {
            return;
        }
        InputStream contentStream = makefile.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        StringBuffer inBuffer = null;
        int chunkSize = contentStream.available();
        inBuffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            inBuffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        if (inBuffer == null) {
            return;
        }
        String inBufferString = inBuffer.toString();
        if (!force && inBufferString.startsWith("#")) {
            return;
        }
        Vector bufferTokens = new Vector(Arrays.asList(inBufferString.split("\\s")));
        Vector<String> deps = new Vector<String>(bufferTokens.size());
        Iterator tokenIter = bufferTokens.iterator();
        while (tokenIter.hasNext()) {
            String token = (String)tokenIter.next();
            if (token.lastIndexOf("\\") == token.length() - 1 && token.length() > 1) {
                while (tokenIter.hasNext()) {
                    String nextToken = (String)tokenIter.next();
                    token = String.valueOf(token) + " " + nextToken;
                    if (!nextToken.endsWith("\\")) break;
                }
            }
            deps.add(token);
        }
        deps.trimToSize();
        boolean save = false;
        StringBuffer outBuffer = null;
        try {
            firstLine = (String)deps.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        outBuffer = !firstLine.startsWith("#") ? this.addDefaultHeader() : new StringBuffer();
        if (firstLine.startsWith("-n")) {
            String fourthLine;
            String thirdLine;
            String secondLine;
            try {
                secondLine = (String)deps.get(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                secondLine = new String();
            }
            if (secondLine.startsWith("'")) {
                outBuffer.append(String.valueOf(secondLine.substring(1)) + " ");
            } else {
                outBuffer.append(String.valueOf(secondLine) + " ");
            }
            try {
                thirdLine = (String)deps.get(2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                thirdLine = new String();
            }
            int lastIndex = thirdLine.lastIndexOf("'");
            if (lastIndex != -1) {
                if (lastIndex == 0) {
                    outBuffer.append(" ");
                } else {
                    outBuffer.append(thirdLine.substring(0, lastIndex - 1));
                }
            } else {
                outBuffer.append(thirdLine);
            }
            try {
                fourthLine = (String)deps.get(3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                fourthLine = new String();
            }
            outBuffer.append(String.valueOf(fourthLine) + " ");
            try {
                Iterator iter = deps.listIterator(4);
                while (iter.hasNext()) {
                    String nextElement = (String)iter.next();
                    if (nextElement.endsWith("\\")) {
                        outBuffer.append(String.valueOf(nextElement) + NEWLINE + " ");
                        continue;
                    }
                    outBuffer.append(String.valueOf(nextElement) + " ");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            outBuffer.append(inBuffer);
        }
        outBuffer.append(NEWLINE);
        save = true;
        for (String dummy : deps) {
            Path dep = new Path(dummy);
            String extension = dep.getFileExtension();
            if (!this.info.isHeaderFile(extension)) continue;
            outBuffer.append(String.valueOf(dummy) + ":" + NEWLINE + NEWLINE);
        }
        if (save) {
            Util.save((StringBuffer)outBuffer, (IFile)makefile);
        }
    }

    protected void populateFragmentMakefile(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        this.updateMonitor(ManagedMakeMessages.getFormattedString((String)"MakefileGenerator.message.gen.source.makefile", (String)moduleOutputPath.toString()));
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile modMakefile = this.createFile(moduleOutputDir.append("subdir.mk"));
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append(this.addFragmentMakefileHeader());
        makeBuf.append(this.addSources(module));
        Util.save((StringBuffer)makeBuf, (IFile)modMakefile);
    }

    protected void populateObjectsMakefile(IFile fileHandle) throws CoreException {
        StringBuffer macroBuffer = new StringBuffer();
        macroBuffer.append(this.addDefaultHeader());
        HashMap outputMacros = new HashMap();
        List valueList = new ArrayList<String>();
        ITool[] iToolArray = this.info.getDefaultConfiguration().getFilteredTools();
        int n = 0;
        int n2 = iToolArray.length;
        while (n < n2) {
            ITool tool = iToolArray[n];
            String[] stringArray = this.getLibsForTool(tool);
            int n3 = 0;
            int n4 = stringArray.length;
            while (n3 < n4) {
                String libs = stringArray[n3];
                valueList.add(libs);
                ++n3;
            }
            ++n;
        }
        outputMacros.put("LIBS", valueList);
        valueList = new ArrayList();
        String[] userObjs = this.info.getUserObjectsForConfiguration(this.buildTargetExt);
        int i = 0;
        while (i < userObjs.length) {
            String string = userObjs[i];
            valueList.add(string);
            ++i;
        }
        outputMacros.put("USER_OBJS", valueList);
        Iterator iterator = outputMacros.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            macroBuffer.append(entry.getKey() + " :=");
            valueList = (List)entry.getValue();
            Iterator valueIter = valueList.iterator();
            while (valueIter.hasNext()) {
                macroBuffer.append(" " + (String)valueIter.next());
            }
            if (!iterator.hasNext()) continue;
            macroBuffer.append(String.valueOf(NEWLINE) + NEWLINE);
        }
        Util.save((StringBuffer)macroBuffer, (IFile)fileHandle);
    }

    protected void populateSourcesMakefile(IFile fileHandle) throws CoreException {
        String macroName;
        StringBuffer buffer = this.addDefaultHeader();
        HashSet<String> handledInputExtensions = new HashSet<String>();
        int i = 0;
        while (i < this.buildTools.length) {
            String buildMacro;
            String[] extensionsList = this.buildTools[i].getAllInputExtensions();
            int j = 0;
            while (j < extensionsList.length) {
                String extensionName = extensionsList[j];
                if (!handledInputExtensions.contains(extensionName)) {
                    handledInputExtensions.add(extensionName);
                    buildMacro = this.getSourceMacroName(extensionName).toString();
                    if (!this.buildSrcVars.containsKey(buildMacro)) {
                        this.buildSrcVars.put(buildMacro, new ArrayList());
                    }
                }
                ++j;
            }
            IOutputType[] outTypes = this.buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j2 = 0;
                while (j2 < outTypes.length) {
                    buildMacro = outTypes[j2].getBuildVariable();
                    if (!this.buildOutVars.containsKey(buildMacro)) {
                        this.buildOutVars.put(buildMacro, new ArrayList());
                        this.buildOutVarsForDel.put(String.valueOf(buildMacro) + FOR_DEL, new ArrayList());
                    }
                    ++j2;
                }
            } else {
                buildMacro = OBJS_MACRO;
                if (!this.buildOutVars.containsKey(buildMacro)) {
                    this.buildOutVars.put(buildMacro, new ArrayList());
                    this.buildOutVarsForDel.put(String.valueOf(buildMacro) + FOR_DEL, new ArrayList());
                }
            }
            buildMacro = DEPS_MACRO;
            if (!this.buildOutVars.containsKey(buildMacro)) {
                this.buildOutVars.put(buildMacro, new ArrayList());
                this.buildOutVarsForDel.put(String.valueOf(buildMacro) + FOR_DEL, new ArrayList());
            }
            ++i;
        }
        for (Map.Entry entry : this.buildSrcVars.entrySet()) {
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + NEWLINE);
        }
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + NEWLINE);
        }
        for (Map.Entry entry : this.buildOutVarsForDel.entrySet()) {
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + NEWLINE);
        }
        buffer.append(String.valueOf(NEWLINE) + this.addSubdirectories());
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addTopHeader());
        buffer.append(this.addMacros());
        ArrayList outputVarsAdditionsList = new ArrayList();
        StringBuffer targetRules = this.addTargets(outputVarsAdditionsList, rebuild);
        buffer.append(this.writeTopAdditionMacros(outputVarsAdditionsList, this.getTopBuildOutputVars()));
        buffer.append(targetRules);
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected StringBuffer addTopHeader() {
        return this.addDefaultHeader();
    }

    private StringBuffer addMacros() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ROOT := .." + NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("-include $(ROOT)/makefile.init" + NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("RM := ");
        buffer.append(String.valueOf(this.info.getCleanCommand()) + NEWLINE);
        buffer.append(NEWLINE);
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)SRC_LISTS) + NEWLINE);
        buffer.append("-include sources.mk" + NEWLINE);
        buffer.append("-include $(SUBDIRS:%=%/subdir.mk)" + NEWLINE);
        buffer.append("-include objects.mk" + NEWLINE);
        buffer.append("ifneq ($(strip $(DEPS)),)" + NEWLINE);
        buffer.append("-include $(DEPS)" + NEWLINE);
        buffer.append("endif" + NEWLINE + NEWLINE);
        buffer.append("-include $(ROOT)/makefile.defs" + NEWLINE);
        return buffer.append(NEWLINE);
    }

    private StringBuffer addTargets(List outputVarsAdditionsList, boolean rebuild) {
        int i;
        StringBuffer buffer = new StringBuffer();
        IConfiguration config = this.info.getDefaultConfiguration();
        String prebuildStep = this.info.getPrebuildStep();
        try {
            prebuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prebuildStep, EMPTY_STRING, " ", 3, (Object)config);
        }
        catch (BuildMacroException buildMacroException) {}
        prebuildStep = prebuildStep.trim();
        String postbuildStep = this.info.getPostbuildStep();
        try {
            postbuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(postbuildStep, EMPTY_STRING, " ", 3, (Object)config);
        }
        catch (BuildMacroException buildMacroException) {}
        postbuildStep = postbuildStep.trim();
        String preannouncebuildStep = this.info.getPreannouncebuildStep();
        String postannouncebuildStep = this.info.getPostannouncebuildStep();
        String targets = rebuild ? "clean all" : "all";
        ITool targetTool = config.getTargetTool();
        if (targetTool == null) {
            targetTool = this.info.getToolFromOutputExtension(this.buildTargetExt);
        }
        IProject[] refdProjects = null;
        try {
            refdProjects = this.project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        String defaultTarget = "all:";
        if (prebuildStep.length() > 0) {
            buffer.append("# " + ManagedMakeMessages.getResourceString((String)ALL_TARGET) + NEWLINE);
            buffer.append(String.valueOf(defaultTarget) + " ");
            buffer.append("pre-build ");
            defaultTarget = MAINBUILD;
            buffer.append(defaultTarget);
            defaultTarget = defaultTarget.concat(":");
            buffer.append(String.valueOf(NEWLINE) + NEWLINE);
            buffer.append("# " + ManagedMakeMessages.getResourceString((String)MAINBUILD_TARGET) + NEWLINE);
        } else {
            buffer.append("# " + ManagedMakeMessages.getResourceString((String)ALL_TARGET) + NEWLINE);
        }
        String outputPrefix = EMPTY_STRING;
        buffer.append(String.valueOf(defaultTarget) + " ");
        IOutputType[] secondaryOutputs = config.getToolChain().getSecondaryOutputs();
        if (secondaryOutputs.length > 0) {
            buffer.append("secondary-outputs ");
        }
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(String.valueOf(outputPrefix) + this.buildTargetName);
        if (this.buildTargetExt.length() > 0) {
            buffer.append(".").append(this.buildTargetExt).append(" ");
        }
        buffer.append("$(SIS_OBJS)");
        buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        Vector<String> managedProjectOutputs = new Vector<String>(refdProjects.length);
        if (refdProjects.length > 0) {
            boolean addDeps = true;
            if (refdProjects != null) {
                i = 0;
                while (i < refdProjects.length) {
                    IProject dep = refdProjects[i];
                    if (dep.exists()) {
                        if (addDeps) {
                            buffer.append("dependents:" + NEWLINE);
                            addDeps = false;
                        }
                        String buildDir = dep.getLocation().toString();
                        String depTargets = targets;
                        if (ManagedBuildManager.manages((IResource)dep)) {
                            IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)dep);
                            buildDir = String.valueOf(buildDir) + "/" + depInfo.getConfigurationName();
                            String depTarget = depInfo.getBuildArtifactName();
                            String depExt = depInfo.getBuildArtifactExtension();
                            try {
                                depExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depExt, "", " ", 3, (Object)this.info.getDefaultConfiguration());
                            }
                            catch (BuildMacroException buildMacroException) {}
                            try {
                                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depTarget, "", " ", 3, (Object)this.info.getDefaultConfiguration());
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    depTarget = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            String depPrefix = depInfo.getOutputPrefix(depExt);
                            if (depInfo.needsRebuild()) {
                                depTargets = "clean all";
                            }
                            String dependency = String.valueOf(buildDir) + "/" + depPrefix + depTarget;
                            if (depExt.length() > 0) {
                                dependency = String.valueOf(dependency) + "." + depExt;
                            }
                            dependency = this.escapeWhitespaces(dependency);
                            managedProjectOutputs.add(dependency);
                        }
                        buffer.append("\t-cd " + this.escapeWhitespaces(buildDir) + " " + "&&" + " " + "$(MAKE) " + depTargets + NEWLINE);
                    }
                    ++i;
                }
            }
            buffer.append(NEWLINE);
        }
        buffer.append(this.addTargetsRules(targetTool, outputVarsAdditionsList, managedProjectOutputs, postbuildStep.length() > 0));
        if (prebuildStep.length() > 0) {
            buffer.append("pre-build:" + NEWLINE);
            if (preannouncebuildStep.length() > 0) {
                buffer.append("\t-@echo '" + preannouncebuildStep + "'" + NEWLINE);
            }
            buffer.append("\t-" + prebuildStep + NEWLINE);
            buffer.append("\t-@echo ' '" + NEWLINE + NEWLINE);
        }
        if (postbuildStep.length() > 0) {
            buffer.append("post-build:" + NEWLINE);
            if (postannouncebuildStep.length() > 0) {
                buffer.append("\t-@echo '" + postannouncebuildStep + "'" + NEWLINE);
            }
            buffer.append("\t-" + postbuildStep + NEWLINE);
            buffer.append("\t-@echo ' '" + NEWLINE + NEWLINE);
        }
        if (secondaryOutputs.length > 0) {
            buffer.append("secondary-outputs:");
            Vector outs2 = this.calculateSecondaryOutputs(secondaryOutputs);
            i = 0;
            while (i < outs2.size()) {
                buffer.append(" $(" + (String)outs2.get(i) + ")");
                ++i;
            }
            buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        }
        buffer.append(".PHONY: all clean dependents" + NEWLINE);
        buffer.append(".SECONDARY:");
        if (prebuildStep.length() > 0) {
            buffer.append(" main-build pre-build");
        }
        if (postbuildStep.length() > 0) {
            buffer.append(" post-build");
        }
        buffer.append(NEWLINE);
        Iterator refIter = managedProjectOutputs.listIterator();
        while (refIter.hasNext()) {
            buffer.append(String.valueOf((String)refIter.next()) + ":" + NEWLINE);
        }
        buffer.append(NEWLINE);
        buffer.append("-include $(ROOT)/makefile.targets" + NEWLINE);
        return buffer;
    }

    private StringBuffer addTargetsRules(ITool targetTool, List outputVarsAdditionsList, Vector managedProjectOutputs, boolean postbuildStep) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)BUILD_TOP) + NEWLINE);
        if (targetTool != null) {
            if (this.addRuleForTool(targetTool, buffer, true, this.buildTargetName, this.buildTargetExt, outputVarsAdditionsList, managedProjectOutputs, postbuildStep)) {
                i = 0;
                while (i < this.buildTools.length) {
                    if (targetTool == this.buildTools[i]) {
                        this.buildToolsUsed[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            buffer.append("\t@echo '" + MESSAGE_NO_TARGET_TOOL + " " + "$@" + "'" + NEWLINE);
        }
        i = 0;
        while (i < this.buildTools.length) {
            ITool tool = this.buildTools[i];
            IInputType type = tool.getPrimaryInputType();
            if (type != null && type.getMultipleOfType() && !this.buildToolsUsed[i]) {
                this.addRuleForTool(tool, buffer, false, null, null, outputVarsAdditionsList, null, false);
                this.buildToolsUsed[i] = true;
                this.generateRulesForConsumers(tool, outputVarsAdditionsList, buffer);
            }
            ++i;
        }
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)BUILD_TARGETS) + NEWLINE);
        buffer.append("clean:" + NEWLINE);
        buffer.append("\t-$(RM) ");
        for (Map.Entry entry : this.buildOutVarsForDel.entrySet()) {
            String macroName = (String)entry.getKey();
            buffer.append("$(" + macroName + ")");
        }
        String outputPrefix = EMPTY_STRING;
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(" " + outputPrefix + this.buildTargetName);
        if (this.buildTargetExt.length() > 0) {
            buffer.append("." + this.buildTargetExt);
        }
        buffer.append(NEWLINE);
        buffer.append("\t-@echo ' '" + NEWLINE + NEWLINE);
        return buffer;
    }

    protected boolean addRuleForTool(ITool tool, StringBuffer buffer, boolean bTargetTool, String targetName, String targetExt, List outputVarsAdditionsList, Vector managedProjectOutputs, boolean bEmitPostBuildStepCall) {
        String[] flags;
        Vector inputs = new Vector();
        Vector dependencies = new Vector();
        Vector outputs = new Vector();
        Vector enumeratedPrimaryOutputs = new Vector();
        Vector enumeratedSecondaryOutputs = new Vector();
        Vector outputVariables = new Vector();
        String outputPrefix = EMPTY_STRING;
        if (!this.getToolInputsOutputs(tool, inputs, dependencies, outputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputVariables, bTargetTool, managedProjectOutputs)) {
            return false;
        }
        if (enumeratedPrimaryOutputs.size() == 0) {
            enumeratedPrimaryOutputs = enumeratedSecondaryOutputs;
            enumeratedSecondaryOutputs.clear();
        }
        outputVarsAdditionsList.addAll(outputVariables);
        String buildRule = EMPTY_STRING;
        String outflag = tool.getOutputFlag();
        String primaryOutputs = EMPTY_STRING;
        boolean first = true;
        int i = 0;
        while (i < enumeratedPrimaryOutputs.size()) {
            String output = (String)enumeratedPrimaryOutputs.get(i);
            if (!first) {
                primaryOutputs = String.valueOf(primaryOutputs) + " ";
            }
            first = false;
            primaryOutputs = String.valueOf(primaryOutputs) + output;
            ++i;
        }
        buildRule = String.valueOf(buildRule) + primaryOutputs + ":" + " ";
        first = true;
        i = 0;
        while (i < dependencies.size()) {
            String input = (String)dependencies.get(i);
            if (!first) {
                buildRule = String.valueOf(buildRule) + " ";
            }
            first = false;
            buildRule = String.valueOf(buildRule) + input;
            ++i;
        }
        if (this.getRuleList().contains(buildRule)) {
            return true;
        }
        this.getRuleList().add(buildRule);
        buffer.append(String.valueOf(buildRule) + NEWLINE);
        if (bTargetTool) {
            buffer.append("\t@echo '" + MESSAGE_START_BUILD + " " + "$@" + "'" + NEWLINE);
        }
        buffer.append("\t@echo '" + tool.getAnnouncement() + "'" + NEWLINE);
        try {
            flags = tool.getToolCommandFlags(null, null);
        }
        catch (BuildException buildException) {
            flags = EMPTY_STRING_ARRAY;
        }
        String command = tool.getToolCommand();
        try {
            String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(command, EMPTY_STRING, " ", 1, (Object)new FileContextData(null, null, null, (IBuildObject)this.info.getDefaultConfiguration().getToolChain()));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                command = resolvedCommand;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        String[] cmdInputs = inputs.toArray(new String[inputs.size()]);
        IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
        IManagedCommandLineInfo cmdLInfo = gen.generateCommandLineInfo(tool, command, flags, outflag, outputPrefix, primaryOutputs, cmdInputs, tool.getCommandLinePattern());
        String buildCmd = null;
        if (cmdLInfo == null) {
            String toolFlags;
            try {
                toolFlags = tool.getToolCommandFlagsString(null, null);
            }
            catch (BuildException buildException) {
                toolFlags = EMPTY_STRING;
            }
            buildCmd = String.valueOf(command) + " " + toolFlags + " " + outflag + " " + outputPrefix + primaryOutputs + " " + "$<";
        } else {
            buildCmd = cmdLInfo.getCommandLine();
        }
        buffer.append("\t@echo " + buildCmd + NEWLINE);
        buffer.append("\t@" + buildCmd);
        buffer.append(NEWLINE);
        if (bTargetTool) {
            buffer.append("\t@echo '" + MESSAGE_FINISH_BUILD + " " + "$@" + "'" + NEWLINE);
        } else {
            buffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$@" + "'" + NEWLINE);
        }
        buffer.append("\t@echo ' '" + NEWLINE);
        if (bEmitPostBuildStepCall) {
            buffer.append("\t$(MAKE) --no-print-directory post-build" + NEWLINE + NEWLINE);
        } else {
            buffer.append(NEWLINE);
        }
        if (enumeratedSecondaryOutputs.size() > 0) {
            String primaryOutput = (String)enumeratedPrimaryOutputs.get(0);
            int i2 = 0;
            while (i2 < enumeratedSecondaryOutputs.size()) {
                String output = (String)enumeratedSecondaryOutputs.get(0);
                buffer.append(String.valueOf(output) + ":" + " " + primaryOutput + NEWLINE);
                ++i2;
            }
            buffer.append(NEWLINE);
        }
        return true;
    }

    private void generateRulesForConsumers(ITool generatingTool, List outputVarsAdditionsList, StringBuffer buffer) {
        IOutputType[] outTypes = generatingTool.getOutputTypes();
        int i = 0;
        while (i < outTypes.length) {
            String[] outExts = outTypes[i].getOutputExtensions(generatingTool);
            String outVariable = outTypes[i].getBuildVariable();
            if (outExts != null) {
                int j = 0;
                while (j < outExts.length) {
                    int k = 0;
                    while (k < this.buildTools.length) {
                        IInputType inType;
                        ITool tool = this.buildTools[k];
                        if (!this.buildToolsUsed[k] && (inType = tool.getInputType(outExts[j])) != null) {
                            String inVariable = inType.getBuildVariable();
                            if ((outVariable == null && inVariable == null || outVariable != null && inVariable != null && outVariable.equals(inVariable)) && this.addRuleForTool(this.buildTools[k], buffer, false, null, null, outputVarsAdditionsList, null, false)) {
                                this.buildToolsUsed[k] = true;
                                this.generateRulesForConsumers(this.buildTools[k], outputVarsAdditionsList, buffer);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean getToolInputsOutputs(ITool tool, Vector inputs, Vector dependencies, Vector outputs, Vector enumeratedPrimaryOutputs, Vector enumeratedSecondaryOutputs, Vector outputVariables, boolean bTargetTool, Vector managedProjectOutputs) {
        ManagedBuildSymbianToolInfo toolInfo = null;
        int i = 0;
        while (i < this.buildTools.length) {
            if (tool == this.buildTools[i]) {
                toolInfo = this.gnuToolInfos[i];
                break;
            }
            ++i;
        }
        if (toolInfo == null) {
            return false;
        }
        inputs.addAll(toolInfo.getCommandInputs());
        outputs.addAll(toolInfo.getCommandOutputs());
        enumeratedPrimaryOutputs.addAll(toolInfo.getEnumeratedPrimaryOutputs());
        enumeratedSecondaryOutputs.addAll(toolInfo.getEnumeratedSecondaryOutputs());
        outputVariables.addAll(toolInfo.getOutputVariables());
        dependencies.addAll(toolInfo.getCommandDependencies());
        if (bTargetTool && managedProjectOutputs != null) {
            Iterator refIter = managedProjectOutputs.listIterator();
            while (refIter.hasNext()) {
                dependencies.add((String)refIter.next());
            }
        }
        return true;
    }

    protected Vector calculateSecondaryOutputs(IOutputType[] secondaryOutputs) {
        Vector<String> buildVars = new Vector<String>();
        int i = 0;
        while (i < this.buildTools.length) {
            IOutputType[] outTypes = this.buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    block2: while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId())) continue;
                            buildVars.add(outType.getBuildVariable());
                            break block2;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return buildVars;
    }

    protected boolean isSecondaryOutputVar(IOutputType[] secondaryOutputs, String varName) {
        int i = 0;
        while (i < this.buildTools.length) {
            IOutputType[] outTypes = this.buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId()) || !outType.getBuildVariable().equals(varName)) continue;
                            return true;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private StringBuffer addSubdirectories() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)MOD_LIST) + NEWLINE);
        buffer.append("SUBDIRS := \\\n");
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer container = (IContainer)iter.next();
            this.updateMonitor(ManagedMakeMessages.getFormattedString((String)"MakefileGenerator.message.adding.source.folder", (String)container.getFullPath().toString()));
            if (container.getFullPath() == this.project.getFullPath()) {
                buffer.append(". \\\n");
                continue;
            }
            IPath path = container.getProjectRelativePath();
            buffer.append(String.valueOf(path.toString()) + " " + "\\\n");
        }
        buffer.append(NEWLINE);
        return buffer;
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return this.addDefaultHeader();
    }

    protected StringBuffer addSources(IContainer module) throws CoreException {
        String macroName;
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? "" : "/");
        relativePath = this.escapeWhitespaces(relativePath);
        LinkedHashMap buildVarToRuleStringMap = new LinkedHashMap();
        for (Map.Entry entry : this.buildSrcVars.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, null, false);
        }
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, "./" + relativePath, false);
        }
        for (Map.Entry entry : this.buildOutVarsForDel.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, "." + File.separator + relativePath.replace("/", File.separator), false);
        }
        this.addMacroAdditionPrefix(buildVarToRuleStringMap, DEPS_MACRO, "./" + relativePath, true);
        StringBuffer buffer = new StringBuffer();
        StringBuffer ruleBuffer = new StringBuffer("# " + ManagedMakeMessages.getResourceString((String)MOD_RULES) + NEWLINE);
        IResource[] resources = module.members();
        IFolder folder = this.project.getFolder(this.info.getConfigurationName());
        int i = 0;
        while (i < resources.length) {
            IResourceConfiguration resConfig;
            IResource resource = resources[i];
            if (!(resource.getType() != 1 || (resConfig = this.config.getResourceConfiguration(resource.getFullPath().toString())) != null && resConfig.isExcluded())) {
                this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, resource, resource.getLocation(), resConfig, null, false);
            }
            ++i;
        }
        buffer.append(this.writeAdditionMacros(buildVarToRuleStringMap));
        return buffer.append(ruleBuffer + NEWLINE);
    }

    protected void addFragmentMakefileEntriesForSource(LinkedHashMap buildVarToRuleStringMap, StringBuffer ruleBuffer, IFolder folder, String relativePath, IResource resource, IPath sourceLocation, IResourceConfiguration resConfig, String varName, boolean generatedSource) {
        ITool[] tools;
        String ext = sourceLocation.getFileExtension();
        ITool tool = null;
        if (resConfig != null && (tools = resConfig.getToolsToInvoke()) != null && tools.length > 0) {
            tool = tools[0];
        }
        int j = 0;
        while (j < this.buildTools.length) {
            if (this.buildTools[j].buildsFileType(ext)) {
                List varList;
                if (tool == null) {
                    tool = this.buildTools[j];
                }
                boolean op = false;
                if (varName == null) {
                    varName = this.getSourceMacroName(ext).toString();
                    varList = (List)this.buildSrcVars.get(varName);
                    varList.add(sourceLocation);
                } else {
                    varList = (List)this.buildOutVars.get(varName);
                    if (varList != null) {
                        varList.add(sourceLocation);
                    }
                    if ((varList = (List)this.buildOutVarsForDel.get(String.valueOf(varName) + FOR_DEL)) != null) {
                        varList.add(sourceLocation);
                    }
                    op = true;
                }
                if (!buildVarToRuleStringMap.containsKey(varName)) break;
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
                if (!op) break;
                this.addMacroAdditionFileForDel(buildVarToRuleStringMap, String.valueOf(varName) + FOR_DEL, relativePath, sourceLocation, generatedSource);
                break;
            }
            ++j;
        }
        if (tool != null) {
            IInputType primaryInputType = tool.getPrimaryInputType();
            IInputType inputType = tool.getInputType(ext);
            if (primaryInputType != null && !primaryInputType.getMultipleOfType() || inputType == null && tool != this.info.getToolFromOutputExtension(this.buildTargetExt)) {
                StringBuffer generatedDepFile = new StringBuffer();
                Vector generatedOutputs = new Vector();
                this.addRuleForSource(relativePath, ruleBuffer, resource, sourceLocation, resConfig, generatedSource, generatedDepFile, generatedOutputs);
                if (generatedDepFile.length() > 0) {
                    this.addMacroAdditionFile(buildVarToRuleStringMap, DEPS_MACRO, generatedDepFile.toString());
                }
                IOutputType outType = tool.getPrimaryOutputType();
                String buildVariable = null;
                if (outType != null) {
                    if (tool.getCustomBuildStep()) {
                        if (generatedOutputs.size() > 0) {
                            IPath firstOutput = (IPath)generatedOutputs.get(0);
                            String firstExt = firstOutput.getFileExtension();
                            int j2 = 0;
                            while (j2 < this.buildTools.length) {
                                String bV;
                                if (this.buildTools[j2].buildsFileType(firstExt) && (bV = this.buildTools[j2].getPrimaryInputType().getBuildVariable()).length() > 0) {
                                    buildVariable = bV;
                                    break;
                                }
                                ++j2;
                            }
                        }
                    } else {
                        buildVariable = outType.getBuildVariable();
                    }
                } else {
                    buildVariable = OBJS_MACRO;
                }
                int k = 0;
                while (k < generatedOutputs.size()) {
                    IPath generatedOutput = ((IPath)generatedOutputs.get(k)).isAbsolute() ? (IPath)generatedOutputs.get(k) : this.project.getLocation().append(this.getBuildWorkingDir()).append((IPath)generatedOutputs.get(k));
                    IFile generateOutputResource = this.project.getFile(generatedOutput);
                    this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, (IResource)generateOutputResource, generatedOutput, null, buildVariable, true);
                    ++k;
                }
            }
        } else if (varName != null) {
            this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
        }
    }

    protected void addRuleForSource(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceConfiguration resConfig, boolean generatedSource, StringBuffer generatedDepFile, Vector enumeratedOutputs) {
        String buildCmd;
        int i;
        boolean doDepGen;
        ITool tool;
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String inputExtension = sourceLocation.getFileExtension();
        String outputExtension = this.info.getOutputExtension(inputExtension);
        if (resConfig != null) {
            ITool[] tools = resConfig.getToolsToInvoke();
            tool = tools[0];
        } else {
            tool = this.info.getToolFromInputExtension(inputExtension);
        }
        IManagedDependencyGenerator depGen = tool.getDependencyGeneratorForExtension(inputExtension);
        boolean bl = doDepGen = depGen != null && depGen.getCalculatorType() == 1;
        if (doDepGen) {
            String depFile = String.valueOf(relativePath) + fileName + "." + "d";
            this.getDependencyMakefiles().add(depFile);
            generatedDepFile.append(String.valueOf(fileName) + "." + "d");
        }
        String OptDotExt = EMPTY_STRING;
        if (outputExtension != null && outputExtension.length() > 0) {
            OptDotExt = "." + outputExtension;
        }
        Vector ruleOutputs = new Vector();
        Vector enumeratedPrimaryOutputs = new Vector();
        Vector enumeratedSecondaryOutputs = new Vector();
        this.calculateOutputsForSource(tool, relativePath, resource, sourceLocation, ruleOutputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs);
        enumeratedOutputs.addAll(enumeratedPrimaryOutputs);
        enumeratedOutputs.addAll(enumeratedSecondaryOutputs);
        String primaryOutputName = null;
        primaryOutputName = enumeratedPrimaryOutputs.size() > 0 ? ((IPath)enumeratedPrimaryOutputs.get(0)).toString() : String.valueOf(relativePath) + fileName + OptDotExt;
        String otherPrimaryOutputs = EMPTY_STRING;
        int i2 = 1;
        while (i2 < enumeratedPrimaryOutputs.size()) {
            otherPrimaryOutputs = String.valueOf(otherPrimaryOutputs) + " " + ((IPath)enumeratedPrimaryOutputs.get(i2)).toString();
            ++i2;
        }
        String projectLocation = this.project.getLocation().toString();
        IPath outputLocation = Path.fromOSString((String)primaryOutputName);
        if (!outputLocation.isAbsolute()) {
            outputLocation = this.project.getLocation().append(this.getBuildWorkingDir()).append(primaryOutputName);
        }
        boolean fileExplicitMacrosReferenced = MacroResolver.getReferencedExplitFileMacros((ITool)tool).length > 0 || MacroResolver.getReferencedExplitFileMacros((String)tool.getToolCommand(), (int)1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)this.config.getToolChain())).length > 0;
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)this.info.getDefaultConfiguration().getToolChain()));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        String defaultOutputName = EMPTY_STRING;
        String primaryDependencyName = EMPTY_STRING;
        String home = generatedSource ? "." : "$(ROOT)";
        String resourcePath = null;
        boolean patternRule = true;
        if (!sourceLocation.toString().startsWith(projectLocation)) {
            resourcePath = sourceLocation.toString();
            defaultOutputName = String.valueOf(relativePath) + fileName + OptDotExt;
            primaryDependencyName = resourcePath;
            patternRule = false;
        } else {
            resourcePath = relativePath;
            if (resConfig != null || fileExplicitMacrosReferenced) {
                defaultOutputName = String.valueOf(resourcePath) + fileName + OptDotExt;
                primaryDependencyName = String.valueOf(home) + "/" + resourcePath + fileName + "." + inputExtension;
                patternRule = false;
            } else {
                defaultOutputName = String.valueOf(relativePath) + "%" + OptDotExt;
                primaryDependencyName = String.valueOf(home) + "/" + resourcePath + "%" + "." + inputExtension;
            }
        }
        if (patternRule) {
            patternRule = false;
            int i3 = 0;
            while (i3 < ruleOutputs.size()) {
                String ruleOutput = ((IPath)ruleOutputs.get(i3)).toString();
                if (ruleOutput.indexOf(37) >= 0) {
                    patternRule = true;
                    break;
                }
                ++i3;
            }
            if (!patternRule) {
                primaryDependencyName = String.valueOf(home) + "/" + resourcePath + fileName + "." + inputExtension;
            }
        }
        String buildRule = EMPTY_STRING;
        if (patternRule) {
            if (ruleOutputs.size() == 0) {
                buildRule = defaultOutputName;
            } else {
                boolean first = true;
                i = 0;
                while (i < ruleOutputs.size()) {
                    String ruleOutput = ((IPath)ruleOutputs.get(i)).toString();
                    if (ruleOutput.indexOf(37) >= 0) {
                        if (first) {
                            first = false;
                        } else {
                            buildRule = String.valueOf(buildRule) + " ";
                        }
                        buildRule = String.valueOf(buildRule) + ruleOutput;
                    }
                    ++i;
                }
            }
        } else {
            buildRule = String.valueOf(buildRule) + primaryOutputName;
        }
        buildRule = String.valueOf(buildRule) + ": " + primaryDependencyName;
        IPath[] addlDepPaths = tool.getAdditionalDependencies();
        i = 0;
        while (i < addlDepPaths.length) {
            IPath tempPath;
            IPath addlPath = addlDepPaths[i];
            if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                addlPath = this.calculateRelativePath(this.getTopBuildDir(), tempPath);
            }
            buildRule = String.valueOf(buildRule) + " " + addlPath.toString();
            ++i;
        }
        if (this.getRuleList().contains(buildRule)) {
            return;
        }
        this.getRuleList().add(buildRule);
        buffer.append(String.valueOf(buildRule) + NEWLINE);
        buffer.append("\t@echo '" + MESSAGE_START_FILE + " " + "$<" + "'" + NEWLINE);
        IManagedCommandLineInfo cmdLInfo = null;
        Vector<String> inputs = new Vector<String>();
        inputs.add("$<");
        String outflag = null;
        String outputPrefix = null;
        if (resConfig != null || fileExplicitMacrosReferenced) {
            buffer.append("\t@echo '" + tool.getAnnouncement() + "'" + NEWLINE);
            outflag = tool.getOutputFlag();
            outputPrefix = tool.getOutputPrefix();
            String[] flags = null;
            try {
                flags = tool.getToolCommandFlags(sourceLocation, outputLocation);
            }
            catch (BuildException buildException) {
                flags = EMPTY_STRING_ARRAY;
            }
            IPath[] addlInputPaths = tool.getAdditionalResources();
            int i4 = 0;
            while (i4 < addlInputPaths.length) {
                IPath tempPath;
                IPath addlPath = addlInputPaths[i4];
                if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                    addlPath = this.calculateRelativePath(this.getTopBuildDir(), tempPath);
                }
                inputs.add(addlPath.toString());
                ++i4;
            }
            IManagedCommandLineGenerator cmdLGen = tool.getCommandLineGenerator();
            cmdLInfo = cmdLGen.generateCommandLineInfo(tool, cmd, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputs.toArray(new String[inputs.size()]), tool.getCommandLinePattern());
            buildCmd = cmdLInfo.getCommandLine();
            buffer.append("\t@echo " + buildCmd + NEWLINE);
            buffer.append("\t@" + buildCmd);
        } else {
            buffer.append("\t@echo '" + tool.getAnnouncement() + "'" + NEWLINE);
            String buildFlags = EMPTY_STRING;
            try {
                buildFlags = tool.getToolCommandFlagsString(sourceLocation, outputLocation);
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            outflag = this.info.getOutputFlag(outputExtension);
            outputPrefix = this.info.getOutputPrefix(outputExtension);
            String[] flags = buildFlags.split("\\s");
            IPath[] addlInputPaths = tool.getAdditionalResources();
            int i5 = 0;
            while (i5 < addlInputPaths.length) {
                IPath tempPath;
                IPath addlPath = addlInputPaths[i5];
                if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                    addlPath = this.calculateRelativePath(this.getTopBuildDir(), tempPath);
                }
                inputs.add(addlPath.toString());
                ++i5;
            }
            cmdLInfo = this.info.generateToolCommandLineInfo(inputExtension, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputs.toArray(new String[inputs.size()]), sourceLocation, outputLocation);
            buildCmd = null;
            buildCmd = cmdLInfo == null ? String.valueOf(cmd) + " " + buildFlags + " " + outflag + " " + outputPrefix + "$@" + otherPrimaryOutputs + " " + "$<" : cmdLInfo.getCommandLine();
            buffer.append("\t@echo " + buildCmd + NEWLINE);
            buffer.append("\t@" + buildCmd);
        }
        if (doDepGen && depGen.getCalculatorType() == 1) {
            buffer.append(" && \\\n");
            String depCmd = depGen.getDependencyCommand(resource, this.info);
            buffer.append(depCmd);
        }
        buffer.append(NEWLINE);
        buffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$<" + "'" + NEWLINE);
        buffer.append("\t@echo ' '" + NEWLINE + NEWLINE);
        boolean addedDepLines = false;
        if (depGen != null && depGen.getCalculatorType() != 1) {
            Vector addlDepsVector = this.calculateDependenciesForSource(depGen, tool, relativePath, resource);
            int i6 = 0;
            while (i6 < addlDepsVector.size()) {
                buffer.append(String.valueOf(primaryOutputName) + ":" + " " + addlDepsVector.get(i6).toString() + NEWLINE);
                addedDepLines = true;
                ++i6;
            }
        }
        int i7 = 1;
        while (i7 < enumeratedPrimaryOutputs.size()) {
            buffer.append(String.valueOf(((IPath)enumeratedPrimaryOutputs.get(i7)).toString()) + ":" + " " + primaryOutputName + NEWLINE);
            addedDepLines = true;
            ++i7;
        }
        i7 = 0;
        while (i7 < enumeratedSecondaryOutputs.size()) {
            buffer.append(String.valueOf(((IPath)enumeratedSecondaryOutputs.get(i7)).toString()) + ":" + " " + primaryOutputName + NEWLINE);
            addedDepLines = true;
            ++i7;
        }
        if (addedDepLines) {
            buffer.append(NEWLINE);
        }
    }

    protected void calculateOutputsForSource(ITool tool, String relativePath, IResource resource, IPath sourceLocation, Vector ruleOutputs, Vector enumeratedPrimaryOutputs, Vector enumeratedSecondaryOutputs) {
        String inExt = sourceLocation.getFileExtension();
        String outExt = tool.getOutputExtension(inExt);
        IOutputType[] outTypes = tool.getOutputTypes();
        if (outTypes != null && outTypes.length > 0) {
            int i = 0;
            while (i < outTypes.length) {
                IPath outPath;
                int j;
                IOutputType type = outTypes[i];
                boolean primaryOutput = type == tool.getPrimaryOutputType();
                String outputPrefix = type.getOutputPrefix();
                boolean multOfType = type.getMultipleOfType();
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                IManagedOutputNameProvider nameProvider = type.getNameProvider();
                String[] outputNames = type.getOutputNames();
                if (option != null) {
                    try {
                        List<String> outputList = new ArrayList<String>();
                        int optType = option.getValueType();
                        if (optType == 2) {
                            outputList.add(String.valueOf(outputPrefix) + option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7) {
                            outputList = (List)option.getValue();
                            if (outputPrefix.length() > 0) {
                                j = 0;
                                while (j < outputList.size()) {
                                    outputList.set(j, String.valueOf(outputPrefix) + outputList.get(j));
                                    ++j;
                                }
                            }
                        }
                        j = 0;
                        while (j < outputList.size()) {
                            outPath = Path.fromOSString((String)((String)outputList.get(j)));
                            if (outPath.segmentCount() == 1) {
                                outPath = Path.fromOSString((String)(String.valueOf(relativePath) + (String)outputList.get(j)));
                            }
                            if (primaryOutput) {
                                ruleOutputs.add(j, outPath);
                                enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                            } else {
                                ruleOutputs.add(outPath);
                                enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                            }
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                } else if (nameProvider != null) {
                    IPath[] inPaths = new IPath[]{sourceLocation};
                    IPath[] outPaths = nameProvider.getOutputNames(tool, inPaths);
                    j = 0;
                    while (j < outPaths.length) {
                        outPath = outPaths[j];
                        if (outPath.segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j, outPath);
                            enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                        }
                        ++j;
                    }
                } else if (outputNames != null) {
                    int j2 = 0;
                    while (j2 < outputNames.length) {
                        IPath outPath2 = Path.fromOSString((String)outputNames[j2]);
                        if (outPath2.segmentCount() == 1) {
                            outPath2 = Path.fromOSString((String)(String.valueOf(relativePath) + outPath2.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j2, outPath2);
                            enumeratedPrimaryOutputs.add(j2, this.resolvePercent(outPath2, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath2);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath2, sourceLocation));
                        }
                        ++j2;
                    }
                } else if (!multOfType) {
                    String namePattern = type.getNamePattern();
                    IPath namePatternPath = null;
                    if (namePattern == null || namePattern.length() == 0) {
                        namePattern = String.valueOf(relativePath) + outputPrefix + "%";
                        if (outExt != null && outExt.length() > 0) {
                            namePattern = String.valueOf(namePattern) + "." + outExt;
                        }
                        namePatternPath = Path.fromOSString((String)namePattern);
                    } else {
                        if (outputPrefix.length() > 0) {
                            namePattern = String.valueOf(outputPrefix) + namePattern;
                        }
                        if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                            namePatternPath = Path.fromOSString((String)(String.valueOf(relativePath) + namePatternPath.toString()));
                        }
                    }
                    if (primaryOutput) {
                        ruleOutputs.add(0, namePatternPath);
                        enumeratedPrimaryOutputs.add(0, this.resolvePercent(namePatternPath, sourceLocation));
                    } else {
                        ruleOutputs.add(namePatternPath);
                        enumeratedSecondaryOutputs.add(this.resolvePercent(namePatternPath, sourceLocation));
                    }
                }
                ++i;
            }
        } else {
            String outPrefix = tool.getOutputPrefix();
            IPath outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPrefix + "%"));
            outPath = outPath.addFileExtension(outExt);
            ruleOutputs.add(0, outPath);
            enumeratedPrimaryOutputs.add(0, this.resolvePercent(outPath, sourceLocation));
        }
    }

    protected IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll("%", fileName);
        return Path.fromOSString((String)outName);
    }

    protected Vector calculateDependenciesForSource(IManagedDependencyGenerator depGen, ITool tool, String relativePath, IResource resource) {
        Vector<IPath> deps = new Vector<IPath>();
        int type = depGen.getCalculatorType();
        switch (type) {
            case 2: 
            case 3: {
                IResource[] res = depGen.findDependencies(resource, this.project);
                int i = 0;
                while (i < res.length) {
                    IPath dep = res[i].getFullPath();
                    deps.add(dep);
                    ++i;
                }
                break;
            }
        }
        return deps;
    }

    public StringBuffer getSourceMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(String.valueOf(extensionName.toUpperCase()) + "_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_SRCS");
        return macroName;
    }

    public Set getOutputExtensions() {
        if (this.outputExtensionsSet == null) {
            this.outputExtensionsSet = new HashSet<String>();
            int i = 0;
            while (i < this.buildTools.length) {
                ITool tool = this.buildTools[i];
                String[] outputs = tool.getAllOutputExtensions();
                if (outputs != null) {
                    this.outputExtensionsSet.addAll((Collection<String>)Arrays.asList(outputs));
                }
                ++i;
            }
        }
        return this.outputExtensionsSet;
    }

    protected StringBuffer addDefaultHeader() {
        StringBuffer buffer = new StringBuffer();
        this.outputCommentLine(buffer);
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)HEADER) + NEWLINE);
        this.outputCommentLine(buffer);
        buffer.append(NEWLINE);
        return buffer;
    }

    protected void outputCommentLine(StringBuffer buffer) {
        int i = 0;
        while (i < 80) {
            buffer.append("#");
            ++i;
        }
        buffer.append(NEWLINE);
    }

    protected String escapeWhitespaces(String path) {
        String[] segments = path.split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    protected void addMacroAdditionPrefix(LinkedHashMap map, String macroName, String relativePath, boolean addPrefix) {
        StringBuffer tempBuffer = new StringBuffer();
        tempBuffer.append(String.valueOf(macroName) + " " + MACRO_ADDITION_PREFIX_SUFFIX);
        if (addPrefix) {
            tempBuffer.append(MACRO_ADDITION_ADDPREFIX_HEADER + relativePath + MACRO_ADDITION_ADDPREFIX_SUFFIX);
        }
        map.put(macroName, tempBuffer.toString());
    }

    protected void addMacroAdditionFile(HashMap map, String macroName, String filename) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        buffer.append(String.valueOf(filename) + " " + "\\\n");
        map.put(macroName, buffer.toString());
    }

    protected void addMacroAdditionFile(HashMap map, String macroName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        String srcName;
        IPath projectLocation;
        IPath dirLocation = projectLocation = this.project.getLocation();
        if (generatedSource) {
            dirLocation = dirLocation.append(this.getBuildWorkingDir());
        }
        if (dirLocation.isPrefixOf(sourceLocation)) {
            IPath srcPath = sourceLocation.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
            srcName = generatedSource ? "./" + srcPath.toString() : "$(ROOT)/" + srcPath.toString();
        } else {
            srcName = generatedSource && !sourceLocation.isAbsolute() ? "./" + relativePath + sourceLocation.lastSegment().toString() : sourceLocation.toString();
        }
        this.addMacroAdditionFile(map, macroName, srcName);
    }

    protected void addMacroAdditionFileForDel(HashMap map, String macroName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        String srcName;
        IPath projectLocation;
        IPath dirLocation = projectLocation = this.project.getLocation();
        if (generatedSource) {
            dirLocation = dirLocation.append(this.getBuildWorkingDir());
        }
        if (relativePath != null) {
            relativePath = relativePath.replace("/", File.separator);
        }
        if (dirLocation.isPrefixOf(sourceLocation)) {
            IPath srcPath = sourceLocation.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
            srcName = generatedSource ? "." + File.separator + srcPath.toOSString() : "$(ROOT)" + File.separator + srcPath.toOSString();
        } else {
            srcName = generatedSource && !sourceLocation.isAbsolute() ? "." + File.separator + relativePath + sourceLocation.lastSegment().toString() : sourceLocation.toOSString();
        }
        this.addMacroAdditionFile(map, macroName, srcName);
    }

    public void addMacroAdditionFiles(HashMap map, String macroName, Vector filenames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        int i = 0;
        while (i < filenames.size()) {
            String filename = (String)filenames.get(i);
            if (filename.length() > 0) {
                buffer.append(String.valueOf(filename) + " " + "\\\n");
            }
            ++i;
        }
        map.put(macroName, buffer.toString());
    }

    protected StringBuffer writeAdditionMacros(LinkedHashMap map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)MOD_VARS) + NEWLINE);
        Collection bufferCollection = map.values();
        Iterator collectionIterator = bufferCollection.iterator();
        while (collectionIterator.hasNext()) {
            String macroString = collectionIterator.next().toString();
            if (macroString.endsWith(MACRO_ADDITION_PREFIX_SUFFIX) || macroString.endsWith(MACRO_ADDITION_ADDPREFIX_SUFFIX)) continue;
            StringBuffer currentBuffer = new StringBuffer();
            if (macroString.indexOf(MACRO_ADDITION_ADDPREFIX_HEADER) >= 0) {
                currentBuffer.append(String.valueOf(macroString) + "}" + NEWLINE);
            } else {
                if (macroString.endsWith("\\\n")) {
                    macroString = String.valueOf(macroString.substring(0, macroString.length() - 2)) + NEWLINE;
                }
                currentBuffer.append(macroString);
            }
            currentBuffer.append(NEWLINE);
            buffer.append(currentBuffer);
        }
        return buffer.append(NEWLINE);
    }

    protected StringBuffer writeTopAdditionMacros(List varList, HashMap varMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)MOD_VARS) + NEWLINE);
        int i = 0;
        while (i < varList.size()) {
            String addition = (String)varMap.get((String)varList.get(i));
            StringBuffer currentBuffer = new StringBuffer();
            currentBuffer.append(addition);
            currentBuffer.append(NEWLINE);
            buffer.append(currentBuffer);
            ++i;
        }
        return buffer.append(NEWLINE);
    }

    protected void calculateToolInputsOutputs() {
        String macroName;
        boolean done = false;
        boolean lastChance = false;
        int[] doneState = new int[this.buildTools.length];
        ITool targetTool = this.config.getTargetTool();
        if (targetTool == null) {
            targetTool = this.info.getToolFromOutputExtension(this.buildTargetExt);
        }
        int i = 0;
        while (i < this.buildTools.length) {
            if (this.buildTools[i] == targetTool) {
                String ext = this.info.getBuildArtifactExtension();
                try {
                    ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, (Object)this.info.getDefaultConfiguration());
                }
                catch (BuildMacroException buildMacroException) {}
                String name = this.info.getBuildArtifactName();
                try {
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, (Object)this.info.getDefaultConfiguration());
                    resolved = resolved.trim();
                    if (resolved.length() > 0) {
                        name = resolved;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                this.gnuToolInfos[i] = new ManagedBuildSymbianToolInfo(this.project, this.buildTools[i], true, name, ext);
            } else {
                this.gnuToolInfos[i] = new ManagedBuildSymbianToolInfo(this.project, this.buildTools[i], false, null, null);
            }
            doneState[i] = 0;
            ++i;
        }
        LinkedHashMap map = this.getTopBuildOutputVars();
        for (Map.Entry entry : this.buildOutVars.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(map, macroName, "", false);
        }
        for (Map.Entry entry : this.buildOutVarsForDel.entrySet()) {
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(map, macroName, "", false);
        }
        HashSet handledDepsInputExtensions = new HashSet();
        HashSet handledOutsInputExtensions = new HashSet();
        while (!done) {
            int[] testState = new int[doneState.length];
            int i2 = 0;
            while (i2 < testState.length) {
                testState[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gnuToolInfos.length) {
                if (this.gnuToolInfos[i2].areInputsCalculated()) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                } else if (this.gnuToolInfos[i2].calculateInputs(this, this.projectResources, lastChance)) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gnuToolInfos.length) {
                if (this.gnuToolInfos[i2].areDependenciesCalculated()) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                } else if (this.gnuToolInfos[i2].calculateDependencies(this, handledDepsInputExtensions, lastChance)) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gnuToolInfos.length) {
                if (this.gnuToolInfos[i2].areOutputsCalculated()) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                } else if (this.gnuToolInfos[i2].calculateOutputs(this, handledOutsInputExtensions, lastChance)) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                }
                ++i2;
            }
            done = true;
            i2 = 0;
            while (i2 < testState.length) {
                if (testState[i2] != 3) {
                    done = false;
                    break;
                }
                ++i2;
            }
            if (!done) {
                done = true;
                i2 = 0;
                while (i2 < testState.length) {
                    if (testState[i2] != doneState[i2]) {
                        done = false;
                        break;
                    }
                    ++i2;
                }
            }
            if (done && !lastChance) {
                lastChance = true;
                done = false;
            }
            if (done) continue;
            doneState = testState;
        }
    }

    public List getBuildVariableList(String variable, int locationType, IPath directory, boolean getAll) {
        boolean done = true;
        int i = 0;
        while (i < this.gnuToolInfos.length) {
            if (!this.gnuToolInfos[i].areOutputVariablesCalculated()) {
                done = false;
            }
            ++i;
        }
        if (!done && getAll) {
            return null;
        }
        List list = (List)this.buildSrcVars.get(variable);
        if (list == null) {
            list = (List)this.buildOutVars.get(variable);
        }
        List fileList = null;
        if (list != null) {
            IPath dirLocation = null;
            if (locationType != 3) {
                dirLocation = this.project.getLocation();
                if (locationType == 2) {
                    dirLocation = dirLocation.append(directory);
                }
            }
            int i2 = 0;
            while (i2 < list.size()) {
                IPath path = (IPath)list.get(i2);
                if (locationType != 3 && dirLocation.isPrefixOf(path)) {
                    path = path.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
                }
                fileList.add(path.toString());
                ++i2;
            }
        }
        return fileList;
    }

    public List getTopBuildVariableList(String variable) {
        return (List)this.topBuildOutVars.get(variable);
    }

    public HashMap getBuildOutputVars() {
        return this.buildOutVars;
    }

    public LinkedHashMap getTopBuildOutputVars() {
        return this.topBuildOutVars;
    }

    protected Vector getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new Vector();
        }
        return this.ruleList;
    }

    protected void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (resource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(container)) {
                this.getInvalidDirList().add(container);
            }
        } else if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    protected void appendDeletedSubdirectory(IContainer container) {
        IContainer parent = container.getParent();
        if (!this.getDeletedDirList().contains(container) && !this.getDeletedDirList().contains(parent)) {
            this.getDeletedDirList().add(container);
        }
    }

    protected void appendDeletedFile(IResource resource) {
        this.getDeletedFileList().add(resource);
    }

    protected void appendModifiedSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (resource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(container)) {
                this.getInvalidDirList().add(container);
            }
        } else if (!this.getModifiedList().contains(container)) {
            this.getModifiedList().add(container);
        }
    }

    protected void cancel(String message) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            throw new OperationCanceledException(message);
        }
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private void deleteBuildTarget(IResource deletedFile) {
        String fileName = this.getFileName(deletedFile);
        String srcExtension = deletedFile.getFileExtension();
        String targetExtension = this.info.getOutputExtension(srcExtension);
        if (targetExtension != "") {
            fileName = String.valueOf(fileName) + "." + targetExtension;
        }
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath targetFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(targetFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private void deleteDepFile(IResource deletedFile) {
        String fileName = this.getFileName(deletedFile);
        fileName = String.valueOf(fileName) + ".d";
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath depFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(depFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private Vector getDeletedDirList() {
        if (this.deletedDirList == null) {
            this.deletedDirList = new Vector();
        }
        return this.deletedDirList;
    }

    private Vector getDeletedFileList() {
        if (this.deletedFileList == null) {
            this.deletedFileList = new Vector();
        }
        return this.deletedFileList;
    }

    private Vector getDependencyMakefiles() {
        if (this.dependencyMakefiles == null) {
            this.dependencyMakefiles = new Vector();
        }
        return this.dependencyMakefiles;
    }

    private String getFileName(IResource file) {
        String answer = new String();
        String lastSegment = file.getName();
        int extensionSeparator = lastSegment.lastIndexOf(".");
        if (extensionSeparator != -1) {
            answer = lastSegment.substring(0, extensionSeparator);
        }
        return answer;
    }

    private Vector getInvalidDirList() {
        if (this.invalidDirList == null) {
            this.invalidDirList = new Vector();
        }
        return this.invalidDirList;
    }

    private Vector getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new Vector();
        }
        return this.modifiedList;
    }

    private Vector getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new Vector();
        }
        return this.subdirList;
    }

    private void removeGeneratedDirectory(IContainer subDir) {
        try {
            if (subDir.exists() && subDir.members().length > 0) {
                return;
            }
        }
        catch (CoreException coreException) {}
        IPath moduleRelativePath = subDir.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        IFolder folder = this.project.getFolder(moduleOutputPath);
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    protected void updateMonitor(String msg) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            this.monitor.subTask(msg);
            this.monitor.worked(1);
        }
    }

    public IPath getTopBuildDir() {
        return this.project.getLocation().append(this.getBuildWorkingDir());
    }

    public IPath calculateRelativePath(IPath container, IPath contents) {
        IPath path = contents;
        if (container.isPrefixOf(contents)) {
            path = contents.setDevice(null).removeFirstSegments(container.segmentCount());
        } else {
            String file = null;
            container = container.addTrailingSeparator();
            if (!contents.hasTrailingSeparator()) {
                file = contents.lastSegment();
                contents = contents.removeLastSegments(1);
                contents = contents.addTrailingSeparator();
            }
            IPath prefix = contents;
            while (prefix.segmentCount() > 0 && !prefix.isPrefixOf(container)) {
                prefix = prefix.removeLastSegments(1);
            }
            if (prefix.segmentCount() > 0) {
                int diff = container.segmentCount() - prefix.segmentCount();
                StringBuffer buff = new StringBuffer();
                while (diff-- > 0) {
                    buff.append("../");
                }
                path = new Path(buff.toString()).append(contents.removeFirstSegments(prefix.segmentCount()));
                if (file != null) {
                    path = path.append(file);
                }
            }
        }
        return path;
    }

    private String[] getLibsForTool(ITool tool) {
        Vector<String> libs = new Vector<String>();
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block10: {
                    IOption option = opts[i];
                    try {
                        IOptionApplicability applicabilitytCalculator;
                        if (option.getValueType() != 6 || (applicabilitytCalculator = option.getApplicabilityCalculator()) != null && !applicabilitytCalculator.isOptionUsedInCommandLine((IBuildObject)this.info.getDefaultConfiguration(), (IHoldsOptions)tool, option)) break block10;
                        String command = option.getCommand();
                        String[] allLibs = option.getLibraries();
                        int j = 0;
                        while (j < allLibs.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(allLibs[j], "", " ", 2, (Object)new OptionContextData(option, (IBuildObject)this.info.getDefaultConfiguration().getToolChain()));
                                if (resolved != null && resolved.length > 0) {
                                    int k = 0;
                                    while (k < resolved.length) {
                                        String string = resolved[k];
                                        if (string.length() > 0) {
                                            libs.add(String.valueOf(command) + string);
                                        }
                                        ++k;
                                    }
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return libs.toArray(new String[libs.size()]);
    }

    protected IPath checkAndCreateBuildDirectory(IManagedBuildInfo info) throws CoreException {
        String dirName = info.getConfigurationName();
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            this.createDirectory(dirName);
        }
        return folder.getFullPath();
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private SymbianMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceDeltaVisitor(SymbianMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean keepLooking = false;
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                String ext = resource.getFileExtension();
                switch (delta.getKind()) {
                    case 1: {
                        if (this.generator.isGeneratedResource(resource) || !this.info.buildsFileType(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        break;
                    }
                    case 2: {
                        if (this.generator.isGeneratedResource(resource) || !this.info.buildsFileType(ext)) break;
                        this.generator.appendDeletedFile(resource);
                        this.generator.appendModifiedSubdirectory(resource);
                        break;
                    }
                    default: {
                        keepLooking = true;
                    }
                }
            }
            if (resource.getType() == 2) {
                switch (delta.getKind()) {
                    case 2: {
                        if (this.generator.isGeneratedResource(resource)) break;
                        this.generator.appendDeletedSubdirectory((IContainer)resource);
                    }
                }
            }
            if (resource.getType() == 4) {
                IResourceDelta[] children = delta.getAffectedChildren();
                if (children != null && children.length > 0) {
                    keepLooking = true;
                }
            } else if (!this.generator.isGeneratedResource(resource)) {
                keepLooking = true;
            }
            return keepLooking;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private SymbianMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceProxyVisitor(SymbianMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (proxy.getType() == 1) {
                String ext;
                IResource resource = proxy.requestResource();
                boolean willBuild = false;
                IResourceConfiguration resConfig = SymbianMakefileGenerator.this.config.getResourceConfiguration(resource.getFullPath().toString());
                if (resConfig != null) {
                    willBuild = true;
                }
                if (!willBuild && this.info.buildsFileType(ext = resource.getFileExtension()) && !this.generator.isGeneratedResource(resource)) {
                    willBuild = true;
                }
                if (willBuild && (resConfig == null || !resConfig.isExcluded())) {
                    this.generator.appendBuildSubdirectory(resource);
                }
                return false;
            }
            return true;
        }
    }
}

