/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;

public class WinscwCompilerCommandLineGenerator
implements IManagedCommandLineGenerator {
    public static final String EMPTY_STRING = "";
    public static final String WHITESPACE = " ";
    public static final String GLOBAL_SYSTEM_INCLUDE_PATHS = "GLOBAL_SYSTEM_INCLUDE_PATHS";
    public static final String GLOBAL_USER_INCLUDE_PATHS = "GLOBAL_USER_INCLUDE_PATHS";
    public static final String INCLUDE_COMMAND = "-i";
    public static final String INCLUDE_EXPLICIT_COMMAND = "-i-";
    public static final String PRE_INCLUDE_COMMAND = "-include";
    public static final String VARIANT_FILE = "VARIANT_FILE";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + WHITESPACE);
        try {
            commandLine.append(String.valueOf(this.includeGlobalIncludesInCommandLine(this.getConfigurationFromTool(tool), flags)) + WHITESPACE);
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        commandLine.append(String.valueOf(outputFlag.trim()) + WHITESPACE);
        commandLine.append(outputPrefix.trim());
        commandLine.append(String.valueOf(outputName.trim()) + WHITESPACE);
        commandLine.append(this.stringArrayToString(inputResources));
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    protected String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + WHITESPACE);
            ++n;
        }
        return sb.toString().trim();
    }

    protected String includeGlobalIncludesInCommandLine(IConfiguration configuration, String[] flags) throws BuildMacroException {
        StringBuffer cmdLineFlags = new StringBuffer();
        String[] stringArray = flags;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String flag = stringArray[n];
            if (flag.compareToIgnoreCase(INCLUDE_EXPLICIT_COMMAND) == 0) {
                String userIncludePath = new String();
                String[] stringArray2 = ManagedBuildManager.getBuildMacroProvider().getMacro(GLOBAL_USER_INCLUDE_PATHS, 3, (Object)configuration, true).getStringValue().split(WHITESPACE);
                int n3 = 0;
                int n4 = stringArray2.length;
                while (n3 < n4) {
                    String path = stringArray2[n3];
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, EMPTY_STRING, WHITESPACE, 3, (Object)configuration);
                    if ((resolved = resolved.trim()).length() > 0) {
                        path = resolved;
                    }
                    userIncludePath = String.valueOf(userIncludePath) + "-i " + path + WHITESPACE;
                    ++n3;
                }
                cmdLineFlags.append(userIncludePath);
                cmdLineFlags.append("-i- ");
                String systemIncludePath = new String();
                String[] stringArray3 = ManagedBuildManager.getBuildMacroProvider().getMacro(GLOBAL_SYSTEM_INCLUDE_PATHS, 3, (Object)configuration, true).getStringValue().split(WHITESPACE);
                n4 = 0;
                int n5 = stringArray3.length;
                while (n4 < n5) {
                    String path = stringArray3[n4];
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(path, EMPTY_STRING, WHITESPACE, 3, (Object)configuration);
                    if ((resolved = resolved.trim()).length() > 0) {
                        path = resolved;
                    }
                    systemIncludePath = String.valueOf(systemIncludePath) + "-i " + path + WHITESPACE;
                    ++n4;
                }
                cmdLineFlags.append(systemIncludePath);
            } else if (flag.toLowerCase().startsWith(PRE_INCLUDE_COMMAND)) {
                cmdLineFlags.append(PRE_INCLUDE_COMMAND + flag.replace(PRE_INCLUDE_COMMAND, WHITESPACE) + WHITESPACE);
            } else {
                cmdLineFlags.append(String.valueOf(flag) + WHITESPACE);
            }
            ++n;
        }
        return cmdLineFlags.toString().trim();
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    protected String preIncludeFileOption(IConfiguration configuration) throws BuildMacroException {
        String variantFile = ManagedBuildManager.getBuildMacroProvider().getMacro(VARIANT_FILE, 3, (Object)configuration, true).getStringValue();
        if (variantFile != null) {
            return "-include \"" + variantFile + "\"" + WHITESPACE;
        }
        return EMPTY_STRING;
    }
}

