/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.cdt.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class WinscwLinkerCommandLineGenerator
implements IManagedCommandLineGenerator {
    public static final String WHITESPACE = " ";
    public static final String MAP_COMMAND = "-map";
    public static final String MAP_FILE_EXT = ".map";
    public static final String EXPORT_COMMAND = "-f";
    public static final String DEF_FILE_EXT = ".def";
    public static final String IMPLIB_COMMAND = "-implib";
    public static final String IMPLIB_FILE_EXT = ".lib";
    public static final String EPOC32_RELEASE_ROOT = "EPOC32_RELEASE_ROOT";
    public static final String WINSCW = "WINSCW";
    public static final String UDEB = "UDEB";
    public static final String UREL = "UREL";
    public static final String DLL = "DLL";
    protected static String EPOC_WINSCW_RELEASE_FOLDER = "";
    protected static String EPOC_WINSCW_RELEASE_UDEB_FOLDER = "";
    protected static String EPOC_WINSCW_RELEASE_UREL_FOLDER = "";

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        this.setOutputFolders(tool);
        StringBuffer commandLine = new StringBuffer();
        commandLine.append(String.valueOf(commandName.trim()) + WHITESPACE);
        commandLine.append(String.valueOf(this.stringArrayToString(flags)) + WHITESPACE);
        commandLine.append(String.valueOf(this.mapCommand(outputName)) + WHITESPACE);
        commandLine.append(String.valueOf(this.dllSpecificCommands(tool, outputName)) + WHITESPACE);
        commandLine.append(String.valueOf(outputFlag.trim()) + WHITESPACE);
        commandLine.append(String.valueOf(this.fullOutputName(tool, outputName).trim()) + WHITESPACE);
        commandLine.append("-search ");
        commandLine.append(this.stringArrayToString(inputResources));
        IProject project = this.getConfigurationFromTool(tool).getOwner().getProject();
        IFile file = project.getFile(String.valueOf(this.getConfigurationFromTool(tool).getName().replace(WHITESPACE, "_").replace('.', '_')) + "_" + outputName);
        try {
            if (!file.isLinked()) {
                file.createLink(Path.fromOSString((String)this.fullOutputName(tool, outputName)), 144, null);
            }
            file.refreshLocal(1, null);
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new ManagedCommandLineInfo(commandLine.toString().trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    protected String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            sb.append(String.valueOf(value) + WHITESPACE);
            ++n;
        }
        return sb.toString().trim();
    }

    protected void setOutputFolders(ITool tool) {
        String releaseRoot = new String("");
        try {
            releaseRoot = ManagedBuildManager.getBuildMacroProvider().getMacro(EPOC32_RELEASE_ROOT, 3, (Object)this.getConfigurationFromTool(tool), true).getStringValue();
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        EPOC_WINSCW_RELEASE_FOLDER = String.valueOf(releaseRoot) + File.separator + WINSCW + File.separator;
        EPOC_WINSCW_RELEASE_UDEB_FOLDER = String.valueOf(EPOC_WINSCW_RELEASE_FOLDER) + UDEB + File.separator;
        EPOC_WINSCW_RELEASE_UREL_FOLDER = String.valueOf(EPOC_WINSCW_RELEASE_FOLDER) + UREL + File.separator;
    }

    protected IConfiguration getConfigurationFromTool(ITool tool) {
        if (tool.getParent() instanceof IToolChain) {
            return ((IToolChain)tool.getParent()).getParent();
        }
        if (tool.getParent() instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)tool.getParent()).getParent();
        }
        return null;
    }

    protected String mapCommand(String outputName) {
        return "-map " + EPOC_WINSCW_RELEASE_UDEB_FOLDER + outputName + MAP_FILE_EXT;
    }

    protected String dllSpecificCommands(ITool tool, String outputName) {
        String dllCommands = new String("");
        IConfiguration config = this.getConfigurationFromTool(tool);
        IProjectType projectType = config.isExtensionElement() ? config.getProjectType() : config.getManagedProject().getProjectType();
        if (projectType != null && projectType.getId().toUpperCase().contains(DLL)) {
            dllCommands = String.valueOf(dllCommands) + "-f ${basename ${notdir " + outputName + "}}" + DEF_FILE_EXT + WHITESPACE;
            dllCommands = String.valueOf(dllCommands) + "-implib " + EPOC_WINSCW_RELEASE_UDEB_FOLDER + "${basename ${notdir " + outputName + "}}" + IMPLIB_FILE_EXT + WHITESPACE;
        }
        return dllCommands;
    }

    protected String getOutputDir(ITool tool) {
        if (this.getConfigurationFromTool(tool).getId().toUpperCase().contains(UDEB)) {
            return EPOC_WINSCW_RELEASE_UDEB_FOLDER;
        }
        return EPOC_WINSCW_RELEASE_UREL_FOLDER;
    }

    protected String fullOutputName(ITool tool, String outputName) {
        return String.valueOf(this.getOutputDir(tool)) + outputName;
    }
}

