/*
============================================================================
 Name        : $(classname).cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(classname) implementation
============================================================================
*/

#include "$(classname).h"

C$(classname)::C$(classname)() : CActive(EPriorityStandard)	// Standard priority
{
}

void C$(classname)::ConstructL()
{
	User::LeaveIfError(iTimer.CreateLocal());	// Initialize timer
	CActiveScheduler::Add(this);				// Add to scheduler
}

C$(classname)::~C$(classname)()
{
	Cancel(); // Cancel any request, if outstanding
	// Delete instance variables if any
}

void C$(classname)::DoCancel()
{
	iTimer.Cancel();
}

void C$(classname)::StartL(TTimeIntervalMicroSeconds32 aDelay)
{
	Cancel();						// Cancel any request, just to be sure
	iState = EUninitialized;
	iTimer.After(iStatus, aDelay);	// Set for later
	SetActive();					// Tell scheduler a request is active
}

void C$(classname)::RunL()
{
	if (iState == EUninitialized) {
		// Do something the first time RunL() is called
		iState = EInitialized;
	} else if (iState != EError) {
		// Do something
	}
	iTimer.After(iStatus, 1000000);	// Set for 1 sec later
	SetActive();					// Tell scheduler a request is active
}
