/*
============================================================================
 Name        : $(viewname)View.cpp
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : C$(viewname)View implementation
============================================================================
*/
/*
What has been done:
The following files were added:
	$(srcDir)/$(viewname)View.cpp
	$(srcDir)/$(viewname)Container.cpp
	$(srcDir)/$(viewname)SettingItemList.cpp
	$(srcDir)/$(viewname)Settings.cpp
	$(incDir)/$(viewname)Container.h
	$(incDir)/$(viewname)SettingItemList.h
	$(incDir)/$(viewname)Settings.h
	$(incDir)/$(viewname)View.h
Lines were appended to the following files:
	$(dataDir)/$(basename).rss
	$(incDir)/$(basename).hrh
	$(incDir)/$(basename).loc
The following libraries were added to the build configuration:
	efsrv.lib -- For class TParseBase etc. (#include <f32file.h>) 
	estor.lib -- For class RWriteStream etc. (#include <s32strm.h>)

TODO:
- Add the view to your application by adding the following into the ConstructL()
  function of your AppUi:
	#include "$(viewname)View.h"
	C$(viewname)View* view2 = C$(viewname)View::NewL();
	CleanupStack::PushL( view2 );
	AddViewL( view2 );      // transfer ownership to CAknViewAppUi
	CleanupStack::Pop();    // view2
- Create a folder for the application under the C drive of the emulator, i.e.:
	<SDK installation path>\Epoc32\wins\c\system\Apps\$(basename)
  The configuration file will be written here.
*/
// INCLUDE FILES
// Class include
#include "$(viewname)View.h"
// System includes
#include <aknviewappui.h>
#include <f32file.h>
#include <s32file.h>
// User includes
#include <$(basename).rsg>
#include "$(basename).hrh"
#include "$(viewname)Container.h"

//TODO: consider defining this in the .hrh file?
const TUid KUidSettingsView = { $(viewid) };

// ================= MEMBER FUNCTIONS =======================

C$(viewname)View* C$(viewname)View::NewL()
{
	C$(viewname)View* self = C$(viewname)View::NewLC();
	CleanupStack::Pop(self);
	return self;
}

C$(viewname)View* C$(viewname)View::NewLC()
{
	C$(viewname)View* self = new (ELeave) C$(viewname)View();
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
}

void C$(viewname)View::ConstructL()
{
	// If you defined resource in another .rss file, don't forget to add it
	// by calling CCoeEnv::AddResourceFileL()
	// Prefix the the given file name with the application installation path and drive letter
	//AknUtils::CompleteWithAppPath(fname);
	//iResourceFileOffset = iEikonEnv->AddResourceFileL(_L("Z:\\system\\apps\\ViewTest\\$(viewname).rsc"));

	BaseConstructL(R_SETTINGS_VIEW);
}

C$(viewname)View::C$(viewname)View()
{
}

C$(viewname)View::~C$(viewname)View()
{
	// Remember to store the offset returned by the AddResourceFileL() and
	// delete the resource when no longer needed with CCoeEnv::DeleteResourceFile(). 
	//iEikonEnv->DeleteResourceFile(iResourceFileOffset);
}


TUid C$(viewname)View::Id() const
{
	//return TUid::Uid(ESettingsView);
	return KUidSettingsView;
}

void C$(viewname)View::HandleCommandL(TInt aCommand)
{
	switch (aCommand) {
		case EAknSoftkeyBack:
			// Save settings
			iContainer->iSettings.StoreL();
			// TODO: Return to the main view
			//AppUi()->ActivateLocalViewL( TUid::Uid(EMyMainViewId) );
			break;
	}
}

void C$(viewname)View::HandleClientRectChange()
{
	if ( iContainer ) {
		iContainer->SetRect( ClientRect() );
	}
}

void C$(viewname)View::DoActivateL(const TVwsViewId& aPrevViewId, TUid aCustomMessageId, const TDesC8& aCustomMessage)
{
	iContainer = C$(viewname)Container::NewL(ClientRect());
	iContainer->SetMopParent(this);
	iContainer->ActivateL();
	AppUi()->AddToStackL(iContainer);
}

void C$(viewname)View::DoDeactivate()
{
	if ( iContainer ) {
		// Removes Container from View control stack.
		AppUi()->RemoveFromStack( iContainer );
	}
	delete iContainer;
	iContainer = NULL;
}
